/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimeExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SQLMethodInvokeExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean removeBrackets;
    protected final List<SQLExpr> arguments = new ArrayList<SQLExpr>();
    protected String methodName;
    protected long methodNameHashCode64;
    protected long hashCode64;
    protected SQLExpr owner;
    protected SQLExpr from;
    protected SQLExpr using;
    protected SQLExpr hasFor;
    protected String trimOption;
    protected transient SQLDataType resolvedReturnDataType;
    private SQLExpr as;
    private SQLExpr content;

    public SQLMethodInvokeExpr() {
        this.removeBrackets = false;
    }

    public SQLMethodInvokeExpr(String methodName) {
        this.methodName = methodName;
        this.removeBrackets = false;
    }

    public SQLMethodInvokeExpr(SQLIdentifierExpr methodName) {
        this.methodName = methodName.name;
        this.methodNameHashCode64 = methodName.hashCode64;
        this.setSource(methodName.getSourceLine(), methodName.getSourceColumn());
        this.removeBrackets = false;
    }

    public SQLMethodInvokeExpr(String methodName, long methodNameHashCode64) {
        this.methodName = methodName;
        this.methodNameHashCode64 = methodNameHashCode64;
        this.removeBrackets = false;
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner) {
        this.methodName = methodName;
        this.setOwner(owner);
        this.removeBrackets = false;
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner, SQLExpr ... params) {
        this.methodName = methodName;
        this.setOwner(owner);
        for (SQLExpr param : params) {
            this.addArgument(param);
        }
        this.removeBrackets = false;
    }

    public SQLMethodInvokeExpr(String methodName, SQLExpr owner, List<SQLExpr> params) {
        this.methodName = methodName;
        this.setOwner(owner);
        for (SQLExpr param : params) {
            this.addArgument(param);
        }
        this.removeBrackets = false;
    }

    public long methodNameHashCode64() {
        if (this.methodNameHashCode64 == 0L && this.methodName != null) {
            this.methodNameHashCode64 = FnvHash.hashCode64(this.methodName);
        }
        return this.methodNameHashCode64;
    }

    public long hashCode64() {
        if (this.hashCode64 == 0L) {
            this.computeHashCode64();
        }
        return this.hashCode64;
    }

    protected void computeHashCode64() {
        long hash;
        if (this.owner instanceof SQLName) {
            hash = ((SQLName)this.owner).hashCode64();
            hash ^= 0x2EL;
            hash *= 1099511628211L;
        } else if (this.owner == null) {
            hash = -3750763034362895579L;
        } else {
            hash = FnvHash.fnv1a_64_lower(this.owner.toString());
            hash ^= 0x2EL;
            hash *= 1099511628211L;
        }
        this.hashCode64 = hash = FnvHash.hashCode64(hash, this.methodName);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.methodNameHashCode64 = 0L;
    }

    public List<SQLExpr> getParameters() {
        return this.arguments;
    }

    public List<SQLExpr> getArguments() {
        return this.arguments;
    }

    public void setArgument(int i, SQLExpr arg) {
        if (arg != null) {
            arg.setParent(this);
        }
        this.arguments.set(i, arg);
    }

    public SQLExpr getArgument(int i) {
        if (i >= 0 && i < this.arguments.size()) {
            return this.arguments.get(i);
        }
        return null;
    }

    public void addParameter(SQLExpr param) {
        if (param != null) {
            param.setParent(this);
        }
        this.arguments.add(param);
    }

    public void addArgument(SQLExpr arg) {
        if (arg != null) {
            arg.setParent(this);
        }
        this.arguments.add(arg);
    }

    public void addArguments(List<SQLExpr> args) {
        for (SQLExpr arg : args) {
            this.addArgument(arg);
        }
    }

    public SQLExpr getOwner() {
        return this.owner;
    }

    public void setOwner(SQLExpr owner) {
        if (owner != null) {
            owner.setParent(this);
        }
        this.owner = owner;
    }

    public SQLExpr getFrom() {
        return this.from;
    }

    public void setFrom(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.from = x;
    }

    @Override
    public void output(StringBuilder buf) {
        if (this.owner != null) {
            this.owner.output(buf);
            buf.append(".");
        }
        if (this.content != null) {
            this.content.output(buf);
            buf.append(' ');
        }
        buf.append(this.methodName);
        buf.append("(");
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            this.arguments.get(i).output(buf);
        }
        if (this.as != null) {
            buf.append(' ');
            this.as.output(buf);
        }
        buf.append(")");
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.content != null) {
                this.acceptChild(visitor, this.content);
            }
            if (this.owner != null) {
                this.owner.accept(visitor);
            }
            for (SQLExpr arg : this.arguments) {
                if (arg == null) continue;
                arg.accept(visitor);
            }
            if (this.from != null) {
                this.from.accept(visitor);
            }
            if (this.using != null) {
                this.using.accept(visitor);
            }
            if (this.hasFor != null) {
                this.hasFor.accept(visitor);
            }
            if (this.as != null) {
                this.acceptChild(visitor, this.as);
            }
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        if (this.owner == null) {
            return this.arguments;
        }
        ArrayList<SQLExpr> children = new ArrayList<SQLExpr>();
        children.add(this.owner);
        children.addAll(this.arguments);
        return children;
    }

    protected void accept0(OracleASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.content != null) {
                this.acceptChild((SQLASTVisitor)visitor, this.content);
            }
            if (this.owner != null) {
                this.owner.accept(visitor);
            }
            for (SQLExpr arg : this.arguments) {
                if (arg == null) continue;
                arg.accept(visitor);
            }
            if (this.from != null) {
                this.from.accept(visitor);
            }
            if (this.using != null) {
                this.using.accept(visitor);
            }
            if (this.hasFor != null) {
                this.hasFor.accept(visitor);
            }
            if (this.as != null) {
                this.acceptChild((SQLASTVisitor)visitor, this.as);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLMethodInvokeExpr that = (SQLMethodInvokeExpr)o;
        if (this.methodNameHashCode64() != that.methodNameHashCode64()) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        if (this.as != null ? !this.as.equals(that.as) : that.as != null) {
            return false;
        }
        if (!this.arguments.equals(that.arguments)) {
            return false;
        }
        return this.from != null ? this.from.equals(that.from) : that.from == null;
    }

    @Override
    public int hashCode() {
        int result = (int)(this.methodNameHashCode64() ^ this.methodNameHashCode64() >>> 32);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }

    @Override
    public SQLMethodInvokeExpr clone() {
        SQLMethodInvokeExpr x = new SQLMethodInvokeExpr();
        this.cloneTo(x);
        return x;
    }

    public void cloneTo(SQLMethodInvokeExpr x) {
        super.cloneTo(x);
        x.methodName = this.methodName;
        if (this.owner != null) {
            x.setOwner(this.owner.clone());
        }
        if (this.content != null) {
            x.setContent(this.content);
        }
        for (SQLExpr sQLExpr : this.arguments) {
            x.addArgument(sQLExpr.clone());
        }
        if (this.from != null) {
            x.setFrom(this.from.clone());
        }
        if (this.using != null) {
            x.setUsing(this.using.clone());
        }
        if (this.trimOption != null) {
            x.setTrimOption(this.trimOption);
        }
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof SQLObject) {
                    value = ((SQLObject)value).clone();
                }
                x.putAttribute(key, value);
            }
        }
        x.setRemoveBrackets(this.removeBrackets);
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (target == null) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (this.arguments.get(i) != expr) continue;
            this.arguments.set(i, target);
            target.setParent(this);
            return true;
        }
        if (this.from == expr) {
            this.setFrom(target);
            return true;
        }
        if (this.using == expr) {
            this.setUsing(target);
            return true;
        }
        if (this.hasFor == expr) {
            this.setFor(target);
            return true;
        }
        return false;
    }

    public boolean match(String owner, String function) {
        if (function == null) {
            return false;
        }
        if (!SQLUtils.nameEquals(function, this.methodName)) {
            return false;
        }
        if (owner == null && this.owner == null) {
            return true;
        }
        if (owner == null || this.owner == null) {
            return false;
        }
        if (this.owner instanceof SQLIdentifierExpr) {
            return SQLUtils.nameEquals(((SQLIdentifierExpr)this.owner).name, owner);
        }
        return false;
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.resolvedReturnDataType != null) {
            return this.resolvedReturnDataType;
        }
        long nameHash = this.methodNameHashCode64();
        if (nameHash == FnvHash.Constants.TO_DATE || nameHash == FnvHash.Constants.ADD_MONTHS) {
            this.resolvedReturnDataType = SQLDateExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.DATE_PARSE) {
            this.resolvedReturnDataType = SQLTimestampExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.CURRENT_TIME || nameHash == FnvHash.Constants.CURTIME) {
            this.resolvedReturnDataType = SQLTimeExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.BIT_COUNT || nameHash == FnvHash.Constants.ROW_NUMBER) {
            this.resolvedReturnDataType = new SQLDataTypeImpl("BIGINT");
            return this.resolvedReturnDataType;
        }
        if (this.arguments.size() == 1) {
            if (nameHash == FnvHash.Constants.TRUNC) {
                this.resolvedReturnDataType = this.arguments.get(0).computeDataType();
                return this.resolvedReturnDataType;
            }
        } else if (this.arguments.size() == 2) {
            SQLExpr param0 = this.arguments.get(0);
            SQLExpr param1 = this.arguments.get(1);
            if (nameHash == FnvHash.Constants.ROUND) {
                SQLDataType dataType = param0.computeDataType();
                if (dataType != null) {
                    return dataType;
                }
            } else if (nameHash == FnvHash.Constants.NVL || nameHash == FnvHash.Constants.IFNULL || nameHash == FnvHash.Constants.ISNULL || nameHash == FnvHash.Constants.COALESCE) {
                SQLDataType dataType = param0.computeDataType();
                if (dataType != null) {
                    return dataType;
                }
                return param1.computeDataType();
            }
            if (nameHash == FnvHash.Constants.MOD) {
                this.resolvedReturnDataType = SQLIntegerExpr.DATA_TYPE;
                return this.resolvedReturnDataType;
            }
        }
        if (nameHash == FnvHash.Constants.STDDEV_SAMP) {
            this.resolvedReturnDataType = SQLNumberExpr.DATA_TYPE_DOUBLE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.CONCAT || nameHash == FnvHash.Constants.SUBSTR || nameHash == FnvHash.Constants.SUBSTRING) {
            this.resolvedReturnDataType = SQLCharExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.YEAR || nameHash == FnvHash.Constants.MONTH || nameHash == FnvHash.Constants.DAY || nameHash == FnvHash.Constants.HOUR || nameHash == FnvHash.Constants.MINUTE || nameHash == FnvHash.Constants.SECOND || nameHash == FnvHash.Constants.PERIOD_ADD || nameHash == FnvHash.Constants.PERIOD_DIFF) {
            this.resolvedReturnDataType = new SQLDataTypeImpl("INT");
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.GROUPING) {
            this.resolvedReturnDataType = new SQLDataTypeImpl("INT");
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.JSON_EXTRACT_SCALAR || nameHash == FnvHash.Constants.FORMAT_DATETIME || nameHash == FnvHash.Constants.DATE_FORMAT) {
            this.resolvedReturnDataType = SQLCharExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.DATE_ADD || nameHash == FnvHash.Constants.DATE_SUB || nameHash == FnvHash.Constants.DATE || nameHash == FnvHash.Constants.STR_TO_DATE || nameHash == FnvHash.Constants.CURRENT_DATE) {
            this.resolvedReturnDataType = SQLDateExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.UNIX_TIMESTAMP) {
            this.resolvedReturnDataType = SQLIntegerExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.TIME) {
            this.resolvedReturnDataType = new SQLDataTypeImpl("VARCHAR");
            return this.resolvedReturnDataType;
        }
        if (nameHash == FnvHash.Constants.SYSDATE || nameHash == FnvHash.Constants.CURRENT_TIMESTAMP || nameHash == FnvHash.Constants.SYSTIMESTAMP) {
            this.resolvedReturnDataType = SQLTimestampExpr.DATA_TYPE;
            return this.resolvedReturnDataType;
        }
        return null;
    }

    public SQLExpr getUsing() {
        return this.using;
    }

    public void setUsing(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.using = x;
    }

    public SQLExpr getFor() {
        return this.hasFor;
    }

    public void setFor(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.hasFor = x;
    }

    public String getTrimOption() {
        return this.trimOption;
    }

    public void setTrimOption(String trimOption) {
        this.trimOption = trimOption;
    }

    public SQLDataType getResolvedReturnDataType() {
        return this.resolvedReturnDataType;
    }

    public void setResolvedReturnDataType(SQLDataType resolvedReturnDataType) {
        this.resolvedReturnDataType = resolvedReturnDataType;
    }

    public SQLExpr getAs() {
        return this.as;
    }

    public void setAs(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.as = x;
    }

    public SQLExpr getContent() {
        return this.content;
    }

    public void setContent(SQLExpr x) {
        if (x != null) {
            x.setParent(this);
        }
        this.content = x;
    }

    public boolean isRemoveBrackets() {
        return this.removeBrackets;
    }

    public void setRemoveBrackets(boolean removeBrackets) {
        this.removeBrackets = removeBrackets;
    }
}

