/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.clickhouse.parser;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLAlterStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.clickhouse.ast.CKAlterTableUpdateStatement;
import com.alibaba.druid.sql.dialect.clickhouse.parser.CKCreateTableParser;
import com.alibaba.druid.sql.dialect.clickhouse.parser.CKExprParser;
import com.alibaba.druid.sql.dialect.clickhouse.parser.CKSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;

public class CKStatementParser
extends SQLStatementParser {
    public CKStatementParser(String sql) {
        super(new CKExprParser(sql));
    }

    public CKStatementParser(String sql, SQLParserFeature ... features) {
        super(new CKExprParser(sql, features));
    }

    public CKStatementParser(Lexer lexer) {
        super(new CKExprParser(lexer));
    }

    @Override
    public SQLSelectParser createSQLSelectParser() {
        return new CKSelectParser(this.exprParser, this.selectListCache);
    }

    @Override
    public SQLWithSubqueryClause parseWithQuery() {
        return this.createSQLSelectParser().parseWith();
    }

    @Override
    public SQLCreateTableParser getSQLCreateTableParser() {
        return new CKCreateTableParser(this.exprParser);
    }

    @Override
    protected SQLAlterStatement alterTable() {
        Lexer.SavePoint mark = this.lexer.mark();
        this.accept(Token.ALTER);
        this.accept(Token.TABLE);
        SQLName tableName = this.exprParser.name();
        SQLName clusterName = null;
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier("CLUSTER");
            clusterName = this.exprParser.name();
        }
        if (this.lexer.token() == Token.UPDATE) {
            CKAlterTableUpdateStatement stmt = new CKAlterTableUpdateStatement(this.getDbType());
            stmt.setTableName(tableName);
            stmt.setClusterName(clusterName);
            this.lexer.nextToken();
            while (true) {
                SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                stmt.getItems().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            SQLName partitionId = null;
            if (this.lexer.token() == Token.IN) {
                this.lexer.nextToken();
                this.accept(Token.PARTITION);
                partitionId = this.exprParser.name();
            }
            stmt.setPartitionId(partitionId);
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                stmt.setWhere(this.exprParser.expr());
            }
            return stmt;
        }
        this.lexer.reset(mark);
        return super.alterTable();
    }

    @Override
    protected SQLAlterStatement alterTableAfterName(SQLAlterTableStatement stmt) {
        if (this.lexer.token() == Token.ON) {
            this.lexer.nextToken();
            this.acceptIdentifier("CLUSTER");
            stmt.setOn(this.exprParser.name());
        }
        return super.alterTableAfterName(stmt);
    }

    @Override
    public void parseCreateViewAfterName(SQLCreateViewStatement createView) {
        if (this.dbType == DbType.clickhouse) {
            if (this.lexer.token() == Token.ON) {
                this.lexer.nextToken();
                this.acceptIdentifier("CLUSTER");
                createView.setOnCluster(true);
            }
            if (this.lexer.token() == Token.LITERAL_CHARS) {
                SQLName to = this.exprParser.name();
                createView.setTo(to);
            } else if (this.lexer.token() == Token.TO) {
                this.lexer.nextToken();
                SQLName to = this.exprParser.name();
                createView.setTo(to);
            }
        }
    }
}

