/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.DbType;
import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.TransactionTimeoutException;
import com.alibaba.druid.VERSION;
import com.alibaba.druid.filter.AutoLoad;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.FilterChainImpl;
import com.alibaba.druid.mock.MockDriver;
import com.alibaba.druid.pool.DataSourceClosedException;
import com.alibaba.druid.pool.DataSourceDisableException;
import com.alibaba.druid.pool.DataSourceNotAvailableException;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidConnectionHolder;
import com.alibaba.druid.pool.DruidDataSourceMBean;
import com.alibaba.druid.pool.DruidDataSourceStatLogger;
import com.alibaba.druid.pool.DruidDataSourceStatValue;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.GetConnectionTimeoutException;
import com.alibaba.druid.pool.ManagedDataSource;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.PreparedStatementPool;
import com.alibaba.druid.pool.vendor.DB2ExceptionSorter;
import com.alibaba.druid.pool.vendor.InformixExceptionSorter;
import com.alibaba.druid.pool.vendor.MSSQLValidConnectionChecker;
import com.alibaba.druid.pool.vendor.MockExceptionSorter;
import com.alibaba.druid.pool.vendor.MySqlExceptionSorter;
import com.alibaba.druid.pool.vendor.MySqlValidConnectionChecker;
import com.alibaba.druid.pool.vendor.NullExceptionSorter;
import com.alibaba.druid.pool.vendor.OceanBaseOracleExceptionSorter;
import com.alibaba.druid.pool.vendor.OceanBaseValidConnectionChecker;
import com.alibaba.druid.pool.vendor.OracleExceptionSorter;
import com.alibaba.druid.pool.vendor.OracleValidConnectionChecker;
import com.alibaba.druid.pool.vendor.PGExceptionSorter;
import com.alibaba.druid.pool.vendor.PGValidConnectionChecker;
import com.alibaba.druid.pool.vendor.SybaseExceptionSorter;
import com.alibaba.druid.proxy.DruidDriver;
import com.alibaba.druid.proxy.jdbc.DataSourceProxyConfig;
import com.alibaba.druid.proxy.jdbc.TransactionInfo;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.stat.JdbcSqlStat;
import com.alibaba.druid.stat.JdbcSqlStatValue;
import com.alibaba.druid.support.clickhouse.BalancedClickhouseDriver;
import com.alibaba.druid.support.clickhouse.BalancedClickhouseDriverNative;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.DruidDataSourceUtils;
import com.alibaba.druid.util.JMXUtils;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.WallFilter;
import com.alibaba.druid.wall.WallProviderStatValue;
import java.io.Closeable;
import java.io.Serializable;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class DruidDataSource
extends DruidAbstractDataSource
implements DruidDataSourceMBean,
ManagedDataSource,
Referenceable,
Closeable,
Cloneable,
ConnectionPoolDataSource,
MBeanRegistration {
    private static final Log LOG = LogFactory.getLog(DruidDataSource.class);
    private static final long serialVersionUID = 1L;
    private volatile long recycleErrorCount;
    private volatile long discardErrorCount;
    private volatile Throwable discardErrorLast;
    private long connectCount;
    private long closeCount;
    private volatile long connectErrorCount;
    private long recycleCount;
    private long removeAbandonedCount;
    private long notEmptyWaitCount;
    private long notEmptySignalCount;
    private long notEmptyWaitNanos;
    private int keepAliveCheckCount;
    private int activePeak;
    private long activePeakTime;
    private int poolingPeak;
    private long poolingPeakTime;
    private volatile int keepAliveCheckErrorCount;
    private volatile Throwable keepAliveCheckErrorLast;
    private volatile DruidConnectionHolder[] connections;
    private int poolingCount;
    private int activeCount;
    private volatile int createDirectCount;
    private volatile long discardCount;
    private int notEmptyWaitThreadCount;
    private int notEmptyWaitThreadPeak;
    private DruidConnectionHolder[] evictConnections;
    private DruidConnectionHolder[] keepAliveConnections;
    private volatile DruidConnectionHolder[] nullConnections;
    private volatile ScheduledFuture<?> destroySchedulerFuture;
    private DestroyTask destroyTask;
    private final Map<CreateConnectionTask, Future<?>> createSchedulerFutures = new ConcurrentHashMap(16);
    private CreateConnectionThread createConnectionThread;
    private DestroyConnectionThread destroyConnectionThread;
    private LogStatsThread logStatsThread;
    private int createTaskCount;
    private volatile long createTaskIdSeed = 1L;
    private long[] createTasks;
    private volatile boolean enable = true;
    private boolean resetStatEnable = true;
    private volatile long resetCount;
    private String initStackTrace;
    private volatile boolean closing;
    private volatile boolean closed;
    private long closeTimeMillis = -1L;
    protected JdbcDataSourceStat dataSourceStat;
    private boolean useGlobalDataSourceStat;
    private boolean mbeanRegistered;
    private boolean logDifferentThread = true;
    private volatile boolean keepAlive;
    private boolean asyncInit;
    protected boolean killWhenSocketReadTimeout;
    protected boolean checkExecuteTime;
    private static List<Filter> autoFilters;
    private boolean loadSpifilterSkip;
    private volatile DataSourceDisableException disableException;
    protected static final AtomicLongFieldUpdater<DruidDataSource> recycleErrorCountUpdater;
    protected static final AtomicLongFieldUpdater<DruidDataSource> connectErrorCountUpdater;
    protected static final AtomicLongFieldUpdater<DruidDataSource> resetCountUpdater;
    protected static final AtomicLongFieldUpdater<DruidDataSource> createTaskIdSeedUpdater;
    protected static final AtomicLongFieldUpdater<DruidDataSource> discardErrorCountUpdater;
    protected static final AtomicIntegerFieldUpdater<DruidDataSource> keepAliveCheckErrorCountUpdater;
    protected static final AtomicIntegerFieldUpdater<DruidDataSource> createDirectCountUpdater;
    protected String instanceKey;

    public DruidDataSource() {
        this(false);
    }

    public DruidDataSource(boolean fairLock) {
        super(fairLock);
        this.configFromPropeties(System.getProperties());
    }

    public boolean isAsyncInit() {
        return this.asyncInit;
    }

    public void setAsyncInit(boolean asyncInit) {
        this.asyncInit = asyncInit;
    }

    @Deprecated
    public void configFromPropety(Properties properties) {
        this.configFromPropeties(properties);
    }

    @Deprecated
    public void configFromPropeties(Properties properties) {
        this.configFromProperties(properties);
    }

    public void configFromProperties(Properties properties) {
        boolean init;
        this.lock.lock();
        try {
            init = this.inited;
        }
        finally {
            this.lock.unlock();
        }
        if (init) {
            this.configFromPropertiesAfterInit(properties);
        } else {
            DruidDataSourceUtils.configFromProperties(this, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configFromPropertiesAfterInit(Properties properties) {
        boolean result;
        String connectUrl;
        boolean urlUserPasswordChanged;
        String username;
        String url = properties.getProperty("druid.url");
        if (url != null) {
            url = url.trim();
        }
        if ((username = properties.getProperty("druid.username")) != null) {
            username = username.trim();
        }
        String password = properties.getProperty("druid.password");
        Properties connectProperties = new Properties();
        this.lock.lock();
        try {
            String connectPassword;
            String connectUser;
            urlUserPasswordChanged = url != null && !this.jdbcUrl.equals(url) || username != null && !username.equals(this.username) || password != null && !password.equals(this.password);
            String string = connectUser = username != null ? username : this.username;
            if (username != null) {
                connectProperties.put("user", connectUser);
            }
            String string2 = connectPassword = password != null ? password : this.password;
            if (connectPassword != null) {
                connectProperties.put("password", connectPassword);
            }
            connectUrl = url != null ? url : this.jdbcUrl;
        }
        finally {
            this.lock.unlock();
        }
        if (urlUserPasswordChanged) {
            Connection conn = null;
            try {
                conn = this.getDriver().connect(connectUrl, connectProperties);
                LOG.info("check connection info success");
            }
            catch (SQLException e) {
                try {
                    throw new DruidRuntimeException("check connection info failed", e);
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(conn);
                    throw throwable;
                }
            }
            JdbcUtils.close(conn);
        }
        this.lock.lock();
        try {
            Integer initialSize;
            if (urlUserPasswordChanged) {
                if (url != null && !url.equals(this.jdbcUrl)) {
                    this.jdbcUrl = url;
                    LOG.info("jdbcUrl changed");
                }
                if (username != null && !username.equals(this.username)) {
                    this.username = username;
                    LOG.info("username changed");
                }
                if (password != null && !password.equals(this.password)) {
                    this.password = password;
                    LOG.info("password changed");
                }
                this.incrementUserPasswordVersion();
            }
            if ((initialSize = DruidDataSourceUtils.getPropertyInt(properties, "druid.initialSize")) != null) {
                this.initialSize = initialSize;
            }
            Integer maxActive = DruidDataSourceUtils.getPropertyInt(properties, "druid.maxActive");
            Integer minIdle = DruidDataSourceUtils.getPropertyInt(properties, "druid.minIdle");
            if (maxActive != null || minIdle != null) {
                int compareMinIdle;
                int compareMaxActive = maxActive != null ? maxActive : this.maxActive;
                int n = compareMinIdle = minIdle != null ? minIdle : this.minIdle;
                if (compareMaxActive < compareMinIdle) {
                    throw new IllegalArgumentException("maxActive less than minIdle, " + compareMaxActive + " < " + compareMinIdle);
                }
            }
            if (maxActive != null) {
                this.maxActive = maxActive;
            }
            if (minIdle != null) {
                this.minIdle = minIdle;
            }
            DruidDataSourceUtils.configFromProperties(this, properties);
        }
        finally {
            this.lock.unlock();
        }
        int replaceCount = 0;
        while (this.hasOlderVersionUrlUserPasswordConnection()) {
            try {
                DruidAbstractDataSource.PhysicalConnectionInfo phyConnInfo = this.createPhysicalConnection();
                result = false;
                this.lock.lock();
                try {
                    for (int i = this.poolingCount - 1; i >= 0; --i) {
                        if (this.connections[i].getUserPasswordVersion() >= this.userPasswordVersion) continue;
                        this.connections[i] = new DruidConnectionHolder(this, phyConnInfo);
                        result = true;
                        ++replaceCount;
                        break;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (result) continue;
                JdbcUtils.close(phyConnInfo.getPhysicalConnection());
                LOG.info("replace older version urlUserPassword failed.");
                break;
            }
            catch (SQLException e) {
                LOG.error("fill init connection error", e);
            }
        }
        if (replaceCount > 0) {
            LOG.info("replace older version urlUserPassword Connection : " + replaceCount);
        }
        while (this.isLowWaterLevel()) {
            try {
                DruidAbstractDataSource.PhysicalConnectionInfo physicalConnection = this.createPhysicalConnection();
                result = this.put(physicalConnection);
                if (result) continue;
                JdbcUtils.close(physicalConnection.getPhysicalConnection());
                LOG.info("put physical connection to pool failed.");
            }
            catch (SQLException e) {
                LOG.error("fill init connection error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasOlderVersionUrlUserPasswordConnection() {
        this.lock.lock();
        try {
            long userPasswordVersion = this.userPasswordVersion;
            for (int i = 0; i < this.poolingCount; ++i) {
                if (this.connections[i].getUserPasswordVersion() >= userPasswordVersion) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    private boolean isLowWaterLevel() {
        this.lock.lock();
        try {
            boolean bl = this.activeCount + this.poolingCount < this.minIdle;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isKillWhenSocketReadTimeout() {
        return this.killWhenSocketReadTimeout;
    }

    public void setKillWhenSocketReadTimeout(boolean killWhenSocketTimeOut) {
        this.killWhenSocketReadTimeout = killWhenSocketTimeOut;
    }

    @Override
    public boolean isUseGlobalDataSourceStat() {
        return this.useGlobalDataSourceStat;
    }

    public void setUseGlobalDataSourceStat(boolean useGlobalDataSourceStat) {
        this.useGlobalDataSourceStat = useGlobalDataSourceStat;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public String getInitStackTrace() {
        return this.initStackTrace;
    }

    @Override
    public boolean isResetStatEnable() {
        return this.resetStatEnable;
    }

    @Override
    public void setResetStatEnable(boolean resetStatEnable) {
        this.resetStatEnable = resetStatEnable;
        if (this.dataSourceStat != null) {
            this.dataSourceStat.setResetStatEnable(resetStatEnable);
        }
    }

    @Override
    public long getDiscardCount() {
        return this.discardCount;
    }

    public void restart() throws SQLException {
        this.restart(null);
    }

    public void restart(Properties properties) throws SQLException {
        this.lock.lock();
        try {
            if (this.activeCount > 0) {
                throw new SQLException("can not restart, activeCount not zero. " + this.activeCount);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("{dataSource-" + this.getID() + "} restart");
            }
            this.close();
            this.resetStat();
            this.inited = false;
            this.enable = true;
            this.closed = false;
            if (properties != null) {
                DruidDataSourceUtils.configFromProperties(this, properties);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetStat() {
        if (!this.isResetStatEnable()) {
            return;
        }
        this.lock.lock();
        try {
            this.connectCount = 0L;
            this.closeCount = 0L;
            this.discardCount = 0L;
            this.recycleCount = 0L;
            this.createCount = 0L;
            this.directCreateCount = 0;
            this.destroyCount = 0L;
            this.removeAbandonedCount = 0L;
            this.notEmptyWaitCount = 0L;
            this.notEmptySignalCount = 0L;
            this.notEmptyWaitNanos = 0L;
            this.activePeak = this.activeCount;
            this.activePeakTime = 0L;
            this.poolingPeak = 0;
            this.createTimespan = 0L;
            this.lastError = null;
            this.lastErrorTimeMillis = 0L;
            this.lastCreateError = null;
            this.lastCreateErrorTimeMillis = 0L;
        }
        finally {
            this.lock.unlock();
        }
        connectErrorCountUpdater.set(this, 0L);
        errorCountUpdater.set(this, 0L);
        commitCountUpdater.set(this, 0L);
        rollbackCountUpdater.set(this, 0L);
        startTransactionCountUpdater.set(this, 0L);
        cachedPreparedStatementHitCountUpdater.set(this, 0L);
        closedPreparedStatementCountUpdater.set(this, 0L);
        preparedStatementCountUpdater.set(this, 0L);
        this.transactionHistogram.reset();
        cachedPreparedStatementDeleteCountUpdater.set(this, 0L);
        recycleErrorCountUpdater.set(this, 0L);
        resetCountUpdater.incrementAndGet(this);
    }

    @Override
    public long getResetCount() {
        return this.resetCount;
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public void setEnable(boolean enable) {
        this.lock.lock();
        try {
            this.enable = enable;
            if (!enable) {
                this.notEmpty.signalAll();
                ++this.notEmptySignalCount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setPoolPreparedStatements(boolean value) {
        this.setPoolPreparedStatements0(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPoolPreparedStatements0(boolean value) {
        if (this.poolPreparedStatements == value) {
            return;
        }
        this.poolPreparedStatements = value;
        if (!this.inited) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("set poolPreparedStatements " + this.poolPreparedStatements + " -> " + value);
        }
        if (!value) {
            this.lock.lock();
            try {
                for (int i = 0; i < this.poolingCount; ++i) {
                    DruidConnectionHolder connection = this.connections[i];
                    for (PreparedStatementHolder holder : connection.getStatementPool().getMap().values()) {
                        this.closePreapredStatement(holder);
                    }
                    connection.getStatementPool().getMap().clear();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void setMaxActive(int maxActive) {
        if (this.maxActive == maxActive) {
            return;
        }
        if (maxActive == 0) {
            throw new IllegalArgumentException("maxActive can't not set zero");
        }
        if (!this.inited) {
            this.maxActive = maxActive;
            return;
        }
        if (maxActive < this.minIdle) {
            throw new IllegalArgumentException("maxActive less than minIdle, " + maxActive + " < " + this.minIdle);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("maxActive changed : " + this.maxActive + " -> " + maxActive);
        }
        this.lock.lock();
        try {
            int allCount = this.poolingCount + this.activeCount;
            if (maxActive > allCount) {
                this.connections = Arrays.copyOf(this.connections, maxActive);
                this.evictConnections = new DruidConnectionHolder[maxActive];
                this.keepAliveConnections = new DruidConnectionHolder[maxActive];
                this.nullConnections = new DruidConnectionHolder[maxActive];
            } else {
                this.connections = Arrays.copyOf(this.connections, allCount);
                this.evictConnections = new DruidConnectionHolder[allCount];
                this.keepAliveConnections = new DruidConnectionHolder[allCount];
                this.nullConnections = new DruidConnectionHolder[allCount];
            }
            this.maxActive = maxActive;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setConnectProperties(Properties properties) {
        boolean equals;
        if (properties == null) {
            properties = new Properties();
        }
        if (properties.size() == this.connectProperties.size()) {
            equals = true;
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (Objects.equals(this.connectProperties.get(entry.getKey()), entry.getValue())) continue;
                equals = false;
                break;
            }
        } else {
            equals = false;
        }
        if (!equals) {
            if (this.inited && LOG.isInfoEnabled()) {
                LOG.info("connectProperties changed : " + this.connectProperties + " -> " + properties);
            }
            this.configFromPropeties(properties);
            for (Filter filter : this.filters) {
                filter.configFromProperties(properties);
            }
            if (this.exceptionSorter != null) {
                this.exceptionSorter.configFromProperties(properties);
            }
            if (this.validConnectionChecker != null) {
                this.validConnectionChecker.configFromProperties(properties);
            }
            if (this.statLogger != null) {
                this.statLogger.configFromProperties(properties);
            }
        }
        this.connectProperties = properties;
    }

    public void init() throws SQLException {
        if (this.inited) {
            return;
        }
        DruidDriver.getInstance();
        ReentrantLock lock = this.lock;
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new SQLException("interrupt", e);
        }
        boolean init = false;
        try {
            int i;
            DbType dbType;
            if (this.inited) {
                return;
            }
            this.initStackTrace = Utils.toString(Thread.currentThread().getStackTrace());
            this.id = DruidDriver.createDataSourceId();
            if (this.id > 1L) {
                long delta = (this.id - 1L) * 100000L;
                connectionIdSeedUpdater.addAndGet(this, delta);
                statementIdSeedUpdater.addAndGet(this, delta);
                resultSetIdSeedUpdater.addAndGet(this, delta);
                transactionIdSeedUpdater.addAndGet(this, delta);
            }
            if (this.jdbcUrl != null) {
                this.jdbcUrl = this.jdbcUrl.trim();
                this.initFromWrapDriverUrl();
            }
            this.initTimeoutsFromUrlOrProperties();
            for (Filter filter : this.filters) {
                filter.init(this);
            }
            if (this.dbTypeName == null || this.dbTypeName.length() == 0) {
                this.dbTypeName = JdbcUtils.getDbType(this.jdbcUrl, null);
            }
            if (JdbcUtils.isMysqlDbType(dbType = DbType.of(this.dbTypeName))) {
                boolean cacheServerConfigurationSet = false;
                if (this.connectProperties.containsKey("cacheServerConfiguration")) {
                    cacheServerConfigurationSet = true;
                } else if (this.jdbcUrl.indexOf("cacheServerConfiguration") != -1) {
                    cacheServerConfigurationSet = true;
                }
                if (cacheServerConfigurationSet) {
                    this.connectProperties.put("cacheServerConfiguration", "true");
                }
            }
            if (this.maxActive <= 0) {
                throw new IllegalArgumentException("illegal maxActive " + this.maxActive);
            }
            if (this.maxActive < this.minIdle) {
                throw new IllegalArgumentException("illegal maxActive " + this.maxActive);
            }
            if (this.getInitialSize() > this.maxActive) {
                throw new IllegalArgumentException("illegal initialSize " + this.initialSize + ", maxActive " + this.maxActive);
            }
            if (this.timeBetweenLogStatsMillis > 0L && this.useGlobalDataSourceStat) {
                throw new IllegalArgumentException("timeBetweenLogStatsMillis not support useGlobalDataSourceStat=true");
            }
            if (this.maxEvictableIdleTimeMillis < this.minEvictableIdleTimeMillis) {
                throw new SQLException("maxEvictableIdleTimeMillis must be grater than minEvictableIdleTimeMillis");
            }
            if (this.keepAlive && this.keepAliveBetweenTimeMillis <= this.timeBetweenEvictionRunsMillis) {
                throw new SQLException("keepAliveBetweenTimeMillis must be greater than timeBetweenEvictionRunsMillis");
            }
            if (this.driverClass != null) {
                this.driverClass = this.driverClass.trim();
            }
            this.initFromSPIServiceLoader();
            this.resolveDriver();
            this.initCheck();
            this.netTimeoutExecutor = new DruidAbstractDataSource.SynchronousExecutor(this);
            this.initExceptionSorter();
            this.initValidConnectionChecker();
            this.validationQueryCheck();
            if (this.isUseGlobalDataSourceStat()) {
                this.dataSourceStat = JdbcDataSourceStat.getGlobal();
                if (this.dataSourceStat == null) {
                    this.dataSourceStat = new JdbcDataSourceStat("Global", "Global", this.dbTypeName);
                    JdbcDataSourceStat.setGlobal(this.dataSourceStat);
                }
                if (this.dataSourceStat.getDbType() == null) {
                    this.dataSourceStat.setDbType(this.dbTypeName);
                }
            } else {
                this.dataSourceStat = new JdbcDataSourceStat(this.name, this.jdbcUrl, this.dbTypeName, this.connectProperties);
            }
            this.dataSourceStat.setResetStatEnable(this.resetStatEnable);
            this.connections = new DruidConnectionHolder[this.maxActive];
            this.evictConnections = new DruidConnectionHolder[this.maxActive];
            this.keepAliveConnections = new DruidConnectionHolder[this.maxActive];
            this.nullConnections = new DruidConnectionHolder[this.maxActive];
            SQLException connectError = null;
            if (this.createScheduler != null && this.asyncInit) {
                for (i = 0; i < this.initialSize; ++i) {
                    this.submitCreateTask(true);
                }
            } else if (!this.asyncInit) {
                while (this.poolingCount < this.initialSize) {
                    try {
                        DruidAbstractDataSource.PhysicalConnectionInfo pyConnectInfo = this.createPhysicalConnection();
                        DruidConnectionHolder holder = new DruidConnectionHolder(this, pyConnectInfo);
                        this.connections[this.poolingCount++] = holder;
                    }
                    catch (SQLException ex) {
                        LOG.error("init datasource error, url: " + this.getUrl(), ex);
                        if (this.initExceptionThrow) {
                            connectError = ex;
                            break;
                        }
                        Thread.sleep(3000L);
                    }
                }
                if (this.poolingCount > 0) {
                    this.poolingPeak = this.poolingCount;
                    this.poolingPeakTime = System.currentTimeMillis();
                }
            }
            this.createAndLogThread();
            this.createAndStartCreatorThread();
            this.createAndStartDestroyThread();
            if (this.createConnectionThread != null) {
                this.createConnectionThread.getInitedLatch().await();
            }
            if (this.destroyConnectionThread != null) {
                this.destroyConnectionThread.getInitedLatch().await();
            }
            init = true;
            this.initedTime = new Date();
            this.registerMbean();
            if (connectError != null && this.poolingCount == 0) {
                throw connectError;
            }
            if (this.keepAlive) {
                if (this.createScheduler != null) {
                    for (i = 0; i < this.minIdle - this.initialSize; ++i) {
                        this.submitCreateTask(true);
                    }
                } else {
                    this.empty.signal();
                }
            }
        }
        catch (SQLException e) {
            LOG.error("{dataSource-" + this.getID() + "} init error", e);
            throw e;
        }
        catch (InterruptedException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            LOG.error("{dataSource-" + this.getID() + "} init error", e);
            throw e;
        }
        catch (Error e) {
            LOG.error("{dataSource-" + this.getID() + "} init error", e);
            throw e;
        }
        finally {
            this.inited = true;
            lock.unlock();
            if (init && LOG.isInfoEnabled()) {
                String msg = "{dataSource-" + this.getID();
                if (this.name != null && !this.name.isEmpty()) {
                    msg = msg + ",";
                    msg = msg + this.name;
                }
                msg = msg + "} inited";
                LOG.info(msg);
            }
        }
    }

    private void initTimeoutsFromUrlOrProperties() {
        Object propertyConnectTimeout;
        if (this.jdbcUrl != null && (this.jdbcUrl.indexOf("connectTimeout=") != -1 || this.jdbcUrl.indexOf("socketTimeout=") != -1)) {
            String[] items = this.jdbcUrl.split("(\\?|&)");
            for (int i = 0; i < items.length; ++i) {
                String strVal;
                String item = items[i];
                if (item.startsWith("connectTimeout=")) {
                    strVal = item.substring("connectTimeout=".length());
                    this.setConnectTimeout(strVal);
                    continue;
                }
                if (!item.startsWith("socketTimeout=")) continue;
                strVal = item.substring("socketTimeout=".length());
                this.setSocketTimeout(strVal);
            }
        }
        if ((propertyConnectTimeout = this.connectProperties.get("connectTimeout")) instanceof String) {
            this.setConnectTimeout((String)propertyConnectTimeout);
        } else if (propertyConnectTimeout instanceof Number) {
            this.setConnectTimeout(((Number)propertyConnectTimeout).intValue());
        }
        Object propertySocketTimeout = this.connectProperties.get("socketTimeout");
        if (propertySocketTimeout instanceof String) {
            this.setSocketTimeout((String)propertySocketTimeout);
        } else if (propertySocketTimeout instanceof Number) {
            this.setSocketTimeout(((Number)propertySocketTimeout).intValue());
        }
    }

    private static boolean isMysqlOrMariaDBUrl(String jdbcUrl) {
        return jdbcUrl.startsWith("jdbc:mysql://") || jdbcUrl.startsWith("jdbc:mysql:loadbalance://") || jdbcUrl.startsWith("jdbc:mysql:replication://") || jdbcUrl.startsWith("jdbc:mariadb://") || jdbcUrl.startsWith("jdbc:mariadb:loadbalance://") || jdbcUrl.startsWith("jdbc:mariadb:replication://");
    }

    private void submitCreateTask(boolean initTask) {
        ++this.createTaskCount;
        CreateConnectionTask task = new CreateConnectionTask(initTask);
        if (this.createTasks == null) {
            this.createTasks = new long[8];
        }
        boolean putted = false;
        for (int i = 0; i < this.createTasks.length; ++i) {
            if (this.createTasks[i] != 0L) continue;
            this.createTasks[i] = task.taskId;
            putted = true;
            break;
        }
        if (!putted) {
            long[] array = new long[this.createTasks.length * 3 / 2];
            System.arraycopy(this.createTasks, 0, array, 0, this.createTasks.length);
            array[this.createTasks.length] = task.taskId;
            this.createTasks = array;
        }
        this.createSchedulerFutures.put(task, this.createScheduler.submit(task));
    }

    private boolean clearCreateTask(long taskId) {
        if (this.createTasks == null) {
            return false;
        }
        if (taskId == 0L) {
            return false;
        }
        for (int i = 0; i < this.createTasks.length; ++i) {
            if (this.createTasks[i] != taskId) continue;
            this.createTasks[i] = 0L;
            --this.createTaskCount;
            if (this.createTaskCount < 0) {
                this.createTaskCount = 0;
            }
            if (this.createTaskCount == 0 && this.createTasks.length > 8) {
                this.createTasks = new long[8];
            }
            return true;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("clear create task failed : " + taskId);
        }
        return false;
    }

    private void createAndLogThread() {
        if (this.timeBetweenLogStatsMillis <= 0L) {
            return;
        }
        String threadName = "Druid-ConnectionPool-Log-" + System.identityHashCode(this);
        this.logStatsThread = new LogStatsThread(threadName);
        this.logStatsThread.start();
        this.resetStatEnable = false;
    }

    protected void createAndStartDestroyThread() {
        this.destroyTask = new DestroyTask();
        if (this.destroyScheduler != null) {
            long period = this.timeBetweenEvictionRunsMillis;
            if (period <= 0L) {
                period = 1000L;
            }
            this.destroySchedulerFuture = this.destroyScheduler.scheduleAtFixedRate(this.destroyTask, period, period, TimeUnit.MILLISECONDS);
            return;
        }
        String threadName = "Druid-ConnectionPool-Destroy-" + System.identityHashCode(this);
        this.destroyConnectionThread = new DestroyConnectionThread(threadName);
        this.destroyConnectionThread.start();
    }

    protected void createAndStartCreatorThread() {
        if (this.createScheduler == null) {
            String threadName = "Druid-ConnectionPool-Create-" + System.identityHashCode(this);
            this.createConnectionThread = new CreateConnectionThread(threadName);
            this.createConnectionThread.start();
        }
    }

    private void initFromSPIServiceLoader() {
        if (this.loadSpifilterSkip) {
            return;
        }
        if (autoFilters == null) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            ServiceLoader<Filter> autoFilterLoader = ServiceLoader.load(Filter.class);
            for (Filter filter : autoFilterLoader) {
                AutoLoad autoLoad = filter.getClass().getAnnotation(AutoLoad.class);
                if (autoLoad == null || !autoLoad.value()) continue;
                filters.add(filter);
            }
            autoFilters = filters;
        }
        for (Filter filter : autoFilters) {
            if (LOG.isInfoEnabled()) {
                LOG.info("load filter from spi :" + filter.getClass().getName());
            }
            this.addFilter(filter);
        }
    }

    private void initFromWrapDriverUrl() throws SQLException {
        if (!this.jdbcUrl.startsWith("jdbc:wrap-jdbc:")) {
            return;
        }
        DataSourceProxyConfig config = DruidDriver.parseConfig(this.jdbcUrl, null);
        this.driverClass = config.getRawDriverClassName();
        LOG.error("error url : '" + DruidDataSource.sanitizedUrl(this.jdbcUrl) + "', it should be : '" + config.getRawUrl() + "'");
        this.jdbcUrl = config.getRawUrl();
        if (this.name == null) {
            this.name = config.getName();
        }
        for (Filter filter : config.getFilters()) {
            this.addFilter(filter);
        }
    }

    private void addFilter(Filter filter) {
        boolean exists = false;
        for (Filter initedFilter : this.filters) {
            if (initedFilter.getClass() != filter.getClass()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            filter.init(this);
            this.filters.add(filter);
        }
    }

    private void validationQueryCheck() {
        if (!(this.testOnBorrow || this.testOnReturn || this.testWhileIdle)) {
            return;
        }
        if (this.validConnectionChecker != null) {
            return;
        }
        if (this.validationQuery != null && this.validationQuery.length() > 0) {
            return;
        }
        if ("odps".equals(this.dbTypeName)) {
            return;
        }
        String errorMessage = "";
        if (this.testOnBorrow) {
            errorMessage = errorMessage + "testOnBorrow is true, ";
        }
        if (this.testOnReturn) {
            errorMessage = errorMessage + "testOnReturn is true, ";
        }
        if (this.testWhileIdle) {
            errorMessage = errorMessage + "testWhileIdle is true, ";
        }
        LOG.error(errorMessage + "validationQuery not set");
    }

    protected void resolveDriver() throws SQLException {
        if (this.driver == null) {
            if (this.driverClass == null || this.driverClass.isEmpty()) {
                this.driverClass = JdbcUtils.getDriverClassName(this.jdbcUrl);
            }
            if (MockDriver.class.getName().equals(this.driverClass)) {
                this.driver = MockDriver.instance;
            } else if ("com.alibaba.druid.support.clickhouse.BalancedClickhouseDriver".equals(this.driverClass)) {
                Properties info = new Properties();
                info.put("user", this.username);
                info.put("password", this.password);
                info.putAll((Map<?, ?>)this.connectProperties);
                this.driver = new BalancedClickhouseDriver(this.jdbcUrl, info);
            } else if ("com.alibaba.druid.support.clickhouse.BalancedClickhouseDriverNative".equals(this.driverClass)) {
                Properties info = new Properties();
                info.put("user", this.username);
                info.put("password", this.password);
                info.putAll((Map<?, ?>)this.connectProperties);
                this.driver = new BalancedClickhouseDriverNative(this.jdbcUrl, info);
            } else {
                if (this.jdbcUrl == null && (this.driverClass == null || this.driverClass.length() == 0)) {
                    throw new SQLException("url not set");
                }
                this.driver = JdbcUtils.createDriver(this.driverClassLoader, this.driverClass);
            }
        } else if (this.driverClass == null) {
            this.driverClass = this.driver.getClass().getName();
        }
    }

    protected void initCheck() throws SQLException {
        DbType dbType = DbType.of(this.dbTypeName);
        if (dbType == DbType.oracle) {
            this.isOracle = true;
            if (this.driver.getMajorVersion() < 10) {
                throw new SQLException("not support oracle driver " + this.driver.getMajorVersion() + "." + this.driver.getMinorVersion());
            }
            if (this.driver.getMajorVersion() == 10 && this.isUseOracleImplicitCache()) {
                this.getConnectProperties().setProperty("oracle.jdbc.FreeMemoryOnEnterImplicitCache", "true");
            }
            this.oracleValidationQueryCheck();
        } else if (dbType == DbType.db2) {
            this.db2ValidationQueryCheck();
        } else if (dbType == DbType.mysql || "com.mysql.jdbc.Driver".equals(this.driverClass) || "com.mysql.cj.jdbc.Driver".equals(this.driverClass) || "com.mysql.cj.api.MysqlConnection".equals(this.driverClass) || "com.goldendb.jdbc.Driver".equals(this.driverClass) || "com.gbasedbt.jdbc.Driver".equals(this.driverClass) || "com.alibaba.polardbx.Driver".equals(this.driverClass)) {
            this.isMySql = true;
        }
        if (this.removeAbandoned) {
            LOG.warn("removeAbandoned is true, not use in production.");
        }
    }

    private void oracleValidationQueryCheck() {
        if (this.validationQuery == null) {
            return;
        }
        if (this.validationQuery.length() == 0) {
            return;
        }
        SQLStatementParser sqlStmtParser = SQLParserUtils.createSQLStatementParser(this.validationQuery, this.dbTypeName, new SQLParserFeature[0]);
        List<SQLStatement> stmtList = sqlStmtParser.parseStatementList();
        if (stmtList.size() != 1) {
            return;
        }
        SQLStatement stmt = stmtList.get(0);
        if (!(stmt instanceof SQLSelectStatement)) {
            return;
        }
        SQLSelectQuery query = ((SQLSelectStatement)stmt).getSelect().getQuery();
        if (query instanceof SQLSelectQueryBlock && ((SQLSelectQueryBlock)query).getFrom() == null) {
            LOG.error("invalid oracle validationQuery. " + this.validationQuery + ", may should be : " + this.validationQuery + " FROM DUAL");
        }
    }

    private void db2ValidationQueryCheck() {
        if (this.validationQuery == null) {
            return;
        }
        if (this.validationQuery.length() == 0) {
            return;
        }
        SQLStatementParser sqlStmtParser = SQLParserUtils.createSQLStatementParser(this.validationQuery, this.dbTypeName, new SQLParserFeature[0]);
        List<SQLStatement> stmtList = sqlStmtParser.parseStatementList();
        if (stmtList.size() != 1) {
            return;
        }
        SQLStatement stmt = stmtList.get(0);
        if (!(stmt instanceof SQLSelectStatement)) {
            return;
        }
        SQLSelectQuery query = ((SQLSelectStatement)stmt).getSelect().getQuery();
        if (query instanceof SQLSelectQueryBlock && ((SQLSelectQueryBlock)query).getFrom() == null) {
            LOG.error("invalid db2 validationQuery. " + this.validationQuery + ", may should be : " + this.validationQuery + " FROM SYSDUMMY");
        }
    }

    private void initValidConnectionChecker() {
        if (this.validConnectionChecker != null) {
            return;
        }
        String realDriverClassName = this.driver.getClass().getName();
        if (JdbcUtils.isMySqlDriver(realDriverClassName)) {
            this.validConnectionChecker = new MySqlValidConnectionChecker();
        } else if (realDriverClassName.equals("oracle.jdbc.OracleDriver") || realDriverClassName.equals("oracle.jdbc.driver.OracleDriver")) {
            this.validConnectionChecker = new OracleValidConnectionChecker();
        } else if (realDriverClassName.equals("com.microsoft.jdbc.sqlserver.SQLServerDriver") || realDriverClassName.equals("com.microsoft.sqlserver.jdbc.SQLServerDriver") || realDriverClassName.equals("net.sourceforge.jtds.jdbc.Driver")) {
            this.validConnectionChecker = new MSSQLValidConnectionChecker();
        } else if (realDriverClassName.equals("org.postgresql.Driver") || realDriverClassName.equals("com.edb.Driver") || realDriverClassName.equals("org.opengauss.Driver") || realDriverClassName.equals("com.aliyun.polardb.Driver") || realDriverClassName.equals("com.aliyun.polardb2.Driver")) {
            this.validConnectionChecker = new PGValidConnectionChecker();
        } else if (realDriverClassName.equals("com.alipay.oceanbase.jdbc.Driver") || realDriverClassName.equals("com.oceanbase.jdbc.Driver")) {
            DbType dbType = DbType.of(this.dbTypeName);
            this.validConnectionChecker = new OceanBaseValidConnectionChecker(dbType);
        }
    }

    private void initExceptionSorter() {
        if (this.exceptionSorter instanceof NullExceptionSorter ? this.driver instanceof MockDriver : this.exceptionSorter != null) {
            return;
        }
        Class<?> driverClass = this.driver.getClass();
        while (true) {
            String realDriverClassName;
            if ((realDriverClassName = driverClass.getName()).equals("com.mysql.jdbc.Driver") || realDriverClassName.equals("com.mysql.cj.jdbc.Driver") || realDriverClassName.equals("com.mysql.cj.api.MysqlConnection")) {
                this.exceptionSorter = new MySqlExceptionSorter();
                this.isMySql = true;
                break;
            }
            if (realDriverClassName.equals("oracle.jdbc.OracleDriver") || realDriverClassName.equals("oracle.jdbc.driver.OracleDriver")) {
                this.exceptionSorter = new OracleExceptionSorter();
                break;
            }
            if (realDriverClassName.equals("com.alipay.oceanbase.jdbc.Driver")) {
                if (JdbcUtils.OCEANBASE_ORACLE.name().equalsIgnoreCase(this.dbTypeName)) {
                    this.exceptionSorter = new OceanBaseOracleExceptionSorter();
                    break;
                }
                this.exceptionSorter = new MySqlExceptionSorter();
                break;
            }
            if (realDriverClassName.equals("com.informix.jdbc.IfxDriver")) {
                this.exceptionSorter = new InformixExceptionSorter();
                break;
            }
            if (realDriverClassName.equals("com.sybase.jdbc2.jdbc.SybDriver")) {
                this.exceptionSorter = new SybaseExceptionSorter();
                break;
            }
            if (realDriverClassName.equals("org.postgresql.Driver") || realDriverClassName.equals("com.edb.Driver") || realDriverClassName.equals("com.aliyun.polardb.Driver") || realDriverClassName.equals("com.aliyun.polardb2.Driver")) {
                this.exceptionSorter = new PGExceptionSorter();
                break;
            }
            if (realDriverClassName.equals("com.alibaba.druid.mock.MockDriver")) {
                this.exceptionSorter = new MockExceptionSorter();
                break;
            }
            if (realDriverClassName.contains("DB2")) {
                this.exceptionSorter = new DB2ExceptionSorter();
                break;
            }
            if (realDriverClassName.equals("com.goldendb.jdbc.Driver")) {
                this.exceptionSorter = new MySqlExceptionSorter();
                this.isMySql = true;
                break;
            }
            if (realDriverClassName.equals("com.alibaba.polardbx.Driver")) {
                this.exceptionSorter = new MySqlExceptionSorter();
                this.isMySql = true;
                break;
            }
            Class<?> superClass = driverClass.getSuperclass();
            if (superClass == null || superClass == Object.class) break;
            driverClass = superClass;
        }
    }

    @Override
    public DruidPooledConnection getConnection() throws SQLException {
        return this.getConnection(this.maxWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidPooledConnection getConnection(long maxWaitMillis) throws SQLException {
        if (this.jdbcUrl == null || this.jdbcUrl.isEmpty()) {
            LOG.warn("getConnection but jdbcUrl is not set,jdbcUrl=" + this.jdbcUrl + ",username=" + this.username);
            return null;
        }
        this.init();
        int filtersSize = this.filters.size();
        if (filtersSize > 0) {
            FilterChainImpl filterChain = this.createChain();
            try {
                DruidPooledConnection druidPooledConnection = filterChain.dataSource_connect(this, maxWaitMillis);
                return druidPooledConnection;
            }
            finally {
                this.recycleFilterChain(filterChain);
            }
        }
        return this.getConnectionDirect(maxWaitMillis);
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getConnection(this.maxWait);
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        throw new UnsupportedOperationException("Not supported by DruidDataSource");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DruidPooledConnection getConnectionDirect(long maxWaitMillis) throws SQLException {
        DruidPooledConnection poolableConnection;
        int notFullTimeoutRetryCnt = 0;
        while (true) {
            boolean validated;
            long idleMillis;
            try {
                poolableConnection = this.getConnectionInternal(maxWaitMillis);
            }
            catch (GetConnectionTimeoutException ex) {
                if (notFullTimeoutRetryCnt < this.notFullTimeoutRetryCount && !this.isFull()) {
                    ++notFullTimeoutRetryCnt;
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn("get connection timeout retry : " + notFullTimeoutRetryCnt);
                    continue;
                }
                throw ex;
            }
            if (this.testOnBorrow) {
                boolean validated2 = this.testConnectionInternal(poolableConnection.holder, poolableConnection.conn);
                if (validated2) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("skip not validated connection.");
                }
                this.discardConnection(poolableConnection.holder);
                continue;
            }
            if (poolableConnection.conn.isClosed()) {
                this.discardConnection(poolableConnection.holder);
                continue;
            }
            if (!this.testWhileIdle) break;
            DruidConnectionHolder holder = poolableConnection.holder;
            long currentTimeMillis = System.currentTimeMillis();
            long lastActiveTimeMillis = holder.lastActiveTimeMillis;
            long lastExecTimeMillis = holder.lastExecTimeMillis;
            long lastKeepTimeMillis = holder.lastKeepTimeMillis;
            if (this.checkExecuteTime && lastExecTimeMillis != lastActiveTimeMillis) {
                lastActiveTimeMillis = lastExecTimeMillis;
            }
            if (lastKeepTimeMillis > lastActiveTimeMillis) {
                lastActiveTimeMillis = lastKeepTimeMillis;
            }
            if ((idleMillis = currentTimeMillis - lastActiveTimeMillis) < this.timeBetweenEvictionRunsMillis && idleMillis >= 0L || (validated = this.testConnectionInternal(poolableConnection.holder, poolableConnection.conn))) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("skip not validated connection.");
            }
            this.discardConnection(poolableConnection.holder);
        }
        if (this.removeAbandoned) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            poolableConnection.connectStackTrace = stackTrace;
            poolableConnection.setConnectedTimeNano();
            poolableConnection.traceEnable = true;
            this.activeConnectionLock.lock();
            try {
                this.activeConnections.put(poolableConnection, PRESENT);
            }
            finally {
                this.activeConnectionLock.unlock();
            }
        }
        if (!this.defaultAutoCommit) {
            poolableConnection.setAutoCommit(false);
        }
        return poolableConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean discardConnection(Connection conn) {
        boolean emptySignalCalled;
        block9: {
            emptySignalCalled = false;
            if (conn == null) {
                return emptySignalCalled;
            }
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLRecoverableException ignored) {
                discardErrorCountUpdater.incrementAndGet(this);
            }
            catch (Throwable e) {
                discardErrorCountUpdater.incrementAndGet(this);
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug("discard to close connection error", e);
            }
        }
        this.lock.lock();
        try {
            --this.activeCount;
            ++this.discardCount;
            int fillCount = this.minIdle - (this.activeCount + this.poolingCount + this.createTaskCount);
            if (fillCount > 0) {
                emptySignalCalled = true;
                this.emptySignal(fillCount);
            }
        }
        finally {
            this.lock.unlock();
        }
        return emptySignalCalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean discardConnection(DruidConnectionHolder holder) {
        Socket socket;
        boolean emptySignalCalled = false;
        if (holder == null) {
            return emptySignalCalled;
        }
        Connection conn = holder.getConnection();
        if (conn != null) {
            JdbcUtils.close(conn);
        }
        if ((socket = holder.socket) != null) {
            JdbcUtils.close(socket);
        }
        this.lock.lock();
        try {
            if (holder.discard) {
                boolean bl = emptySignalCalled;
                return bl;
            }
            if (holder.active) {
                --this.activeCount;
                holder.active = false;
            }
            ++this.discardCount;
            holder.discard = true;
            int fillCount = this.minIdle - (this.activeCount + this.poolingCount + this.createTaskCount);
            if (fillCount > 0) {
                emptySignalCalled = true;
                this.emptySignal(fillCount);
            }
        }
        finally {
            this.lock.unlock();
        }
        return emptySignalCalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DruidPooledConnection getConnectionInternal(long maxWait) throws SQLException {
        long createElapseMillis;
        Throwable createError;
        long createErrorCount;
        long createStartNanos;
        long creatingCount;
        long maxActive;
        long activeCount;
        DruidConnectionHolder holder;
        if (this.closed) {
            connectErrorCountUpdater.incrementAndGet(this);
            throw new DataSourceClosedException("dataSource already closed at " + new Date(this.closeTimeMillis));
        }
        if (!this.enable) {
            connectErrorCountUpdater.incrementAndGet(this);
            if (this.disableException != null) {
                throw this.disableException;
            }
            throw new DataSourceDisableException();
        }
        int maxWaitThreadCount = this.maxWaitThreadCount;
        long startTime = System.currentTimeMillis();
        long expiredTime = startTime + maxWait;
        boolean createDirect = false;
        while (true) {
            block46: {
                if (createDirect) {
                    try {
                        createStartNanosUpdater.set(this, System.nanoTime());
                        if (!creatingCountUpdater.compareAndSet(this, 0, 1)) break block46;
                        DruidAbstractDataSource.PhysicalConnectionInfo pyConnInfo = this.createPhysicalConnection();
                        holder = new DruidConnectionHolder(this, pyConnInfo);
                        creatingCountUpdater.decrementAndGet(this);
                        directCreateCountUpdater.incrementAndGet(this);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("conn-direct_create ");
                        }
                        ReentrantLock lock = this.lock;
                        lock.lock();
                        try {
                            if (this.activeCount + this.poolingCount < this.maxActive) {
                                ++this.activeCount;
                                holder.active = true;
                                if (this.activeCount <= this.activePeak) break;
                                this.activePeak = this.activeCount;
                                this.activePeakTime = System.currentTimeMillis();
                                break;
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                        JdbcUtils.close(pyConnInfo.getPhysicalConnection());
                    }
                    finally {
                        createDirect = false;
                        createDirectCountUpdater.decrementAndGet(this);
                    }
                }
            }
            ReentrantLock lock = this.lock;
            try {
                lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                connectErrorCountUpdater.incrementAndGet(this);
                throw new SQLException("interrupt", e);
            }
            try {
                block48: {
                    ScheduledThreadPoolExecutor executor;
                    if (maxWaitThreadCount > 0 && this.notEmptyWaitThreadCount > maxWaitThreadCount) {
                        connectErrorCountUpdater.incrementAndGet(this);
                        throw new SQLException("maxWaitThreadCount " + maxWaitThreadCount + ", current wait Thread count " + lock.getQueueLength());
                    }
                    if (this.onFatalError && this.onFatalErrorMaxActive > 0 && this.activeCount >= this.onFatalErrorMaxActive) {
                        connectErrorCountUpdater.incrementAndGet(this);
                        StringBuilder errorMsg = new StringBuilder();
                        errorMsg.append("onFatalError, activeCount ").append(this.activeCount).append(", onFatalErrorMaxActive ").append(this.onFatalErrorMaxActive);
                        if (this.lastFatalErrorTimeMillis > 0L) {
                            errorMsg.append(", time '").append(StringUtils.formatDateTime19(this.lastFatalErrorTimeMillis, TimeZone.getDefault())).append("'");
                        }
                        if (this.lastFatalErrorSql != null) {
                            errorMsg.append(", sql \n").append(this.lastFatalErrorSql);
                        }
                        throw new SQLException(errorMsg.toString(), this.lastFatalError);
                    }
                    ++this.connectCount;
                    if (this.createScheduler != null && this.poolingCount == 0 && this.activeCount < this.maxActive && createDirectCountUpdater.get(this) == 0 && creatingCountUpdater.get(this) == 0 && this.createScheduler instanceof ScheduledThreadPoolExecutor && (executor = (ScheduledThreadPoolExecutor)this.createScheduler).getQueue().size() > 0) {
                        if (maxWait > 0L && System.currentTimeMillis() - startTime >= maxWait) {
                            holder = null;
                            break;
                        }
                        createDirect = true;
                        createDirectCountUpdater.incrementAndGet(this);
                        continue;
                    }
                    if (maxWait > 0L) {
                        if (System.currentTimeMillis() < expiredTime) {
                            holder = this.pollLast(startTime, expiredTime);
                            break block48;
                        } else {
                            holder = null;
                            break;
                        }
                    }
                    holder = this.takeLast(startTime);
                }
                if (holder == null) break;
                if (holder.discard) {
                    holder = null;
                    if (maxWait <= 0L || System.currentTimeMillis() < expiredTime) continue;
                    break;
                }
                ++this.activeCount;
                holder.active = true;
                if (this.activeCount <= this.activePeak) break;
                this.activePeak = this.activeCount;
                this.activePeakTime = System.currentTimeMillis();
            }
            catch (InterruptedException e) {
                connectErrorCountUpdater.incrementAndGet(this);
                throw new SQLException(e.getMessage(), e);
            }
            catch (SQLException e) {
                connectErrorCountUpdater.incrementAndGet(this);
                throw e;
            }
            finally {
                lock.unlock();
                continue;
            }
            break;
        }
        if (holder != null) {
            holder.incrementUseCount();
            return new DruidPooledConnection(holder);
        }
        long waitMillis = System.currentTimeMillis() - startTime;
        try {
            this.lock.lock();
            activeCount = this.activeCount;
            maxActive = this.maxActive;
            creatingCount = this.creatingCount;
            createStartNanos = this.createStartNanos;
            createErrorCount = this.createErrorCount;
            createError = this.createError;
        }
        finally {
            this.lock.unlock();
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append("wait millis ").append(waitMillis).append(", active ").append(activeCount).append(", maxActive ").append(maxActive).append(", creating ").append(creatingCount);
        if (creatingCount > 0L && createStartNanos > 0L && (createElapseMillis = (System.nanoTime() - createStartNanos) / 1000000L) > 0L) {
            buf.append(", createElapseMillis ").append(createElapseMillis);
        }
        if (createErrorCount > 0L) {
            buf.append(", createErrorCount ").append(createErrorCount);
        }
        List<JdbcSqlStatValue> sqlList = this.getDataSourceStat().getRuningSqlList();
        for (int i = 0; i < sqlList.size(); ++i) {
            if (i != 0) {
                buf.append('\n');
            } else {
                buf.append(", ");
            }
            JdbcSqlStatValue sql = sqlList.get(i);
            buf.append("runningSqlCount ").append(sql.getRunningCount());
            buf.append(" : ");
            buf.append(sql.getSql());
        }
        String errorMessage = buf.toString();
        if (createError != null) {
            throw new GetConnectionTimeoutException(errorMessage, createError);
        }
        throw new GetConnectionTimeoutException(errorMessage);
    }

    @Override
    public void handleConnectionException(DruidPooledConnection pooledConnection, Throwable t, String sql) throws SQLException {
        DruidConnectionHolder holder = pooledConnection.getConnectionHolder();
        if (holder == null) {
            return;
        }
        errorCountUpdater.incrementAndGet(this);
        this.lastError = t;
        this.lastErrorTimeMillis = System.currentTimeMillis();
        if (t instanceof SQLException) {
            SQLException sqlEx = (SQLException)t;
            ConnectionEvent event = new ConnectionEvent(pooledConnection, sqlEx);
            for (ConnectionEventListener eventListener : holder.getConnectionEventListeners()) {
                eventListener.connectionErrorOccurred(event);
            }
            if (this.exceptionSorter != null && this.exceptionSorter.isExceptionFatal(sqlEx)) {
                this.handleFatalError(pooledConnection, sqlEx, sql);
            }
            throw sqlEx;
        }
        throw new SQLException("Error", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void handleFatalError(DruidPooledConnection conn, SQLException error, String sql) throws SQLException {
        long lastErrorTimeMillis;
        DruidConnectionHolder holder = conn.holder;
        if (conn.isTraceEnable()) {
            this.activeConnectionLock.lock();
            try {
                if (conn.isTraceEnable()) {
                    this.activeConnections.remove(conn);
                    conn.setTraceEnable(false);
                }
            }
            finally {
                this.activeConnectionLock.unlock();
            }
        }
        if ((lastErrorTimeMillis = this.lastErrorTimeMillis) == 0L) {
            lastErrorTimeMillis = System.currentTimeMillis();
        }
        if (sql != null && sql.length() > 1024) {
            sql = sql.substring(0, 1024);
        }
        boolean requireDiscard = false;
        boolean hasHolderDataSource = holder != null && holder.getDataSource() != null;
        ReentrantLock fatalErrorCountLock = hasHolderDataSource ? holder.getDataSource().lock : conn.lock;
        fatalErrorCountLock.lock();
        try {
            if (!conn.closed && !conn.disable) {
                conn.disable(error);
                requireDiscard = true;
            }
            this.lastFatalErrorTimeMillis = lastErrorTimeMillis;
            ++this.fatalErrorCount;
            if (this.fatalErrorCount - this.fatalErrorCountLastShrink > this.onFatalErrorMaxActive) {
                ++this.fatalErrorCountLastShrink;
                this.onFatalError = true;
            } else {
                this.onFatalError = false;
            }
            this.lastFatalError = error;
            this.lastFatalErrorSql = sql;
        }
        finally {
            fatalErrorCountLock.unlock();
        }
        boolean emptySignalCalled = false;
        if (requireDiscard) {
            if (holder != null && holder.statementTrace != null) {
                holder.lock.lock();
                try {
                    for (Statement stmt : holder.statementTrace) {
                        JdbcUtils.close(stmt);
                    }
                }
                finally {
                    holder.lock.unlock();
                }
            }
            emptySignalCalled = this.discardConnection(holder);
        }
        LOG.error("{conn-" + (holder != null ? Long.valueOf(holder.getConnectionId()) : "null") + "} discard", error);
        if (!emptySignalCalled && this.onFatalError && hasHolderDataSource) {
            fatalErrorCountLock.lock();
            try {
                this.emptySignal();
            }
            finally {
                fatalErrorCountLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recycle(DruidPooledConnection pooledConnection) throws SQLException {
        boolean isSameThread;
        DruidConnectionHolder holder = pooledConnection.holder;
        if (holder == null) {
            LOG.warn("connectionHolder is null");
            return;
        }
        boolean asyncCloseConnectionEnable = this.removeAbandoned || this.asyncCloseConnectionEnable;
        boolean bl = isSameThread = pooledConnection.ownerThread == Thread.currentThread();
        if (this.logDifferentThread && !asyncCloseConnectionEnable && !isSameThread) {
            LOG.warn("get/close not same thread");
        }
        Connection physicalConnection = holder.conn;
        if (pooledConnection.traceEnable) {
            Object oldInfo = null;
            this.activeConnectionLock.lock();
            try {
                if (pooledConnection.traceEnable) {
                    oldInfo = this.activeConnections.remove(pooledConnection);
                    pooledConnection.traceEnable = false;
                }
            }
            finally {
                this.activeConnectionLock.unlock();
            }
            if (oldInfo == null && LOG.isWarnEnabled()) {
                LOG.warn("remove abandoned failed. activeConnections.size " + this.activeConnections.size());
            }
        }
        boolean isAutoCommit = holder.underlyingAutoCommit;
        boolean isReadOnly = holder.underlyingReadOnly;
        boolean testOnReturn = this.testOnReturn;
        try {
            boolean result;
            long phyConnectTimeMillis;
            boolean validated;
            if (!isAutoCommit && !isReadOnly) {
                pooledConnection.rollback();
            }
            if (!isSameThread) {
                ReentrantLock lock = pooledConnection.lock;
                lock.lock();
                try {
                    holder.reset();
                }
                finally {
                    lock.unlock();
                }
            } else {
                holder.reset();
            }
            if (holder.discard) {
                return;
            }
            if (this.phyMaxUseCount > 0L && holder.useCount >= this.phyMaxUseCount || holder.userPasswordVersion < this.getUserPasswordVersion()) {
                this.discardConnection(holder);
                return;
            }
            if (physicalConnection.isClosed()) {
                this.lock.lock();
                try {
                    if (holder.active) {
                        --this.activeCount;
                        holder.active = false;
                    }
                    ++this.closeCount;
                }
                finally {
                    this.lock.unlock();
                }
                return;
            }
            if (testOnReturn && !(validated = this.testConnectionInternal(holder, physicalConnection))) {
                JdbcUtils.close(physicalConnection);
                destroyCountUpdater.incrementAndGet(this);
                this.lock.lock();
                try {
                    if (holder.active) {
                        --this.activeCount;
                        holder.active = false;
                    }
                    ++this.closeCount;
                }
                finally {
                    this.lock.unlock();
                }
                return;
            }
            if (holder.initSchema != null) {
                holder.conn.setSchema(holder.initSchema);
                holder.initSchema = null;
            }
            if (!this.enable) {
                this.discardConnection(holder);
                return;
            }
            long currentTimeMillis = System.currentTimeMillis();
            if (this.phyTimeoutMillis > 0L && (phyConnectTimeMillis = currentTimeMillis - holder.connectTimeMillis) > this.phyTimeoutMillis) {
                this.discardConnection(holder);
                return;
            }
            boolean full = false;
            this.lock.lock();
            try {
                if (holder.active) {
                    --this.activeCount;
                    holder.active = false;
                }
                ++this.closeCount;
                result = this.putLast(holder, currentTimeMillis);
                ++this.recycleCount;
                if (!result) {
                    full = this.poolingCount + this.activeCount >= this.maxActive;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (!result) {
                JdbcUtils.close(holder.conn);
                String msg = "connection recycle failed.";
                if (full) {
                    msg = msg + " pool is full";
                }
                LOG.info(msg);
            }
        }
        catch (Throwable e) {
            holder.clearStatementCache();
            if (!holder.discard) {
                this.discardConnection(holder);
                holder.discard = true;
            }
            LOG.error("recycle error", e);
            recycleErrorCountUpdater.incrementAndGet(this);
        }
    }

    public long getRecycleErrorCount() {
        return this.recycleErrorCount;
    }

    @Override
    public void clearStatementCache() throws SQLException {
        this.lock.lock();
        try {
            for (int i = 0; i < this.poolingCount; ++i) {
                DruidConnectionHolder conn = this.connections[i];
                if (conn.statementPool == null) continue;
                conn.statementPool.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (LOG.isInfoEnabled()) {
            LOG.info("{dataSource-" + this.getID() + "} closing ...");
        }
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (!this.inited) {
                return;
            }
            this.closing = true;
            if (this.logStatsThread != null) {
                this.logStatsThread.interrupt();
            }
            if (this.createConnectionThread != null) {
                this.createConnectionThread.interrupt();
            }
            if (this.destroyConnectionThread != null) {
                this.destroyConnectionThread.interrupt();
            }
            for (Future<?> createSchedulerFuture : this.createSchedulerFutures.values()) {
                createSchedulerFuture.cancel(true);
            }
            if (this.destroySchedulerFuture != null) {
                this.destroySchedulerFuture.cancel(true);
            }
            for (int i = 0; i < this.poolingCount; ++i) {
                DruidConnectionHolder connHolder = this.connections[i];
                for (PreparedStatementHolder stmtHolder : connHolder.getStatementPool().getMap().values()) {
                    connHolder.getStatementPool().closeRemovedStatement(stmtHolder);
                }
                connHolder.getStatementPool().getMap().clear();
                Connection physicalConnection = connHolder.getConnection();
                try {
                    physicalConnection.close();
                }
                catch (Exception ex) {
                    LOG.warn("close connection error", ex);
                }
                this.connections[i] = null;
                destroyCountUpdater.incrementAndGet(this);
            }
            this.poolingCount = 0;
            this.unregisterMbean();
            this.enable = false;
            this.notEmpty.signalAll();
            ++this.notEmptySignalCount;
            this.closed = true;
            this.closeTimeMillis = System.currentTimeMillis();
            this.disableException = new DataSourceDisableException();
            for (Filter filter : this.filters) {
                filter.destroy();
            }
        }
        finally {
            this.closing = false;
            this.lock.unlock();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("{dataSource-" + this.getID() + "} closed");
        }
    }

    public void registerMbean() {
        if (!this.mbeanRegistered) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ObjectName objectName = DruidDataSourceStatManager.addDataSource(DruidDataSource.this, DruidDataSource.this.name);
                    DruidDataSource.this.setObjectName(objectName);
                    DruidDataSource.this.mbeanRegistered = true;
                    return null;
                }
            });
        }
    }

    public void unregisterMbean() {
        if (this.mbeanRegistered) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    DruidDataSourceStatManager.removeDataSource(DruidDataSource.this);
                    DruidDataSource.this.mbeanRegistered = false;
                    return null;
                }
            });
        }
    }

    public boolean isMbeanRegistered() {
        return this.mbeanRegistered;
    }

    boolean putLast(DruidConnectionHolder e, long lastActiveTimeMillis) {
        if (this.activeCount + this.poolingCount >= this.maxActive || e.discard || this.closed || this.closing) {
            return false;
        }
        e.lastActiveTimeMillis = lastActiveTimeMillis;
        this.connections[this.poolingCount] = e;
        this.incrementPoolingCount();
        if (this.poolingCount > this.poolingPeak) {
            this.poolingPeak = this.poolingCount;
            this.poolingPeakTime = lastActiveTimeMillis;
        }
        this.notEmpty.signal();
        ++this.notEmptySignalCount;
        return true;
    }

    private DruidConnectionHolder takeLast(long startTime) throws InterruptedException, SQLException {
        return this.pollLast(startTime, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DruidConnectionHolder pollLast(long startTime, long expiredTime) throws InterruptedException, SQLException {
        try {
            long estimate = 0L;
            while (this.poolingCount == 0) {
                this.emptySignal();
                if (this.failFast && this.isFailContinuous()) {
                    throw new DataSourceNotAvailableException(this.createError);
                }
                long awaitStartTime = System.currentTimeMillis();
                if (expiredTime != 0L && (estimate = expiredTime - awaitStartTime) <= 0L) {
                    return null;
                }
                ++this.notEmptyWaitThreadCount;
                if (this.notEmptyWaitThreadCount > this.notEmptyWaitThreadPeak) {
                    this.notEmptyWaitThreadPeak = this.notEmptyWaitThreadCount;
                }
                try {
                    if (estimate == 0L) {
                        this.notEmpty.await();
                    } else {
                        this.notEmpty.await(estimate, TimeUnit.MILLISECONDS);
                    }
                }
                finally {
                    --this.notEmptyWaitThreadCount;
                    ++this.notEmptyWaitCount;
                    this.notEmptyWaitNanos += TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis() - awaitStartTime);
                }
                if (this.enable) continue;
                connectErrorCountUpdater.incrementAndGet(this);
                if (this.disableException != null) {
                    throw this.disableException;
                }
                throw new DataSourceDisableException();
            }
        }
        catch (InterruptedException ie) {
            this.notEmpty.signal();
            ++this.notEmptySignalCount;
            throw ie;
        }
        this.decrementPoolingCount();
        DruidConnectionHolder last = this.connections[this.poolingCount];
        this.connections[this.poolingCount] = null;
        long waitNanos = System.currentTimeMillis() - startTime;
        last.setLastNotEmptyWaitNanos(waitNanos);
        return last;
    }

    private final void decrementPoolingCount() {
        --this.poolingCount;
    }

    private final void incrementPoolingCount() {
        ++this.poolingCount;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.username == null && this.password == null && username != null && password != null) {
            this.username = username;
            this.password = password;
            return this.getConnection();
        }
        if (!StringUtils.equals(username, this.username)) {
            throw new UnsupportedOperationException("Not supported by DruidDataSource");
        }
        if (!StringUtils.equals(password, this.password)) {
            throw new UnsupportedOperationException("Not supported by DruidDataSource");
        }
        return this.getConnection();
    }

    @Override
    public long getCreateCount() {
        this.lock.lock();
        try {
            long l = this.createCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getDestroyCount() {
        this.lock.lock();
        try {
            long l = this.destroyCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getConnectCount() {
        this.lock.lock();
        try {
            long l = this.connectCount;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getCloseCount() {
        return this.closeCount;
    }

    @Override
    public long getConnectErrorCount() {
        return connectErrorCountUpdater.get(this);
    }

    @Override
    public int getPoolingCount() {
        this.lock.lock();
        try {
            int n = this.poolingCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getPoolingPeak() {
        this.lock.lock();
        try {
            int n = this.poolingPeak;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Date getPoolingPeakTime() {
        if (this.poolingPeakTime <= 0L) {
            return null;
        }
        return new Date(this.poolingPeakTime);
    }

    @Override
    public long getRecycleCount() {
        return this.recycleCount;
    }

    @Override
    public int getActiveCount() {
        this.lock.lock();
        try {
            int n = this.activeCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void logStats() {
        DruidDataSourceStatLogger statLogger = this.statLogger;
        if (statLogger == null) {
            return;
        }
        DruidDataSourceStatValue statValue = this.getStatValueAndReset();
        statLogger.log(statValue);
    }

    public DruidDataSourceStatValue getStatValueAndReset() {
        DruidDataSourceStatValue value = new DruidDataSourceStatValue();
        this.lock.lock();
        try {
            value.setPoolingCount(this.poolingCount);
            value.setPoolingPeak(this.poolingPeak);
            value.setPoolingPeakTime(this.poolingPeakTime);
            value.setActiveCount(this.activeCount);
            value.setActivePeak(this.activePeak);
            value.setActivePeakTime(this.activePeakTime);
            value.setConnectCount(this.connectCount);
            value.setCloseCount(this.closeCount);
            value.setWaitThreadCount(this.lock.getWaitQueueLength(this.notEmpty));
            value.setNotEmptyWaitCount(this.notEmptyWaitCount);
            value.setNotEmptyWaitNanos(this.notEmptyWaitNanos);
            value.setKeepAliveCheckCount(this.keepAliveCheckCount);
            this.poolingPeak = 0;
            this.poolingPeakTime = 0L;
            this.activePeak = 0;
            this.activePeakTime = 0L;
            this.connectCount = 0L;
            this.closeCount = 0L;
            this.keepAliveCheckCount = 0;
            this.notEmptyWaitCount = 0L;
            this.notEmptyWaitNanos = 0L;
        }
        finally {
            this.lock.unlock();
        }
        value.setName(this.getName());
        value.setDbType(this.dbTypeName);
        value.setDriverClassName(this.getDriverClassName());
        value.setUrl(this.getUrl());
        value.setUserName(this.getUsername());
        value.setFilterClassNames(this.getFilterClassNames());
        value.setInitialSize(this.getInitialSize());
        value.setMinIdle(this.getMinIdle());
        value.setMaxActive(this.getMaxActive());
        value.setQueryTimeout(this.getQueryTimeout());
        value.setTransactionQueryTimeout(this.getTransactionQueryTimeout());
        value.setLoginTimeout(this.getLoginTimeout());
        value.setValidConnectionCheckerClassName(this.getValidConnectionCheckerClassName());
        value.setExceptionSorterClassName(this.getExceptionSorterClassName());
        value.setTestOnBorrow(this.testOnBorrow);
        value.setTestOnReturn(this.testOnReturn);
        value.setTestWhileIdle(this.testWhileIdle);
        value.setDefaultAutoCommit(this.isDefaultAutoCommit());
        if (this.defaultReadOnly != null) {
            value.setDefaultReadOnly(this.defaultReadOnly);
        }
        value.setDefaultTransactionIsolation(this.getDefaultTransactionIsolation());
        value.setLogicConnectErrorCount(connectErrorCountUpdater.getAndSet(this, 0L));
        value.setPhysicalConnectCount(createCountUpdater.getAndSet(this, 0L));
        value.setPhysicalCloseCount(destroyCountUpdater.getAndSet(this, 0L));
        value.setPhysicalConnectErrorCount(createErrorCountUpdater.getAndSet(this, 0));
        value.setExecuteCount(this.getAndResetExecuteCount());
        value.setErrorCount(errorCountUpdater.getAndSet(this, 0L));
        value.setCommitCount(commitCountUpdater.getAndSet(this, 0L));
        value.setRollbackCount(rollbackCountUpdater.getAndSet(this, 0L));
        value.setPstmtCacheHitCount(cachedPreparedStatementHitCountUpdater.getAndSet(this, 0L));
        value.setPstmtCacheMissCount(cachedPreparedStatementMissCountUpdater.getAndSet(this, 0L));
        value.setStartTransactionCount(startTransactionCountUpdater.getAndSet(this, 0L));
        value.setTransactionHistogram(this.getTransactionHistogram().toArrayAndReset());
        value.setConnectionHoldTimeHistogram(this.getDataSourceStat().getConnectionHoldHistogram().toArrayAndReset());
        value.setRemoveAbandoned(this.isRemoveAbandoned());
        value.setClobOpenCount(this.getDataSourceStat().getClobOpenCountAndReset());
        value.setBlobOpenCount(this.getDataSourceStat().getBlobOpenCountAndReset());
        value.setSqlSkipCount(this.getDataSourceStat().getSkipSqlCountAndReset());
        value.setSqlList(this.getDataSourceStat().getSqlStatMapAndReset());
        return value;
    }

    @Override
    public long getRemoveAbandonedCount() {
        return this.removeAbandonedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean put(DruidAbstractDataSource.PhysicalConnectionInfo physicalConnectionInfo) {
        DruidConnectionHolder holder;
        try {
            holder = new DruidConnectionHolder(this, physicalConnectionInfo);
        }
        catch (SQLException ex) {
            this.lock.lock();
            try {
                if (this.createScheduler != null) {
                    this.clearCreateTask(physicalConnectionInfo.createTaskId);
                }
            }
            finally {
                this.lock.unlock();
            }
            LOG.error("create connection holder error", ex);
            return false;
        }
        return this.put(holder, physicalConnectionInfo.createTaskId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean put(DruidConnectionHolder holder, long createTaskId, boolean checkExists) {
        this.lock.lock();
        try {
            if (this.closing || this.closed) {
                boolean bl = false;
                return bl;
            }
            if (this.activeCount + this.poolingCount >= this.maxActive) {
                if (this.createScheduler != null) {
                    this.clearCreateTask(createTaskId);
                }
                boolean bl = false;
                return bl;
            }
            if (checkExists) {
                for (int i = 0; i < this.poolingCount; ++i) {
                    if (this.connections[i] != holder) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            this.connections[this.poolingCount] = holder;
            this.incrementPoolingCount();
            if (this.poolingCount > this.poolingPeak) {
                this.poolingPeak = this.poolingCount;
                this.poolingPeakTime = System.currentTimeMillis();
            }
            this.notEmpty.signal();
            ++this.notEmptySignalCount;
            if (this.createScheduler != null) {
                this.clearCreateTask(createTaskId);
                if (this.poolingCount + this.createTaskCount < this.notEmptyWaitThreadCount) {
                    this.emptySignal();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAbandoned() {
        int removeCount = 0;
        if (this.activeConnections.size() == 0) {
            return removeCount;
        }
        long currrentNanos = System.nanoTime();
        ArrayList<DruidPooledConnection> abandonedList = new ArrayList<DruidPooledConnection>();
        this.activeConnectionLock.lock();
        try {
            Iterator iter = this.activeConnections.keySet().iterator();
            while (iter.hasNext()) {
                long timeMillis;
                DruidPooledConnection pooledConnection = (DruidPooledConnection)iter.next();
                if (pooledConnection.isRunning() || (timeMillis = (currrentNanos - pooledConnection.getConnectedTimeNano()) / 1000000L) < this.removeAbandonedTimeoutMillis) continue;
                iter.remove();
                pooledConnection.setTraceEnable(false);
                abandonedList.add(pooledConnection);
            }
        }
        finally {
            this.activeConnectionLock.unlock();
        }
        if (abandonedList.size() > 0) {
            for (DruidPooledConnection pooledConnection : abandonedList) {
                int i;
                ReentrantLock lock = pooledConnection.lock;
                lock.lock();
                try {
                    if (pooledConnection.isDisable()) {
                        continue;
                    }
                }
                finally {
                    lock.unlock();
                    continue;
                }
                JdbcUtils.close(pooledConnection);
                pooledConnection.abandond();
                ++this.removeAbandonedCount;
                ++removeCount;
                if (!this.isLogAbandoned()) continue;
                StringBuilder buf = new StringBuilder();
                buf.append("abandon connection, owner thread: ");
                buf.append(pooledConnection.getOwnerThread().getName());
                buf.append(", connected at : ");
                buf.append(pooledConnection.getConnectedTimeMillis());
                buf.append(", open stackTrace\n");
                StackTraceElement[] trace = pooledConnection.getConnectStackTrace();
                for (i = 0; i < trace.length; ++i) {
                    buf.append("\tat ");
                    buf.append(trace[i].toString());
                    buf.append("\n");
                }
                buf.append("ownerThread current state is ").append((Object)pooledConnection.getOwnerThread().getState()).append(", current stackTrace\n");
                trace = pooledConnection.getOwnerThread().getStackTrace();
                for (i = 0; i < trace.length; ++i) {
                    buf.append("\tat ");
                    buf.append(trace[i].toString());
                    buf.append("\n");
                }
                LOG.error(buf.toString());
            }
        }
        return removeCount;
    }

    @Override
    public Reference getReference() throws NamingException {
        String className = this.getClass().getName();
        String factoryName = className + "Factory";
        Reference ref = new Reference(className, factoryName, null);
        ref.add(new StringRefAddr("instanceKey", this.instanceKey));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("username", this.getUsername()));
        ref.add(new StringRefAddr("password", this.getPassword()));
        return ref;
    }

    @Override
    public List<String> getFilterClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Filter filter : this.filters) {
            names.add(filter.getClass().getName());
        }
        return names;
    }

    @Override
    public int getRawDriverMajorVersion() {
        int version = -1;
        if (this.driver != null) {
            version = this.driver.getMajorVersion();
        }
        return version;
    }

    @Override
    public int getRawDriverMinorVersion() {
        int version = -1;
        if (this.driver != null) {
            version = this.driver.getMinorVersion();
        }
        return version;
    }

    @Override
    public String getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.connectProperties);
        if (properties.containsKey("password")) {
            properties.put("password", "******");
        }
        return properties.toString();
    }

    @Override
    public void shrink() {
        this.shrink(false, false);
    }

    public void shrink(boolean checkTime) {
        this.shrink(checkTime, this.keepAlive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink(boolean checkTime, boolean keepAlive) {
        Connection connection;
        int i;
        if (this.poolingCount == 0) {
            return;
        }
        ReentrantLock lock = this.lock;
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            return;
        }
        boolean needFill = false;
        int evictCount = 0;
        int keepAliveCount = 0;
        int fatalErrorIncrement = this.fatalErrorCount - this.fatalErrorCountLastShrink;
        this.fatalErrorCountLastShrink = this.fatalErrorCount;
        try {
            int removeCount;
            int i2;
            if (!this.inited) {
                return;
            }
            int checkCount = this.poolingCount - this.minIdle;
            long currentTimeMillis = System.currentTimeMillis();
            int remaining = 0;
            for (i2 = 0; i2 < this.poolingCount; ++i2) {
                DruidConnectionHolder connection2 = this.connections[i2];
                if ((this.onFatalError || fatalErrorIncrement > 0) && this.lastFatalErrorTimeMillis > connection2.connectTimeMillis) {
                    this.keepAliveConnections[keepAliveCount++] = connection2;
                    continue;
                }
                if (checkTime) {
                    long phyConnectTimeMillis;
                    if (this.phyTimeoutMillis > 0L && (phyConnectTimeMillis = currentTimeMillis - connection2.connectTimeMillis) > this.phyTimeoutMillis) {
                        this.evictConnections[evictCount++] = connection2;
                        continue;
                    }
                    long idleMillis = currentTimeMillis - connection2.lastActiveTimeMillis;
                    if (idleMillis < this.minEvictableIdleTimeMillis && idleMillis < this.keepAliveBetweenTimeMillis) break;
                    if (idleMillis >= this.minEvictableIdleTimeMillis) {
                        if (i2 < checkCount) {
                            this.evictConnections[evictCount++] = connection2;
                            continue;
                        }
                        if (idleMillis > this.maxEvictableIdleTimeMillis) {
                            this.evictConnections[evictCount++] = connection2;
                            continue;
                        }
                    }
                    if (keepAlive && idleMillis >= this.keepAliveBetweenTimeMillis && currentTimeMillis - connection2.lastKeepTimeMillis >= this.keepAliveBetweenTimeMillis) {
                        this.keepAliveConnections[keepAliveCount++] = connection2;
                        continue;
                    }
                    if (i2 != remaining) {
                        this.connections[remaining] = connection2;
                    }
                    ++remaining;
                    continue;
                }
                if (i2 >= checkCount) break;
                this.evictConnections[evictCount++] = connection2;
            }
            if ((removeCount = evictCount + keepAliveCount) > 0) {
                int breakedCount = this.poolingCount - i2;
                if (breakedCount > 0) {
                    System.arraycopy(this.connections, i2, this.connections, remaining, breakedCount);
                    remaining += breakedCount;
                }
                System.arraycopy(this.nullConnections, 0, this.connections, remaining, removeCount);
                this.poolingCount -= removeCount;
            }
            this.keepAliveCheckCount += keepAliveCount;
            if (keepAlive && this.poolingCount + this.activeCount < this.minIdle) {
                needFill = true;
            }
        }
        finally {
            lock.unlock();
        }
        if (evictCount > 0) {
            for (i = 0; i < evictCount; ++i) {
                DruidConnectionHolder item = this.evictConnections[i];
                connection = item.getConnection();
                JdbcUtils.close(connection);
                destroyCountUpdater.incrementAndGet(this);
            }
            System.arraycopy(this.nullConnections, 0, this.evictConnections, 0, this.evictConnections.length);
        }
        if (keepAliveCount > 0) {
            for (i = keepAliveCount - 1; i >= 0; --i) {
                block47: {
                    DruidConnectionHolder holder;
                    block46: {
                        boolean discard;
                        boolean validate;
                        block45: {
                            holder = this.keepAliveConnections[i];
                            connection = holder.getConnection();
                            holder.incrementKeepAliveCheckCount();
                            validate = false;
                            try {
                                this.validateConnection(connection);
                                validate = true;
                            }
                            catch (Throwable error) {
                                this.keepAliveCheckErrorLast = error;
                                keepAliveCheckErrorCountUpdater.incrementAndGet(this);
                                if (!LOG.isDebugEnabled()) break block45;
                                LOG.debug("keepAliveErr", error);
                            }
                        }
                        boolean bl = discard = !validate;
                        if (validate) {
                            holder.lastKeepTimeMillis = System.currentTimeMillis();
                            boolean putOk = this.put(holder, 0L, true);
                            if (!putOk) {
                                discard = true;
                            }
                        }
                        if (!discard) continue;
                        try {
                            connection.close();
                        }
                        catch (Exception error) {
                            this.discardErrorLast = error;
                            discardErrorCountUpdater.incrementAndGet(this);
                            if (!LOG.isErrorEnabled()) break block46;
                            LOG.error("discard connection error", error);
                        }
                    }
                    if (holder.socket != null) {
                        try {
                            holder.socket.close();
                        }
                        catch (Exception error) {
                            this.discardErrorLast = error;
                            discardErrorCountUpdater.incrementAndGet(this);
                            if (!LOG.isErrorEnabled()) break block47;
                            LOG.error("discard connection error", error);
                        }
                    }
                }
                lock.lock();
                try {
                    holder.discard = true;
                    ++this.discardCount;
                    if (this.activeCount + this.poolingCount + this.createTaskCount >= this.minIdle) continue;
                    needFill = true;
                    continue;
                }
                finally {
                    lock.unlock();
                }
            }
            this.getDataSourceStat().addKeepAliveCheckCount(keepAliveCount);
            System.arraycopy(this.nullConnections, 0, this.keepAliveConnections, 0, this.keepAliveConnections.length);
        }
        if (needFill) {
            lock.lock();
            try {
                int fillCount = this.minIdle - (this.activeCount + this.poolingCount + this.createTaskCount);
                this.emptySignal(fillCount);
            }
            finally {
                lock.unlock();
            }
        }
        if (fatalErrorIncrement > 0) {
            lock.lock();
            try {
                this.emptySignal();
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public int getWaitThreadCount() {
        this.lock.lock();
        try {
            int n = this.lock.getWaitQueueLength(this.notEmpty);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getNotEmptyWaitCount() {
        return this.notEmptyWaitCount;
    }

    @Override
    public int getNotEmptyWaitThreadCount() {
        this.lock.lock();
        try {
            int n = this.notEmptyWaitThreadCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getNotEmptyWaitThreadPeak() {
        this.lock.lock();
        try {
            int n = this.notEmptyWaitThreadPeak;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getNotEmptySignalCount() {
        return this.notEmptySignalCount;
    }

    @Override
    public long getNotEmptyWaitMillis() {
        return this.notEmptyWaitNanos / 1000000L;
    }

    @Override
    public long getNotEmptyWaitNanos() {
        return this.notEmptyWaitNanos;
    }

    @Override
    public int getLockQueueLength() {
        return this.lock.getQueueLength();
    }

    @Override
    public int getActivePeak() {
        return this.activePeak;
    }

    @Override
    public Date getActivePeakTime() {
        if (this.activePeakTime <= 0L) {
            return null;
        }
        return new Date(this.activePeakTime);
    }

    @Override
    public String dump() {
        this.lock.lock();
        try {
            String string = this.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getErrorCount() {
        return this.errorCount;
    }

    public String toString() {
        DruidConnectionHolder conn;
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        buf.append("\n\tCreateTime:\"");
        buf.append(Utils.toString(this.getCreatedTime()));
        buf.append("\"");
        buf.append(",\n\tActiveCount:");
        buf.append(this.getActiveCount());
        buf.append(",\n\tPoolingCount:");
        buf.append(this.getPoolingCount());
        buf.append(",\n\tCreateCount:");
        buf.append(this.getCreateCount());
        buf.append(",\n\tDestroyCount:");
        buf.append(this.getDestroyCount());
        buf.append(",\n\tCloseCount:");
        buf.append(this.getCloseCount());
        buf.append(",\n\tConnectCount:");
        buf.append(this.getConnectCount());
        buf.append(",\n\tConnections:[");
        for (i = 0; i < this.poolingCount; ++i) {
            conn = this.connections[i];
            if (conn == null) continue;
            if (i != 0) {
                buf.append(",");
            }
            buf.append("\n\t\t");
            buf.append(conn.toString());
        }
        buf.append("\n\t]");
        buf.append("\n}");
        if (this.isPoolPreparedStatements()) {
            buf.append("\n\n[");
            for (i = 0; i < this.poolingCount; ++i) {
                conn = this.connections[i];
                if (conn == null) continue;
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("\n\t{\n\tID:");
                buf.append(System.identityHashCode(conn.getConnection()));
                PreparedStatementPool pool = conn.getStatementPool();
                buf.append(", \n\tpoolStatements:[");
                int entryIndex = 0;
                try {
                    for (Map.Entry<DruidPooledPreparedStatement.PreparedStatementKey, PreparedStatementHolder> entry : pool.getMap().entrySet()) {
                        if (entryIndex != 0) {
                            buf.append(",");
                        }
                        buf.append("\n\t\t{hitCount:");
                        buf.append(entry.getValue().getHitCount());
                        buf.append(",sql:\"");
                        buf.append(entry.getKey().getSql());
                        buf.append("\"");
                        buf.append("\t}");
                        ++entryIndex;
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                buf.append("\n\t\t]");
                buf.append("\n\t}");
            }
            buf.append("\n]");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getPoolingConnectionInfo() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.lock.lock();
        try {
            for (int i = 0; i < this.poolingCount; ++i) {
                DruidConnectionHolder connHolder = this.connections[i];
                Connection conn = connHolder.getConnection();
                LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>();
                map.put("id", Integer.valueOf(System.identityHashCode(conn)));
                map.put("connectionId", Long.valueOf(connHolder.getConnectionId()));
                map.put("useCount", Long.valueOf(connHolder.getUseCount()));
                if (connHolder.lastActiveTimeMillis > 0L) {
                    map.put("lastActiveTime", new Date(connHolder.lastActiveTimeMillis));
                }
                if (connHolder.lastKeepTimeMillis > 0L) {
                    map.put("lastKeepTimeMillis", new Date(connHolder.lastKeepTimeMillis));
                }
                map.put("connectTime", new Date(connHolder.getTimeMillis()));
                map.put("holdability", Integer.valueOf(connHolder.getUnderlyingHoldability()));
                map.put("transactionIsolation", Integer.valueOf(connHolder.getUnderlyingTransactionIsolation()));
                map.put("autoCommit", Boolean.valueOf(connHolder.underlyingAutoCommit));
                map.put("readoOnly", Boolean.valueOf(connHolder.isUnderlyingReadOnly()));
                if (connHolder.isPoolPreparedStatements()) {
                    ArrayList stmtCache = new ArrayList();
                    PreparedStatementPool stmtPool = connHolder.getStatementPool();
                    for (PreparedStatementHolder stmtHolder : stmtPool.getMap().values()) {
                        LinkedHashMap<String, Object> stmtInfo = new LinkedHashMap<String, Object>();
                        stmtInfo.put("sql", stmtHolder.key.getSql());
                        stmtInfo.put("defaultRowPrefetch", stmtHolder.getDefaultRowPrefetch());
                        stmtInfo.put("rowPrefetch", stmtHolder.getRowPrefetch());
                        stmtInfo.put("hitCount", stmtHolder.getHitCount());
                        stmtCache.add(stmtInfo);
                    }
                    map.put("pscache", stmtCache);
                }
                map.put("keepAliveCheckCount", Long.valueOf(connHolder.getKeepAliveCheckCount()));
                list.add(map);
            }
        }
        finally {
            this.lock.unlock();
        }
        return list;
    }

    @Override
    public void logTransaction(TransactionInfo info) {
        long transactionMillis = info.getEndTimeMillis() - info.getStartTimeMillis();
        if (this.transactionThresholdMillis > 0L && transactionMillis > this.transactionThresholdMillis) {
            StringBuilder buf = new StringBuilder();
            buf.append("long time transaction, take ");
            buf.append(transactionMillis);
            buf.append(" ms : ");
            for (String sql : info.getSqlList()) {
                buf.append(sql);
                buf.append(";");
            }
            LOG.error(buf.toString(), new TransactionTimeoutException());
        }
    }

    @Override
    public String getVersion() {
        return VERSION.getVersionNumber();
    }

    @Override
    public JdbcDataSourceStat getDataSourceStat() {
        return this.dataSourceStat;
    }

    public Object clone() {
        return this.cloneDruidDataSource();
    }

    public DruidDataSource cloneDruidDataSource() {
        DruidDataSource x = new DruidDataSource();
        this.cloneTo(x);
        return x;
    }

    public Map<String, Object> getStatDataForMBean() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Name", this.getName());
            map.put("URL", this.getUrl());
            map.put("CreateCount", this.getCreateCount());
            map.put("DestroyCount", this.getDestroyCount());
            map.put("ConnectCount", this.getConnectCount());
            map.put("CloseCount", this.getCloseCount());
            map.put("ActiveCount", this.getActiveCount());
            map.put("PoolingCount", this.getPoolingCount());
            map.put("LockQueueLength", this.getLockQueueLength());
            map.put("WaitThreadCount", this.getNotEmptyWaitThreadCount());
            map.put("InitialSize", this.getInitialSize());
            map.put("MaxActive", this.getMaxActive());
            map.put("MinIdle", this.getMinIdle());
            map.put("PoolPreparedStatements", this.isPoolPreparedStatements());
            map.put("TestOnBorrow", this.isTestOnBorrow());
            map.put("TestOnReturn", this.isTestOnReturn());
            map.put("MinEvictableIdleTimeMillis", this.minEvictableIdleTimeMillis);
            map.put("ConnectErrorCount", this.getConnectErrorCount());
            map.put("CreateTimespanMillis", this.getCreateTimespanMillis());
            map.put("DbType", this.dbTypeName);
            map.put("ValidationQuery", this.getValidationQuery());
            map.put("ValidationQueryTimeout", this.getValidationQueryTimeout());
            map.put("DriverClassName", this.getDriverClassName());
            map.put("Username", this.getUsername());
            map.put("RemoveAbandonedCount", this.getRemoveAbandonedCount());
            map.put("NotEmptyWaitCount", this.getNotEmptyWaitCount());
            map.put("NotEmptyWaitNanos", this.getNotEmptyWaitNanos());
            map.put("ErrorCount", this.getErrorCount());
            map.put("ReusePreparedStatementCount", this.getCachedPreparedStatementHitCount());
            map.put("StartTransactionCount", this.getStartTransactionCount());
            map.put("CommitCount", this.getCommitCount());
            map.put("RollbackCount", this.getRollbackCount());
            map.put("LastError", JMXUtils.getErrorCompositeData(this.getLastError()));
            map.put("LastCreateError", JMXUtils.getErrorCompositeData(this.getLastCreateError()));
            map.put("PreparedStatementCacheDeleteCount", this.getCachedPreparedStatementDeleteCount());
            map.put("PreparedStatementCacheAccessCount", this.getCachedPreparedStatementAccessCount());
            map.put("PreparedStatementCacheMissCount", this.getCachedPreparedStatementMissCount());
            map.put("PreparedStatementCacheHitCount", this.getCachedPreparedStatementHitCount());
            map.put("PreparedStatementCacheCurrentCount", this.getCachedPreparedStatementCount());
            map.put("Version", this.getVersion());
            map.put("LastErrorTime", this.getLastErrorTime());
            map.put("LastCreateErrorTime", this.getLastCreateErrorTime());
            map.put("CreateErrorCount", this.getCreateErrorCount());
            map.put("DiscardCount", this.getDiscardCount());
            map.put("ExecuteQueryCount", this.getExecuteQueryCount());
            map.put("ExecuteUpdateCount", this.getExecuteUpdateCount());
            map.put("InitStackTrace", this.getInitStackTrace());
            return map;
        }
        catch (JMException ex) {
            throw new IllegalStateException("getStatData error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getStatData() {
        long closeCount;
        long connectCount;
        Date activePeakTime;
        int activePeak;
        int activeCount;
        Date poolingPeakTime;
        int poolingPeak;
        int poolingCount;
        this.lock.lock();
        try {
            poolingCount = this.poolingCount;
            poolingPeak = this.poolingPeak;
            poolingPeakTime = this.getPoolingPeakTime();
            activeCount = this.activeCount;
            activePeak = this.activePeak;
            activePeakTime = this.getActivePeakTime();
            connectCount = this.connectCount;
            closeCount = this.closeCount;
        }
        finally {
            this.lock.unlock();
        }
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("Identity", System.identityHashCode(this));
        dataMap.put("Name", this.getName());
        dataMap.put("DbType", this.dbTypeName);
        dataMap.put("DriverClassName", this.getDriverClassName());
        dataMap.put("URL", this.getUrl());
        dataMap.put("UserName", this.getUsername());
        dataMap.put("FilterClassNames", this.getFilterClassNames());
        dataMap.put("WaitThreadCount", this.getWaitThreadCount());
        dataMap.put("NotEmptyWaitCount", this.getNotEmptyWaitCount());
        dataMap.put("NotEmptyWaitMillis", this.getNotEmptyWaitMillis());
        dataMap.put("PoolingCount", poolingCount);
        dataMap.put("PoolingPeak", poolingPeak);
        dataMap.put("PoolingPeakTime", poolingPeakTime);
        dataMap.put("ActiveCount", activeCount);
        dataMap.put("ActivePeak", activePeak);
        dataMap.put("ActivePeakTime", activePeakTime);
        dataMap.put("InitialSize", this.getInitialSize());
        dataMap.put("MinIdle", this.getMinIdle());
        dataMap.put("MaxActive", this.getMaxActive());
        dataMap.put("QueryTimeout", this.getQueryTimeout());
        dataMap.put("TransactionQueryTimeout", this.getTransactionQueryTimeout());
        dataMap.put("LoginTimeout", this.getLoginTimeout());
        dataMap.put("ValidConnectionCheckerClassName", this.getValidConnectionCheckerClassName());
        dataMap.put("ExceptionSorterClassName", this.getExceptionSorterClassName());
        dataMap.put("TestOnBorrow", this.isTestOnBorrow());
        dataMap.put("TestOnReturn", this.isTestOnReturn());
        dataMap.put("TestWhileIdle", this.isTestWhileIdle());
        dataMap.put("DefaultAutoCommit", this.isDefaultAutoCommit());
        dataMap.put("DefaultReadOnly", this.getDefaultReadOnly());
        dataMap.put("DefaultTransactionIsolation", this.getDefaultTransactionIsolation());
        dataMap.put("LogicConnectCount", connectCount);
        dataMap.put("LogicCloseCount", closeCount);
        dataMap.put("LogicConnectErrorCount", this.getConnectErrorCount());
        dataMap.put("PhysicalConnectCount", this.getCreateCount());
        dataMap.put("PhysicalCloseCount", this.getDestroyCount());
        dataMap.put("PhysicalConnectErrorCount", this.getCreateErrorCount());
        dataMap.put("DiscardCount", this.getDiscardCount());
        dataMap.put("ExecuteCount", this.getExecuteCount());
        dataMap.put("ExecuteUpdateCount", this.getExecuteUpdateCount());
        dataMap.put("ExecuteQueryCount", this.getExecuteQueryCount());
        dataMap.put("ExecuteBatchCount", this.getExecuteBatchCount());
        dataMap.put("ErrorCount", this.getErrorCount());
        dataMap.put("CommitCount", this.getCommitCount());
        dataMap.put("RollbackCount", this.getRollbackCount());
        dataMap.put("PSCacheAccessCount", this.getCachedPreparedStatementAccessCount());
        dataMap.put("PSCacheHitCount", this.getCachedPreparedStatementHitCount());
        dataMap.put("PSCacheMissCount", this.getCachedPreparedStatementMissCount());
        dataMap.put("StartTransactionCount", this.getStartTransactionCount());
        dataMap.put("TransactionHistogram", this.getTransactionHistogramValues());
        dataMap.put("ConnectionHoldTimeHistogram", this.getDataSourceStat().getConnectionHoldHistogram().toArray());
        dataMap.put("RemoveAbandoned", this.isRemoveAbandoned());
        dataMap.put("ClobOpenCount", this.getDataSourceStat().getClobOpenCount());
        dataMap.put("BlobOpenCount", this.getDataSourceStat().getBlobOpenCount());
        dataMap.put("KeepAliveCheckCount", this.getDataSourceStat().getKeepAliveCheckCount());
        dataMap.put("KeepAlive", this.isKeepAlive());
        dataMap.put("FailFast", this.isFailFast());
        dataMap.put("MaxWait", this.getMaxWait());
        dataMap.put("MaxWaitThreadCount", this.getMaxWaitThreadCount());
        dataMap.put("PoolPreparedStatements", this.isPoolPreparedStatements());
        dataMap.put("MaxPoolPreparedStatementPerConnectionSize", this.getMaxPoolPreparedStatementPerConnectionSize());
        dataMap.put("MinEvictableIdleTimeMillis", this.minEvictableIdleTimeMillis);
        dataMap.put("MaxEvictableIdleTimeMillis", this.maxEvictableIdleTimeMillis);
        dataMap.put("LogDifferentThread", this.isLogDifferentThread());
        dataMap.put("RecycleErrorCount", this.getRecycleErrorCount());
        dataMap.put("PreparedStatementOpenCount", this.getPreparedStatementCount());
        dataMap.put("PreparedStatementClosedCount", this.getClosedPreparedStatementCount());
        dataMap.put("UseUnfairLock", this.isUseUnfairLock());
        dataMap.put("InitGlobalVariants", this.isInitGlobalVariants());
        dataMap.put("InitVariants", this.isInitVariants());
        return dataMap;
    }

    public JdbcSqlStat getSqlStat(int sqlId) {
        return this.getDataSourceStat().getSqlStat(sqlId);
    }

    public JdbcSqlStat getSqlStat(long sqlId) {
        return this.getDataSourceStat().getSqlStat(sqlId);
    }

    public Map<String, JdbcSqlStat> getSqlStatMap() {
        return this.getDataSourceStat().getSqlStatMap();
    }

    public Map<String, Object> getWallStatMap() {
        WallProviderStatValue wallStatValue = this.getWallStatValue(false);
        if (wallStatValue != null) {
            return wallStatValue.toMap();
        }
        return null;
    }

    public WallProviderStatValue getWallStatValue(boolean reset) {
        for (Filter filter : this.filters) {
            if (!(filter instanceof WallFilter)) continue;
            WallFilter wallFilter = (WallFilter)filter;
            return wallFilter.getProvider().getStatValue(reset);
        }
        return null;
    }

    public Lock getLock() {
        return this.lock;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        for (Filter filter : this.filters) {
            if (!filter.isWrapperFor(iface)) continue;
            return true;
        }
        if (this.statLogger != null && (this.statLogger.getClass() == iface || DruidDataSourceStatLogger.class == iface)) {
            return true;
        }
        return super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        for (Filter filter : this.filters) {
            if (!filter.isWrapperFor(iface)) continue;
            return (T)filter;
        }
        if (this.statLogger != null && (this.statLogger.getClass() == iface || DruidDataSourceStatLogger.class == iface)) {
            return (T)this.statLogger;
        }
        return super.unwrap(iface);
    }

    public boolean isLogDifferentThread() {
        return this.logDifferentThread;
    }

    public void setLogDifferentThread(boolean logDifferentThread) {
        this.logDifferentThread = logDifferentThread;
    }

    public DruidPooledConnection tryGetConnection() throws SQLException {
        if (this.poolingCount == 0) {
            return null;
        }
        return this.getConnection();
    }

    @Override
    public int fill() throws SQLException {
        return this.fill(this.maxActive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(int toCount) throws SQLException {
        if (this.closed) {
            throw new DataSourceClosedException("dataSource already closed at " + new Date(this.closeTimeMillis));
        }
        if (toCount < 0) {
            throw new IllegalArgumentException("toCount can't not be less than zero");
        }
        this.init();
        if (toCount > this.maxActive) {
            toCount = this.maxActive;
        }
        int fillCount = 0;
        while (true) {
            boolean result;
            DruidConnectionHolder holder;
            try {
                this.lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                connectErrorCountUpdater.incrementAndGet(this);
                throw new SQLException("interrupt", e);
            }
            boolean fillable = this.isFillable(toCount);
            this.lock.unlock();
            if (!fillable) break;
            try {
                DruidAbstractDataSource.PhysicalConnectionInfo pyConnInfo = this.createPhysicalConnection();
                holder = new DruidConnectionHolder(this, pyConnInfo);
            }
            catch (SQLException e) {
                LOG.error("fill connection error, url: " + DruidDataSource.sanitizedUrl(this.jdbcUrl), e);
                connectErrorCountUpdater.incrementAndGet(this);
                throw e;
            }
            try {
                this.lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                connectErrorCountUpdater.incrementAndGet(this);
                throw new SQLException("interrupt", e);
            }
            try {
                if (!this.isFillable(toCount)) {
                    JdbcUtils.close(holder.getConnection());
                    LOG.info("fill connections skip.");
                    break;
                }
                result = this.putLast(holder, System.currentTimeMillis());
                ++fillCount;
            }
            finally {
                this.lock.unlock();
            }
            if (result) continue;
            JdbcUtils.close(holder.getConnection());
            LOG.info("connection fill failed.");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("fill " + fillCount + " connections");
        }
        return fillCount;
    }

    static String sanitizedUrl(String url) {
        if (url == null) {
            return null;
        }
        for (String pwdKeyNamesInMysql : new String[]{"password=", "password1=", "password2=", "password3=", "trustCertificateKeyStorePassword=", "clientCertificateKeyStorePassword="}) {
            if (!url.contains(pwdKeyNamesInMysql)) continue;
            url = url.replaceAll("([?&;]" + pwdKeyNamesInMysql + ")[^&#;]*(.*)", "$1<masked>$2");
        }
        return url;
    }

    private boolean isFillable(int toCount) {
        int currentCount = this.poolingCount + this.activeCount;
        return currentCount < toCount && currentCount < this.maxActive;
    }

    public boolean isFull() {
        this.lock.lock();
        try {
            boolean bl = this.poolingCount + this.activeCount >= this.maxActive;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void emptySignal() {
        this.emptySignal(1);
    }

    private void emptySignal(int fillCount) {
        if (this.createScheduler == null) {
            if (this.activeCount + this.poolingCount >= this.maxActive) {
                return;
            }
            this.empty.signal();
            return;
        }
        for (int i = 0; i < fillCount; ++i) {
            if (this.activeCount + this.poolingCount + this.createTaskCount >= this.maxActive) {
                return;
            }
            if (this.createTaskCount >= this.maxCreateTaskCount) {
                return;
            }
            this.submitCreateTask(false);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (server != null) {
            try {
                if (server.isRegistered(name)) {
                    server.unregisterMBean(name);
                }
            }
            catch (Exception ex) {
                LOG.warn("DruidDataSource preRegister error", ex);
            }
        }
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isCheckExecuteTime() {
        return this.checkExecuteTime;
    }

    public void setCheckExecuteTime(boolean checkExecuteTime) {
        this.checkExecuteTime = checkExecuteTime;
    }

    public boolean isLoadSpifilterSkip() {
        return this.loadSpifilterSkip;
    }

    public void setLoadSpifilterSkip(boolean loadSpifilterSkip) {
        this.loadSpifilterSkip = loadSpifilterSkip;
    }

    public void forEach(Connection conn) {
    }

    static {
        recycleErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(DruidDataSource.class, "recycleErrorCount");
        connectErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(DruidDataSource.class, "connectErrorCount");
        resetCountUpdater = AtomicLongFieldUpdater.newUpdater(DruidDataSource.class, "resetCount");
        createTaskIdSeedUpdater = AtomicLongFieldUpdater.newUpdater(DruidDataSource.class, "createTaskIdSeed");
        discardErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(DruidDataSource.class, "discardErrorCount");
        keepAliveCheckErrorCountUpdater = AtomicIntegerFieldUpdater.newUpdater(DruidDataSource.class, "keepAliveCheckErrorCount");
        createDirectCountUpdater = AtomicIntegerFieldUpdater.newUpdater(DruidDataSource.class, "createDirectCount");
    }

    public class DestroyTask
    implements Runnable {
        @Override
        public void run() {
            DruidDataSource.this.shrink(true, DruidDataSource.this.keepAlive);
            if (DruidDataSource.this.isRemoveAbandoned()) {
                DruidDataSource.this.removeAbandoned();
            }
        }
    }

    public class CreateConnectionThread
    extends Thread {
        private final CountDownLatch initedLatch;

        public CreateConnectionThread(String name) {
            super(name);
            this.initedLatch = new CountDownLatch(1);
            this.setDaemon(true);
        }

        public CountDownLatch getInitedLatch() {
            return this.initedLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.initedLatch.countDown();
            long lastDiscardCount = 0L;
            int errorCount = 0;
            while (!(DruidDataSource.this.closing || DruidDataSource.this.closed || Thread.currentThread().isInterrupted())) {
                DruidAbstractDataSource.PhysicalConnectionInfo connection;
                block23: {
                    try {
                        DruidDataSource.this.lock.lockInterruptibly();
                    }
                    catch (InterruptedException e2) {
                        break;
                    }
                    long discardCount = DruidDataSource.this.discardCount;
                    boolean discardChanged = discardCount - lastDiscardCount > 0L;
                    lastDiscardCount = discardCount;
                    try {
                        boolean emptyWait;
                        boolean bl = emptyWait = DruidDataSource.this.createError == null || DruidDataSource.this.poolingCount != 0 || discardChanged;
                        if (emptyWait && DruidDataSource.this.asyncInit && DruidDataSource.this.createCount < (long)DruidDataSource.this.initialSize) {
                            emptyWait = false;
                        }
                        if (!(!emptyWait || DruidDataSource.this.poolingCount < DruidDataSource.this.notEmptyWaitThreadCount || DruidDataSource.this.keepAlive && DruidDataSource.this.activeCount + DruidDataSource.this.poolingCount < DruidDataSource.this.minIdle || DruidDataSource.this.isFailContinuous())) {
                            DruidDataSource.this.empty.await();
                        }
                        if (DruidDataSource.this.activeCount + DruidDataSource.this.poolingCount >= DruidDataSource.this.maxActive) {
                            DruidDataSource.this.empty.await();
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        DruidDataSource.this.lastCreateError = e;
                        DruidDataSource.this.lastErrorTimeMillis = System.currentTimeMillis();
                        if (DruidDataSource.this.closing || DruidDataSource.this.closed) break;
                        LOG.error("create connection thread interrupted, url: " + DruidDataSource.sanitizedUrl(DruidDataSource.this.jdbcUrl), e);
                        break;
                    }
                    finally {
                        DruidDataSource.this.lock.unlock();
                        continue;
                    }
                    connection = null;
                    try {
                        connection = DruidDataSource.this.createPhysicalConnection();
                    }
                    catch (SQLException e) {
                        LOG.error("create connection SQLException, url: " + DruidDataSource.sanitizedUrl(DruidDataSource.this.jdbcUrl) + ", errorCode " + e.getErrorCode() + ", state " + e.getSQLState(), e);
                        if (++errorCount <= DruidDataSource.this.connectionErrorRetryAttempts || DruidDataSource.this.timeBetweenConnectErrorMillis <= 0L) break block23;
                        DruidDataSource.this.setFailContinuous(true);
                        if (DruidDataSource.this.failFast) {
                            DruidDataSource.this.lock.lock();
                            try {
                                DruidDataSource.this.notEmpty.signalAll();
                            }
                            finally {
                                DruidDataSource.this.lock.unlock();
                            }
                        }
                        if (DruidDataSource.this.breakAfterAcquireFailure || DruidDataSource.this.closing || DruidDataSource.this.closed) break;
                        try {
                            Thread.sleep(DruidDataSource.this.timeBetweenConnectErrorMillis);
                        }
                        catch (InterruptedException interruptEx) {
                            break;
                        }
                    }
                    catch (RuntimeException e) {
                        LOG.error("create connection RuntimeException", e);
                        DruidDataSource.this.setFailContinuous(true);
                        continue;
                    }
                    catch (Error e) {
                        LOG.error("create connection Error", e);
                        break;
                    }
                }
                if (connection == null) continue;
                boolean result = DruidDataSource.this.put(connection);
                if (!result) {
                    JdbcUtils.close(connection.getPhysicalConnection());
                    LOG.info("put physical connection to pool failed.");
                }
                errorCount = 0;
            }
        }
    }

    public class DestroyConnectionThread
    extends Thread {
        private final CountDownLatch initedLatch;

        public DestroyConnectionThread(String name) {
            super(name);
            this.initedLatch = new CountDownLatch(1);
            this.setDaemon(true);
        }

        public CountDownLatch getInitedLatch() {
            return this.initedLatch;
        }

        @Override
        public void run() {
            this.initedLatch.countDown();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (DruidDataSource.this.closed || DruidDataSource.this.closing) break;
                    if (DruidDataSource.this.timeBetweenEvictionRunsMillis > 0L) {
                        Thread.sleep(DruidDataSource.this.timeBetweenEvictionRunsMillis);
                    } else {
                        Thread.sleep(1000L);
                    }
                    if (Thread.interrupted()) break;
                    DruidDataSource.this.destroyTask.run();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    public class CreateConnectionTask
    implements Runnable {
        private int errorCount;
        private boolean initTask;
        private final long taskId;

        public CreateConnectionTask() {
            this.taskId = createTaskIdSeedUpdater.getAndIncrement(DruidDataSource.this);
        }

        public CreateConnectionTask(boolean initTask) {
            this.taskId = createTaskIdSeedUpdater.getAndIncrement(DruidDataSource.this);
            this.initTask = initTask;
        }

        @Override
        public void run() {
            this.runInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInternal() {
            block44: {
                DruidAbstractDataSource.PhysicalConnectionInfo physicalConnection;
                while (true) {
                    block38: {
                        DruidDataSource.this.lock.lock();
                        try {
                            boolean emptyWait;
                            if (DruidDataSource.this.closed || DruidDataSource.this.closing) {
                                DruidDataSource.this.clearCreateTask(this.taskId);
                                return;
                            }
                            boolean bl = emptyWait = DruidDataSource.this.createError == null || DruidDataSource.this.poolingCount != 0;
                            if (!(!emptyWait || DruidDataSource.this.poolingCount < DruidDataSource.this.notEmptyWaitThreadCount || DruidDataSource.this.keepAlive && DruidDataSource.this.activeCount + DruidDataSource.this.poolingCount < DruidDataSource.this.minIdle || this.initTask || DruidDataSource.this.isFailContinuous() || DruidDataSource.this.isOnFatalError())) {
                                DruidDataSource.this.clearCreateTask(this.taskId);
                                return;
                            }
                            if (DruidDataSource.this.activeCount + DruidDataSource.this.poolingCount >= DruidDataSource.this.maxActive) {
                                DruidDataSource.this.clearCreateTask(this.taskId);
                                return;
                            }
                        }
                        finally {
                            DruidDataSource.this.lock.unlock();
                        }
                        physicalConnection = null;
                        try {
                            physicalConnection = DruidDataSource.this.createPhysicalConnection();
                        }
                        catch (OutOfMemoryError e) {
                            LOG.error("create connection OutOfMemoryError, out memory. ", e);
                            ++this.errorCount;
                            if (this.errorCount <= DruidDataSource.this.connectionErrorRetryAttempts || DruidDataSource.this.timeBetweenConnectErrorMillis <= 0L) break block38;
                            DruidDataSource.this.setFailContinuous(true);
                            if (DruidDataSource.this.failFast) {
                                DruidDataSource.this.lock.lock();
                                try {
                                    DruidDataSource.this.notEmpty.signalAll();
                                }
                                finally {
                                    DruidDataSource.this.lock.unlock();
                                }
                            }
                            if (DruidDataSource.this.breakAfterAcquireFailure || DruidDataSource.this.closing || DruidDataSource.this.closed) {
                                DruidDataSource.this.lock.lock();
                                try {
                                    DruidDataSource.this.clearCreateTask(this.taskId);
                                }
                                finally {
                                    DruidDataSource.this.lock.unlock();
                                }
                                return;
                            }
                            this.errorCount = 0;
                            DruidDataSource.this.createSchedulerFutures.put(this, DruidDataSource.this.createScheduler.schedule(this, DruidDataSource.this.timeBetweenConnectErrorMillis, TimeUnit.MILLISECONDS));
                            return;
                        }
                        catch (SQLException e) {
                            LOG.error("create connection SQLException, url: " + DruidDataSource.sanitizedUrl(DruidDataSource.this.jdbcUrl), e);
                            ++this.errorCount;
                            if (this.errorCount <= DruidDataSource.this.connectionErrorRetryAttempts || DruidDataSource.this.timeBetweenConnectErrorMillis <= 0L) break block38;
                            DruidDataSource.this.setFailContinuous(true);
                            if (DruidDataSource.this.failFast) {
                                DruidDataSource.this.lock.lock();
                                try {
                                    DruidDataSource.this.notEmpty.signalAll();
                                }
                                finally {
                                    DruidDataSource.this.lock.unlock();
                                }
                            }
                            if (DruidDataSource.this.breakAfterAcquireFailure || DruidDataSource.this.closing || DruidDataSource.this.closed) {
                                DruidDataSource.this.lock.lock();
                                try {
                                    DruidDataSource.this.clearCreateTask(this.taskId);
                                }
                                finally {
                                    DruidDataSource.this.lock.unlock();
                                }
                                return;
                            }
                            this.errorCount = 0;
                            DruidDataSource.this.createSchedulerFutures.put(this, DruidDataSource.this.createScheduler.schedule(this, DruidDataSource.this.timeBetweenConnectErrorMillis, TimeUnit.MILLISECONDS));
                            return;
                        }
                        catch (RuntimeException e) {
                            LOG.error("create connection RuntimeException", e);
                            DruidDataSource.this.setFailContinuous(true);
                            continue;
                        }
                        catch (Error e) {
                            DruidDataSource.this.lock.lock();
                            try {
                                DruidDataSource.this.clearCreateTask(this.taskId);
                            }
                            finally {
                                DruidDataSource.this.lock.unlock();
                            }
                            LOG.error("create connection Error", e);
                            DruidDataSource.this.setFailContinuous(true);
                            break block44;
                        }
                        catch (Throwable e) {
                            DruidDataSource.this.lock.lock();
                            try {
                                DruidDataSource.this.clearCreateTask(this.taskId);
                            }
                            finally {
                                DruidDataSource.this.lock.unlock();
                            }
                            LOG.error("create connection unexpected error.", e);
                            break block44;
                        }
                    }
                    if (physicalConnection != null) break;
                }
                physicalConnection.createTaskId = this.taskId;
                boolean result = DruidDataSource.this.put(physicalConnection);
                if (result) break block44;
                JdbcUtils.close(physicalConnection.getPhysicalConnection());
                LOG.info("put physical connection to pool failed.");
            }
        }
    }

    public class LogStatsThread
    extends Thread {
        public LogStatsThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        DruidDataSource.this.logStats();
                    }
                    catch (Exception e) {
                        LOG.error("logStats error", e);
                    }
                    Thread.sleep(DruidDataSource.this.timeBetweenLogStatsMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

