/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.node;

import com.alibaba.druid.pool.ha.node.ZookeeperNodeInfo;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.nodes.GroupMember;
import org.apache.curator.retry.RetryForever;

public class ZookeeperNodeRegister {
    private static final Log LOG = LogFactory.getLog(ZookeeperNodeRegister.class);
    private String zkConnectString;
    private String path = "/ha-druid-datasources";
    private CuratorFramework client;
    private GroupMember member;
    private boolean privateZkClient = false;
    private Lock lock = new ReentrantLock();

    public void init() {
        if (this.client == null) {
            this.client = CuratorFrameworkFactory.builder().connectionTimeoutMs(5000).connectString(this.zkConnectString).retryPolicy((RetryPolicy)new RetryForever(10000)).sessionTimeoutMs(30000).build();
            this.client.start();
            this.privateZkClient = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(String nodeId, List<ZookeeperNodeInfo> payload) {
        if (payload == null || payload.isEmpty()) {
            return false;
        }
        try {
            this.lock.lock();
            this.createPathIfNotExisted();
            if (this.member != null) {
                LOG.warn("GroupMember has already registered. Please deregister first.");
                boolean bl = false;
                return bl;
            }
            String payloadString = this.getPropertiesString(payload);
            this.member = new GroupMember(this.client, this.path, nodeId, payloadString.getBytes());
            this.member.start();
            LOG.info("Register Node[" + nodeId + "] in path[" + this.path + "].");
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deregister() {
        if (this.member != null) {
            this.member.close();
            this.member = null;
        }
        if (this.client != null && this.privateZkClient) {
            this.client.close();
        }
    }

    public void destroy() {
        this.deregister();
    }

    private void createPathIfNotExisted() {
        try {
            if (this.client.checkExists().forPath(this.path) == null) {
                LOG.info("Path[" + this.path + "] is NOT existed, create it.");
                this.client.create().creatingParentsIfNeeded().forPath(this.path);
            }
        }
        catch (Exception e) {
            LOG.error("Can NOT check the path.", e);
        }
    }

    private String getPropertiesString(List<ZookeeperNodeInfo> payload) {
        Properties properties = new Properties();
        for (ZookeeperNodeInfo n : payload) {
            if (n.getHost() != null) {
                properties.setProperty(n.getPrefix() + "host", n.getHost());
            }
            if (n.getPort() != null) {
                properties.setProperty(n.getPrefix() + "port", n.getPort().toString());
            }
            if (n.getDatabase() != null) {
                properties.setProperty(n.getPrefix() + "database", n.getDatabase());
            }
            if (n.getUsername() != null) {
                properties.setProperty(n.getPrefix() + "username", n.getUsername());
            }
            if (n.getPassword() == null) continue;
            properties.setProperty(n.getPrefix() + "password", n.getPassword());
        }
        StringWriter sw = new StringWriter();
        try {
            properties.store(sw, "");
        }
        catch (IOException e) {
            LOG.error("Why Properties.store goes wrong?", e);
        }
        return sw.toString();
    }

    public void setClient(CuratorFramework client) {
        if (client != null) {
            this.client = client;
            this.privateZkClient = false;
        }
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public String getZkConnectString() {
        return this.zkConnectString;
    }

    public void setZkConnectString(String zkConnectString) {
        this.zkConnectString = zkConnectString;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

