/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.dubbo.config.spring.ReferenceBean;
import com.alibaba.dubbo.config.spring.beans.factory.annotation.ReferenceBeanBuilder;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ReferenceAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
ApplicationContextAware,
BeanClassLoaderAware,
DisposableBean {
    public static final String BEAN_NAME = "referenceAnnotationBeanPostProcessor";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ApplicationContext applicationContext;
    private ClassLoader classLoader;
    private final ConcurrentMap<String, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, InjectionMetadata>(256);
    private final ConcurrentMap<String, ReferenceBean<?>> referenceBeansCache = new ConcurrentHashMap();

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeanCreationException {
        InjectionMetadata metadata = this.findReferenceMetadata(beanName, bean.getClass(), pvs);
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeanCreationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of @Reference dependencies failed", ex);
        }
        return pvs;
    }

    private List<InjectionMetadata.InjectedElement> findFieldReferenceMetadata(Class<?> beanClass) {
        final LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                Reference reference = (Reference)AnnotationUtils.getAnnotation((AnnotatedElement)field, Reference.class);
                if (reference != null) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        if (ReferenceAnnotationBeanPostProcessor.this.logger.isWarnEnabled()) {
                            ReferenceAnnotationBeanPostProcessor.this.logger.warn((Object)("@Reference annotation is not supported on static fields: " + field));
                        }
                        return;
                    }
                    elements.add(new ReferenceFieldElement(field, reference));
                }
            }
        });
        return elements;
    }

    private List<InjectionMetadata.InjectedElement> findMethodReferenceMetadata(final Class<?> beanClass) {
        final LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair((Method)method, (Method)bridgedMethod)) {
                    return;
                }
                Reference reference = (Reference)AnnotationUtils.findAnnotation((Method)bridgedMethod, Reference.class);
                if (reference != null && method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)beanClass))) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        if (ReferenceAnnotationBeanPostProcessor.this.logger.isWarnEnabled()) {
                            ReferenceAnnotationBeanPostProcessor.this.logger.warn((Object)("@Reference annotation is not supported on static methods: " + method));
                        }
                        return;
                    }
                    if (method.getParameterTypes().length == 0 && ReferenceAnnotationBeanPostProcessor.this.logger.isWarnEnabled()) {
                        ReferenceAnnotationBeanPostProcessor.this.logger.warn((Object)("@Reference  annotation should only be used on methods with parameters: " + method));
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)bridgedMethod, (Class)beanClass);
                    elements.add(new ReferenceMethodElement(method, pd, reference));
                }
            }
        });
        return elements;
    }

    private InjectionMetadata buildReferenceMetadata(Class<?> beanClass) {
        LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
        elements.addAll(this.findFieldReferenceMetadata(beanClass));
        elements.addAll(this.findMethodReferenceMetadata(beanClass));
        return new InjectionMetadata(beanClass, elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findReferenceMetadata(String beanName, Class<?> clazz, PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength((String)beanName) ? beanName : clazz.getName();
        InjectionMetadata metadata = (InjectionMetadata)this.injectionMetadataCache.get(cacheKey);
        if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
            ConcurrentMap<String, InjectionMetadata> concurrentMap = this.injectionMetadataCache;
            synchronized (concurrentMap) {
                metadata = (InjectionMetadata)this.injectionMetadataCache.get(cacheKey);
                if (InjectionMetadata.needsRefresh((InjectionMetadata)metadata, clazz)) {
                    if (metadata != null) {
                        metadata.clear(pvs);
                    }
                    try {
                        metadata = this.buildReferenceMetadata(clazz);
                        this.injectionMetadataCache.put(cacheKey, metadata);
                    }
                    catch (NoClassDefFoundError err) {
                        throw new IllegalStateException("Failed to introspect bean class [" + clazz.getName() + "] for reference metadata: could not find class that it depends on", err);
                    }
                }
            }
        }
        return metadata;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (beanType != null) {
            InjectionMetadata metadata = this.findReferenceMetadata(beanName, beanType, null);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void destroy() throws Exception {
        for (ReferenceBean referenceBean : this.referenceBeansCache.values()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(referenceBean + " was destroying!"));
            }
            referenceBean.destroy();
        }
        this.injectionMetadataCache.clear();
        this.referenceBeansCache.clear();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(((Object)((Object)this)).getClass() + " was destroying!"));
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private Object buildReferenceBean(Reference reference, Class<?> referenceClass) throws Exception {
        String referenceBeanCacheKey = ReferenceAnnotationBeanPostProcessor.generateReferenceBeanCacheKey(reference, referenceClass);
        ReferenceBean referenceBean = (ReferenceBean)this.referenceBeansCache.get(referenceBeanCacheKey);
        if (referenceBean == null) {
            ReferenceBeanBuilder beanBuilder = (ReferenceBeanBuilder)ReferenceBeanBuilder.create(reference, this.classLoader, this.applicationContext).interfaceClass(referenceClass);
            referenceBean = (ReferenceBean)beanBuilder.build();
            this.referenceBeansCache.putIfAbsent(referenceBeanCacheKey, referenceBean);
        }
        return referenceBean.get();
    }

    private static String generateReferenceBeanCacheKey(Reference reference, Class<?> beanClass) {
        String interfaceName = ReferenceAnnotationBeanPostProcessor.resolveInterfaceName(reference, beanClass);
        String key = reference.group() + "/" + interfaceName + ":" + reference.version();
        return key;
    }

    private static String resolveInterfaceName(Reference reference, Class<?> beanClass) throws IllegalStateException {
        String interfaceName;
        if (!"".equals(reference.interfaceName())) {
            interfaceName = reference.interfaceName();
        } else if (!Void.TYPE.equals(reference.interfaceClass())) {
            interfaceName = reference.interfaceClass().getName();
        } else if (beanClass.isInterface()) {
            interfaceName = beanClass.getName();
        } else {
            throw new IllegalStateException("The @Reference undefined interfaceClass or interfaceName, and the property type " + beanClass.getName() + " is not a interface.");
        }
        return interfaceName;
    }

    private class ReferenceFieldElement
    extends InjectionMetadata.InjectedElement {
        private final Field field;
        private final Reference reference;

        protected ReferenceFieldElement(Field field, Reference reference) {
            super((Member)field, null);
            this.field = field;
            this.reference = reference;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Class<?> referenceClass = this.field.getType();
            Object referenceBean = ReferenceAnnotationBeanPostProcessor.this.buildReferenceBean(this.reference, referenceClass);
            ReflectionUtils.makeAccessible((Field)this.field);
            this.field.set(bean, referenceBean);
        }
    }

    private class ReferenceMethodElement
    extends InjectionMetadata.InjectedElement {
        private final Method method;
        private final Reference reference;

        protected ReferenceMethodElement(Method method, PropertyDescriptor pd, Reference reference) {
            super((Member)method, pd);
            this.method = method;
            this.reference = reference;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Class<?> referenceClass = this.pd.getPropertyType();
            Object referenceBean = ReferenceAnnotationBeanPostProcessor.this.buildReferenceBean(this.reference, referenceClass);
            ReflectionUtils.makeAccessible((Method)this.method);
            this.method.invoke(bean, referenceBean);
        }
    }
}

