/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.common.utils.Assert;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.validation.DataBinder;

public class DubboConfigBindingBeanPostProcessor
implements BeanPostProcessor {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String beanName;
    private final PropertyValues propertyValues;

    public DubboConfigBindingBeanPostProcessor(String beanName, PropertyValues propertyValues) {
        Assert.notNull((Object)beanName, "The name of bean must not be null");
        Assert.notNull((Object)propertyValues, "The PropertyValues of bean must not be null");
        this.beanName = beanName;
        this.propertyValues = propertyValues;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (beanName.equals(this.beanName)) {
            DataBinder dataBinder = new DataBinder(bean);
            dataBinder.setIgnoreInvalidFields(true);
            dataBinder.bind(this.propertyValues);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("The properties of bean [name : " + beanName + "] have been binding by values : " + Arrays.asList(this.propertyValues.getPropertyValues())));
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

