/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.qos.protocol;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.qos.server.Server;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Protocol;
import com.alibaba.dubbo.rpc.RpcException;
import java.util.concurrent.atomic.AtomicBoolean;

public class QosProtocolWrapper
implements Protocol {
    private static AtomicBoolean hasStarted = new AtomicBoolean(false);
    private Protocol protocol;

    public QosProtocolWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    @Override
    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    @Override
    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        if ("registry".equals(invoker.getUrl().getProtocol())) {
            this.startQosServer(invoker.getUrl());
            return this.protocol.export(invoker);
        }
        return this.protocol.export(invoker);
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        if ("registry".equals(url.getProtocol())) {
            this.startQosServer(url);
            return this.protocol.refer(type, url);
        }
        return this.protocol.refer(type, url);
    }

    @Override
    public void destroy() {
        this.protocol.destroy();
    }

    private void startQosServer(URL url) {
        if (!hasStarted.compareAndSet(false, true)) {
            return;
        }
        try {
            boolean qosEnable = Boolean.parseBoolean(url.getParameter("qos.enable", "true"));
            if (!qosEnable) {
                return;
            }
            int port = Integer.parseInt(url.getParameter("qos.port", "22222"));
            boolean acceptForeignIp = Boolean.parseBoolean(url.getParameter("qos.accept.foreign.ip", "true"));
            Server server = Server.getInstance();
            server.setPort(port);
            server.setAcceptForeignIp(acceptForeignIp);
            server.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

