/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring;

import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ModuleConfig;
import com.alibaba.dubbo.config.MonitorConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.ServiceConfig;
import com.alibaba.dubbo.config.annotation.Service;
import com.alibaba.dubbo.config.spring.context.event.ServiceBeanExportedEvent;
import com.alibaba.dubbo.config.spring.extension.SpringExtensionFactory;
import com.alibaba.dubbo.config.spring.util.BeanFactoryUtils;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class ServiceBean<T>
extends ServiceConfig<T>
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent>,
BeanNameAware,
ApplicationEventPublisherAware {
    private static final long serialVersionUID = 213195494150089726L;
    private final transient Service service;
    private transient ApplicationContext applicationContext;
    private transient String beanName;
    private transient boolean supportedApplicationListener;
    private ApplicationEventPublisher applicationEventPublisher;

    public ServiceBean() {
        this.service = null;
    }

    public ServiceBean(Service service) {
        super(service);
        this.service = service;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        SpringExtensionFactory.addApplicationContext(applicationContext);
        this.supportedApplicationListener = BeanFactoryUtils.addApplicationListener(applicationContext, this);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public Service getService() {
        return this.service;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.isDelay() && !this.isExported() && !this.isUnexported()) {
            if (logger.isInfoEnabled()) {
                logger.info("The service ready on spring started. service: " + this.getInterface());
            }
            this.export();
        }
    }

    private boolean isDelay() {
        Integer delay = this.getDelay();
        ProviderConfig provider = this.getProvider();
        if (delay == null && provider != null) {
            delay = provider.getDelay();
        }
        return this.supportedApplicationListener && (delay == null || delay == -1);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getProvider() == null) {
            Map providerConfigMap;
            Map map = providerConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ProviderConfig.class, (boolean)false, (boolean)false);
            if (providerConfigMap != null && providerConfigMap.size() > 0) {
                Map protocolConfigMap;
                Map map2 = protocolConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ProtocolConfig.class, (boolean)false, (boolean)false);
                if ((protocolConfigMap == null || protocolConfigMap.size() == 0) && providerConfigMap.size() > 1) {
                    ArrayList<ProviderConfig> providerConfigs = new ArrayList<ProviderConfig>();
                    for (ProviderConfig config : providerConfigMap.values()) {
                        if (config.isDefault() == null || !config.isDefault().booleanValue()) continue;
                        providerConfigs.add(config);
                    }
                    if (!providerConfigs.isEmpty()) {
                        this.setProviders(providerConfigs);
                    }
                } else {
                    ProviderConfig providerConfig = null;
                    for (ProviderConfig config : providerConfigMap.values()) {
                        if (config.isDefault() != null && !config.isDefault().booleanValue()) continue;
                        if (providerConfig != null) {
                            throw new IllegalStateException("Duplicate provider configs: " + providerConfig + " and " + config);
                        }
                        providerConfig = config;
                    }
                    if (providerConfig != null) {
                        this.setProvider(providerConfig);
                    }
                }
            }
        }
        if (this.getApplication() == null && (this.getProvider() == null || this.getProvider().getApplication() == null)) {
            Map applicationConfigMap;
            Map map = applicationConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ApplicationConfig.class, (boolean)false, (boolean)false);
            if (applicationConfigMap != null && applicationConfigMap.size() > 0) {
                AbstractConfig applicationConfig = null;
                for (AbstractConfig config : applicationConfigMap.values()) {
                    if (((ApplicationConfig)config).isDefault() != null && !((ApplicationConfig)config).isDefault().booleanValue()) continue;
                    if (applicationConfig != null) {
                        throw new IllegalStateException("Duplicate application configs: " + applicationConfig + " and " + config);
                    }
                    applicationConfig = config;
                }
                if (applicationConfig != null) {
                    this.setApplication((ApplicationConfig)applicationConfig);
                }
            }
        }
        if (this.getModule() == null && (this.getProvider() == null || this.getProvider().getModule() == null)) {
            Map moduleConfigMap;
            Map map = moduleConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ModuleConfig.class, (boolean)false, (boolean)false);
            if (moduleConfigMap != null && moduleConfigMap.size() > 0) {
                AbstractConfig moduleConfig = null;
                for (AbstractConfig config : moduleConfigMap.values()) {
                    if (((ModuleConfig)config).isDefault() != null && !((ModuleConfig)config).isDefault().booleanValue()) continue;
                    if (moduleConfig != null) {
                        throw new IllegalStateException("Duplicate module configs: " + moduleConfig + " and " + config);
                    }
                    moduleConfig = config;
                }
                if (moduleConfig != null) {
                    this.setModule((ModuleConfig)moduleConfig);
                }
            }
        }
        if (!(this.getRegistries() != null && !this.getRegistries().isEmpty() || this.getProvider() != null && this.getProvider().getRegistries() != null && !this.getProvider().getRegistries().isEmpty() || this.getApplication() != null && this.getApplication().getRegistries() != null && !this.getApplication().getRegistries().isEmpty())) {
            Map registryConfigMap;
            Map map = registryConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, RegistryConfig.class, (boolean)false, (boolean)false);
            if (registryConfigMap != null && registryConfigMap.size() > 0) {
                ArrayList<AbstractConfig> registryConfigs = new ArrayList<AbstractConfig>();
                for (AbstractConfig config : registryConfigMap.values()) {
                    if (((RegistryConfig)config).isDefault() != null && !((RegistryConfig)config).isDefault().booleanValue()) continue;
                    registryConfigs.add(config);
                }
                if (registryConfigs != null && !registryConfigs.isEmpty()) {
                    super.setRegistries(registryConfigs);
                }
            }
        }
        if (!(this.getMonitor() != null || this.getProvider() != null && this.getProvider().getMonitor() != null || this.getApplication() != null && this.getApplication().getMonitor() != null)) {
            Map monitorConfigMap;
            Map map = monitorConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MonitorConfig.class, (boolean)false, (boolean)false);
            if (monitorConfigMap != null && monitorConfigMap.size() > 0) {
                AbstractConfig monitorConfig = null;
                for (AbstractConfig config : monitorConfigMap.values()) {
                    if (((MonitorConfig)config).isDefault() != null && !((MonitorConfig)config).isDefault().booleanValue()) continue;
                    if (monitorConfig != null) {
                        throw new IllegalStateException("Duplicate monitor configs: " + monitorConfig + " and " + config);
                    }
                    monitorConfig = config;
                }
                if (monitorConfig != null) {
                    this.setMonitor((MonitorConfig)monitorConfig);
                }
            }
        }
        if ((this.getProtocols() == null || this.getProtocols().isEmpty()) && (this.getProvider() == null || this.getProvider().getProtocols() == null || this.getProvider().getProtocols().isEmpty())) {
            Map protocolConfigMap;
            Map map = protocolConfigMap = this.applicationContext == null ? null : org.springframework.beans.factory.BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ProtocolConfig.class, (boolean)false, (boolean)false);
            if (protocolConfigMap != null && protocolConfigMap.size() > 0) {
                ArrayList<AbstractConfig> protocolConfigs = new ArrayList<AbstractConfig>();
                for (AbstractConfig config : protocolConfigMap.values()) {
                    if (((ProtocolConfig)config).isDefault() != null && !((ProtocolConfig)config).isDefault().booleanValue()) continue;
                    protocolConfigs.add(config);
                }
                if (protocolConfigs != null && !protocolConfigs.isEmpty()) {
                    super.setProtocols(protocolConfigs);
                }
            }
        }
        if ((this.getPath() == null || this.getPath().length() == 0) && this.beanName != null && this.beanName.length() > 0 && this.getInterface() != null && this.getInterface().length() > 0 && this.beanName.startsWith(this.getInterface())) {
            this.setPath(this.beanName);
        }
        if (!this.isDelay()) {
            this.export();
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void export() {
        super.export();
        this.publishExportEvent();
    }

    private void publishExportEvent() {
        ServiceBeanExportedEvent exportEvent = new ServiceBeanExportedEvent(this);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)exportEvent);
    }

    public void destroy() throws Exception {
    }

    @Override
    protected Class getServiceClass(T ref) {
        if (AopUtils.isAopProxy(ref)) {
            return AopUtils.getTargetClass(ref);
        }
        return super.getServiceClass(ref);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

