/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.support;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.utils.ConfigUtils;
import com.alibaba.dubbo.common.utils.PojoUtils;
import com.alibaba.dubbo.common.utils.ReflectUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.ProxyFactory;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.support.RpcUtils;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MockInvoker<T>
implements Invoker<T> {
    private static final ProxyFactory proxyFactory = ExtensionLoader.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    private static final Map<String, Invoker<?>> mocks = new ConcurrentHashMap();
    private static final Map<String, Throwable> throwables = new ConcurrentHashMap<String, Throwable>();
    private final URL url;

    public MockInvoker(URL url) {
        this.url = url;
    }

    public static Object parseMockValue(String mock) throws Exception {
        return MockInvoker.parseMockValue(mock, null);
    }

    public static Object parseMockValue(String mock, Type[] returnTypes) throws Exception {
        Object value = null;
        value = "empty".equals(mock) ? ReflectUtils.getEmptyObject(returnTypes != null && returnTypes.length > 0 ? (Class)returnTypes[0] : null) : ("null".equals(mock) ? null : ("true".equals(mock) ? Boolean.valueOf(true) : ("false".equals(mock) ? Boolean.valueOf(false) : (mock.length() >= 2 && (mock.startsWith("\"") && mock.endsWith("\"") || mock.startsWith("'") && mock.endsWith("'")) ? mock.subSequence(1, mock.length() - 1) : (returnTypes != null && returnTypes.length > 0 && returnTypes[0] == String.class ? mock : (StringUtils.isNumeric(mock) ? JSON.parse((String)mock) : (mock.startsWith("{") ? JSON.parseObject((String)mock, Map.class) : (mock.startsWith("[") ? JSON.parseObject((String)mock, List.class) : mock))))))));
        if (returnTypes != null && returnTypes.length > 0) {
            value = PojoUtils.realize(value, (Class)returnTypes[0], returnTypes.length > 1 ? returnTypes[1] : null);
        }
        return value;
    }

    @Override
    public Result invoke(Invocation invocation) throws RpcException {
        String mock = this.getUrl().getParameter(invocation.getMethodName() + "." + "mock");
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setInvoker(this);
        }
        if (StringUtils.isBlank(mock)) {
            mock = this.getUrl().getParameter("mock");
        }
        if (StringUtils.isBlank(mock)) {
            throw new RpcException(new IllegalAccessException("mock can not be null. url :" + this.url));
        }
        if ((mock = MockInvoker.normalizeMock(URL.decode(mock))).startsWith("return ")) {
            mock = mock.substring("return ".length()).trim();
            try {
                Type[] returnTypes = RpcUtils.getReturnTypes(invocation);
                Object value = MockInvoker.parseMockValue(mock, returnTypes);
                return new RpcResult(value);
            }
            catch (Exception ew) {
                throw new RpcException("mock return invoke error. method :" + invocation.getMethodName() + ", mock:" + mock + ", url: " + this.url, (Throwable)ew);
            }
        }
        if (mock.startsWith("throw")) {
            if (StringUtils.isBlank(mock = mock.substring("throw".length()).trim())) {
                throw new RpcException("mocked exception for service degradation.");
            }
            Throwable t = MockInvoker.getThrowable(mock);
            throw new RpcException(3, t);
        }
        try {
            Invoker<T> invoker = this.getInvoker(mock);
            return invoker.invoke(invocation);
        }
        catch (Throwable t) {
            throw new RpcException("Failed to create mock implementation class " + mock, t);
        }
    }

    public static Throwable getThrowable(String throwstr) {
        Throwable throwable = throwables.get(throwstr);
        if (throwable != null) {
            return throwable;
        }
        try {
            Class<?> bizException = ReflectUtils.forName(throwstr);
            Constructor<?> constructor = ReflectUtils.findConstructor(bizException, String.class);
            Throwable t = (Throwable)constructor.newInstance("mocked exception for service degradation.");
            if (throwables.size() < 1000) {
                throwables.put(throwstr, t);
            }
            return t;
        }
        catch (Exception e) {
            throw new RpcException("mock throw error :" + throwstr + " argument error.", (Throwable)e);
        }
    }

    private Invoker<T> getInvoker(String mock) {
        Class<?> serviceType = ReflectUtils.forName(this.url.getServiceInterface());
        String mockService = ConfigUtils.isDefault(mock) ? serviceType.getName() + "Mock" : mock;
        Invoker<Object> invoker = mocks.get(mockService);
        if (invoker != null) {
            return invoker;
        }
        Object mockObject = MockInvoker.getMockObject(mock, serviceType);
        invoker = proxyFactory.getInvoker(mockObject, serviceType, this.url);
        if (mocks.size() < 10000) {
            mocks.put(mockService, invoker);
        }
        return invoker;
    }

    public static Object getMockObject(String mockService, Class serviceType) {
        Class<?> mockClass;
        if (ConfigUtils.isDefault(mockService)) {
            mockService = serviceType.getName() + "Mock";
        }
        if (!serviceType.isAssignableFrom(mockClass = ReflectUtils.forName(mockService))) {
            throw new IllegalStateException("The mock class " + mockClass.getName() + " not implement interface " + serviceType.getName());
        }
        try {
            return mockClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("No default constructor from mock class " + mockClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String normalizeMock(String mock) {
        if (mock == null) {
            return mock;
        }
        if ((mock = mock.trim()).length() == 0) {
            return mock;
        }
        if ("return".equalsIgnoreCase(mock)) {
            return "return null";
        }
        if (ConfigUtils.isDefault(mock) || "fail".equalsIgnoreCase(mock) || "force".equalsIgnoreCase(mock)) {
            return "default";
        }
        if (mock.startsWith("fail:")) {
            mock = mock.substring("fail:".length()).trim();
        }
        if (mock.startsWith("force:")) {
            mock = mock.substring("force:".length()).trim();
        }
        if (mock.startsWith("return ") || mock.startsWith("throw")) {
            mock = mock.replace('`', '\"');
        }
        return mock;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<T> getInterface() {
        return null;
    }
}

