/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.dubbo.common.utils.Assert;
import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.spring.context.config.DubboConfigBeanCustomizer;
import com.alibaba.dubbo.config.spring.context.properties.DefaultDubboConfigBinder;
import com.alibaba.dubbo.config.spring.context.properties.DubboConfigBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;

public class DubboConfigBindingBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
InitializingBean {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String prefix;
    private final String beanName;
    private DubboConfigBinder dubboConfigBinder;
    private ApplicationContext applicationContext;
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields = true;
    private List<DubboConfigBeanCustomizer> configBeanCustomizers = Collections.emptyList();

    public DubboConfigBindingBeanPostProcessor(String prefix, String beanName) {
        Assert.notNull((Object)prefix, "The prefix of Configuration Properties must not be null");
        Assert.notNull((Object)beanName, "The name of bean must not be null");
        this.prefix = prefix;
        this.beanName = beanName;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (beanName.equals(this.beanName) && bean instanceof AbstractConfig) {
            AbstractConfig dubboConfig = (AbstractConfig)bean;
            this.bind(this.prefix, dubboConfig);
            this.customize(beanName, dubboConfig);
        }
        return bean;
    }

    private void bind(String prefix, AbstractConfig dubboConfig) {
        this.dubboConfigBinder.bind(prefix, dubboConfig);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("The properties of bean [name : " + this.beanName + "] have been binding by prefix of configuration properties : " + prefix));
        }
    }

    private void customize(String beanName, AbstractConfig dubboConfig) {
        for (DubboConfigBeanCustomizer customizer : this.configBeanCustomizers) {
            customizer.customize(beanName, dubboConfig);
        }
    }

    public boolean isIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public boolean isIgnoreInvalidFields() {
        return this.ignoreInvalidFields;
    }

    public void setIgnoreInvalidFields(boolean ignoreInvalidFields) {
        this.ignoreInvalidFields = ignoreInvalidFields;
    }

    public DubboConfigBinder getDubboConfigBinder() {
        return this.dubboConfigBinder;
    }

    public void setDubboConfigBinder(DubboConfigBinder dubboConfigBinder) {
        this.dubboConfigBinder = dubboConfigBinder;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.initDubboConfigBinder();
        this.initConfigBeanCustomizers();
    }

    private void initDubboConfigBinder() {
        if (this.dubboConfigBinder == null) {
            try {
                this.dubboConfigBinder = (DubboConfigBinder)this.applicationContext.getBean(DubboConfigBinder.class);
            }
            catch (BeansException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"DubboConfigBinder Bean can't be found in ApplicationContext.");
                }
                this.dubboConfigBinder = this.createDubboConfigBinder(this.applicationContext.getEnvironment());
            }
        }
        this.dubboConfigBinder.setIgnoreUnknownFields(this.ignoreUnknownFields);
        this.dubboConfigBinder.setIgnoreInvalidFields(this.ignoreInvalidFields);
    }

    private void initConfigBeanCustomizers() {
        Collection configBeanCustomizers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, DubboConfigBeanCustomizer.class).values();
        this.configBeanCustomizers = new ArrayList(configBeanCustomizers);
        AnnotationAwareOrderComparator.sort(this.configBeanCustomizers);
    }

    protected DubboConfigBinder createDubboConfigBinder(Environment environment) {
        DefaultDubboConfigBinder defaultDubboConfigBinder = new DefaultDubboConfigBinder();
        defaultDubboConfigBinder.setEnvironment(environment);
        return defaultDubboConfigBinder;
    }
}

