/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.config.spring.context.config;

import com.alibaba.dubbo.config.AbstractConfig;
import com.alibaba.dubbo.config.spring.context.config.DubboConfigBeanCustomizer;
import com.alibaba.dubbo.config.spring.util.ObjectUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

public class NamePropertyDefaultValueDubboConfigBeanCustomizer
implements DubboConfigBeanCustomizer {
    private static final String PROPERTY_NAME = "name";

    @Override
    public void customize(String beanName, AbstractConfig dubboConfigBean) {
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(dubboConfigBean.getClass(), (String)PROPERTY_NAME);
        if (propertyDescriptor != null) {
            Method getNameMethod = propertyDescriptor.getReadMethod();
            if (getNameMethod == null) {
                return;
            }
            Object propertyValue = ReflectionUtils.invokeMethod((Method)getNameMethod, (Object)dubboConfigBean);
            if (propertyValue != null) {
                return;
            }
            Method setNameMethod = propertyDescriptor.getWriteMethod();
            if (setNameMethod != null && getNameMethod != null && Arrays.equals(ObjectUtils.of(String.class), setNameMethod.getParameterTypes())) {
                ReflectionUtils.invokeMethod((Method)setNameMethod, (Object)dubboConfigBean, (Object[])new Object[]{beanName});
            }
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

