/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.format.DataFormatter;
import java.math.BigDecimal;

public class NumberDataFormatterUtils {
    private static final ThreadLocal<DataFormatter> DATA_FORMATTER_THREAD_LOCAL = new ThreadLocal();

    public static String format(BigDecimal data, Integer dataFormat, String dataFormatString, GlobalConfiguration globalConfiguration) {
        DataFormatter dataFormatter = DATA_FORMATTER_THREAD_LOCAL.get();
        if (dataFormatter == null) {
            dataFormatter = new DataFormatter(globalConfiguration);
            DATA_FORMATTER_THREAD_LOCAL.set(dataFormatter);
        }
        return dataFormatter.format(data, dataFormat, dataFormatString);
    }

    public static void removeThreadLocalCache() {
        DATA_FORMATTER_THREAD_LOCAL.remove();
    }
}

