/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.support;

import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelCommonException;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import com.alibaba.excel.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.FileMagic;

public enum ExcelTypeEnum {
    XLS(".xls"),
    XLSX(".xlsx");

    private String value;

    private ExcelTypeEnum(String value) {
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExcelTypeEnum valueOf(ReadWorkbook readWorkbook) {
        ExcelTypeEnum excelType = readWorkbook.getExcelType();
        if (excelType != null) {
            return excelType;
        }
        File file = readWorkbook.getFile();
        InputStream inputStream = readWorkbook.getInputStream();
        if (file == null && inputStream == null) {
            throw new ExcelAnalysisException("File and inputStream must be a non-null.");
        }
        try {
            if (file != null) {
                if (!file.exists()) {
                    throw new ExcelAnalysisException("File " + file.getAbsolutePath() + " not exists.");
                }
                if (!StringUtils.isEmpty(readWorkbook.getPassword())) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    try {
                        ExcelTypeEnum excelTypeEnum = ExcelTypeEnum.recognitionExcelType(bufferedInputStream);
                        return excelTypeEnum;
                    }
                    finally {
                        bufferedInputStream.close();
                    }
                }
                String fileName = file.getName();
                if (fileName.endsWith(XLSX.getValue())) {
                    return XLSX;
                }
                if (fileName.endsWith(XLS.getValue())) {
                    return XLS;
                }
                if (StringUtils.isEmpty(readWorkbook.getPassword())) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    try {
                        ExcelTypeEnum excelTypeEnum = ExcelTypeEnum.recognitionExcelType(bufferedInputStream);
                        return excelTypeEnum;
                    }
                    finally {
                        bufferedInputStream.close();
                    }
                }
            }
            if (inputStream.markSupported()) return ExcelTypeEnum.recognitionExcelType(inputStream);
            inputStream = new BufferedInputStream(inputStream);
            readWorkbook.setInputStream(inputStream);
            return ExcelTypeEnum.recognitionExcelType(inputStream);
        }
        catch (ExcelCommonException e) {
            throw e;
        }
        catch (ExcelAnalysisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExcelCommonException("Convert excel format exception.You can try specifying the 'excelType' yourself", e);
        }
    }

    private static ExcelTypeEnum recognitionExcelType(InputStream inputStream) throws Exception {
        FileMagic fileMagic = FileMagic.valueOf((InputStream)inputStream);
        if (FileMagic.OLE2.equals((Object)fileMagic)) {
            return XLS;
        }
        if (FileMagic.OOXML.equals((Object)fileMagic)) {
            return XLSX;
        }
        throw new ExcelCommonException("Convert excel format exception.You can try specifying the 'excelType' yourself");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

