/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.edas.dubbo;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.AliCloudSdk;
import com.alibaba.cloud.context.AliCloudServerMode;
import com.alibaba.cloud.context.SimpleAliCloudConfiguration;
import com.alibaba.cloud.context.acm.AcmConfiguration;
import com.alibaba.cloud.context.acm.AliCloudAcmInitializer;
import com.alibaba.cloud.context.acm.SimpleAcmConfiguration;
import com.alibaba.cloud.context.cs.AliCloudCsInitializer;
import com.alibaba.cloud.context.cs.CsConfiguration;
import com.alibaba.cloud.context.cs.CsHandledConfiguration;
import com.alibaba.cloud.context.cs.SimpleCsConfiguration;
import com.alibaba.cloud.context.cs.SimpleCsHandledConfiguration;
import com.alibaba.cloud.context.edas.AliCloudEdasSdk;
import com.alibaba.cloud.context.edas.EdasConfiguration;
import com.alibaba.cloud.context.edas.SimpleEdasConfiguration;
import com.alibaba.cloud.context.statistics.StatisticsTask;
import com.alibaba.edas.dubbo.EdasRegistry;
import com.aliyuncs.edas.model.v20170801.GetSecureTokenResponse;
import com.taobao.config.client.ConfigClientPerfCtrl;
import java.io.File;
import java.util.Arrays;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.support.AbstractRegistryFactory;

public class EdasRegistryFactory
extends AbstractRegistryFactory {
    private static final int MAX_LENGTH = Integer.getInteger("edas.configClient.content.maxLength", 4096);

    protected Registry createRegistry(URL url) {
        AliCloudConfiguration cloudConfiguration = this.getAliCloudConfiguration(url);
        EdasConfiguration edasConfiguration = this.getEdasConfiguration(url);
        CsConfiguration csConfiguration = this.getCsConfiguration(url);
        CsHandledConfiguration csHandledConfiguration = AliCloudCsInitializer.handleCsConfiguration((AliCloudConfiguration)cloudConfiguration, (EdasConfiguration)edasConfiguration, (CsConfiguration)csConfiguration);
        AcmConfiguration acmConfiguration = this.getAcmConfiguration(url, cloudConfiguration, edasConfiguration);
        AliCloudAcmInitializer.initialize((AliCloudConfiguration)cloudConfiguration, (EdasConfiguration)edasConfiguration, (AcmConfiguration)acmConfiguration);
        ConfigClientPerfCtrl.setDataIdLengthMax((int)MAX_LENGTH);
        ConfigClientPerfCtrl.setDataContentLengthMax((int)MAX_LENGTH);
        if (csHandledConfiguration.getServerMode() == AliCloudServerMode.LOCAL) {
            ((SimpleCsHandledConfiguration)csHandledConfiguration).setProjectName(EdasRegistryFactory.resolveAppName(url));
        }
        StatisticsTask statisticsTask = new StatisticsTask(cloudConfiguration, edasConfiguration, Arrays.asList("DUBBO-RPC"));
        statisticsTask.start();
        return new EdasRegistry(url, csHandledConfiguration);
    }

    private CsConfiguration getCsConfiguration(URL url) {
        SimpleCsConfiguration csConfiguration = new SimpleCsConfiguration();
        if (StringUtils.isEmpty((String)url.getParameter("endpoint"))) {
            csConfiguration.setServerList(url.getHost());
        }
        return csConfiguration;
    }

    private AliCloudConfiguration getAliCloudConfiguration(URL url) {
        String alicloudAccessKey = System.getProperty("alicloud.accessKey");
        String alicloudSecretKey = System.getProperty("alicloud.secretKey");
        if (StringUtils.isEmpty((String)alicloudAccessKey)) {
            alicloudAccessKey = url.getParameter("alicloud.accessKey");
        }
        if (StringUtils.isEmpty((String)alicloudSecretKey)) {
            alicloudSecretKey = url.getParameter("alicloud.secretKey");
        }
        SimpleAliCloudConfiguration cloudConfiguration = new SimpleAliCloudConfiguration();
        cloudConfiguration.setAccessKey(alicloudAccessKey);
        cloudConfiguration.setSecretKey(alicloudSecretKey);
        return cloudConfiguration;
    }

    private EdasConfiguration getEdasConfiguration(URL url) {
        String applicationName = EdasRegistryFactory.resolveAppName(url);
        String edasEnabledStr = System.getProperty("alicloud.edas.enabled");
        String edasNamespace = System.getProperty("alicloud.edas.namespace");
        if (StringUtils.isEmpty((String)edasEnabledStr)) {
            edasEnabledStr = url.getParameter("alicloud.edas.enabled");
        }
        if (StringUtils.isEmpty((String)edasNamespace)) {
            edasNamespace = url.getParameter("alicloud.edas.namespace");
        }
        SimpleEdasConfiguration edasConfiguration = new SimpleEdasConfiguration();
        edasConfiguration.setApplicationName(applicationName);
        edasConfiguration.setEnabled(Boolean.valueOf(edasEnabledStr).booleanValue());
        edasConfiguration.setNamespace(edasNamespace);
        return edasConfiguration;
    }

    private AcmConfiguration getAcmConfiguration(URL url, AliCloudConfiguration cloudConfiguration, EdasConfiguration edasConfiguration) {
        SimpleAcmConfiguration acmConfiguration = new SimpleAcmConfiguration();
        if (!edasConfiguration.isEnabled()) {
            if (StringUtils.isEmpty((String)url.getParameter("endpoint"))) {
                acmConfiguration.setServerList(url.getHost());
                acmConfiguration.setServerPort(url.getPort() + "");
            }
            return acmConfiguration;
        }
        AliCloudSdk aliCloudSdk = new AliCloudSdk(cloudConfiguration, edasConfiguration);
        AliCloudEdasSdk aliCloudEdasSdk = new AliCloudEdasSdk(aliCloudSdk);
        GetSecureTokenResponse.SecureToken secureToken = aliCloudEdasSdk.getSecureToken(edasConfiguration.getNamespace());
        secureToken.getAddressServerHost();
        acmConfiguration.setEndpoint(secureToken.getAddressServerHost());
        acmConfiguration.setNamespace(secureToken.getTenantId());
        return acmConfiguration;
    }

    public static String resolveAppName(URL url) {
        String app = System.getProperty("project.name");
        if (!StringUtils.isEmpty((String)app)) {
            return app;
        }
        if (!StringUtils.isEmpty((String)url.getParameter("application"))) {
            return url.getParameter("application");
        }
        String command = System.getProperty("sun.java.command");
        if (!StringUtils.isEmpty((String)command)) {
            String separator;
            if ((command = command.split("\\s")[0]).contains(separator = File.separator)) {
                String[] strs = "\\".equals(separator) ? command.split("\\\\") : command.split(separator);
                command = strs[strs.length - 1];
            }
            if (command.endsWith(".jar") || command.endsWith(".JAR")) {
                command = command.substring(0, command.length() - 4);
            }
            return command;
        }
        throw new RuntimeException("can't resolve project.name!");
    }

    public int getMaxDataContentLength() {
        return MAX_LENGTH;
    }
}

