/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.support.hsf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.support.hsf.MethodLocator;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class HSFJSONUtils {
    static final long HASH_ARGS_TYPES = Fnv.hashCode64((String)"argsTypes");
    static final long HASH_ARGS_OBJS = Fnv.hashCode64((String)"argsObjs");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object[] parseInvocationArguments(String json, MethodLocator methodLocator) {
        String[] typeNames;
        JSONReader jsonReader = JSONReader.of((String)json);
        Method method = null;
        if (jsonReader.nextIfMatch('{')) {
            String[] typeNames2;
            int i;
            long hash0 = jsonReader.readFieldNameHashCode();
            if (hash0 == HASH_ARGS_TYPES) {
                if (!jsonReader.nextIfMatch('[')) throw new JSONException("illegal format");
                String name0 = null;
                String name1 = null;
                ArrayList<String> nameList = null;
                i = 0;
                while (true) {
                    if (jsonReader.nextIfMatch(']')) break;
                    if (jsonReader.isEnd()) {
                        throw new JSONException("illegal format");
                    }
                    String name = jsonReader.readString();
                    if (i == 0) {
                        name0 = name;
                    } else if (i == 1) {
                        name1 = name;
                    } else if (i == 2) {
                        nameList = new ArrayList<String>();
                        nameList.add(name0);
                        nameList.add(name1);
                        nameList.add(name);
                    } else {
                        nameList.add(name);
                    }
                    ++i;
                }
                jsonReader.nextIfMatch(',');
                if (i == 0) {
                    typeNames2 = new String[]{};
                } else if (i == 1) {
                    typeNames2 = new String[]{name0};
                } else if (i == 2) {
                    typeNames2 = new String[]{name0, name1};
                } else {
                    typeNames2 = new String[nameList.size()];
                    nameList.toArray(typeNames2);
                }
                method = methodLocator.findMethod(typeNames2);
            }
            if (method != null) {
                Type[] argTypes = method.getGenericParameterTypes();
                long hash1 = jsonReader.readFieldNameHashCode();
                if (hash1 != HASH_ARGS_OBJS) throw new JSONException("illegal format");
                return jsonReader.readArray(argTypes);
            }
            JSONObject jsonObject = JSON.parseObject(json);
            typeNames2 = jsonObject.getObject("argsTypes", String[].class);
            method = methodLocator.findMethod(typeNames2);
            JSONArray argsObjs = jsonObject.getJSONArray("argsObjs");
            if (argsObjs == null) {
                return null;
            }
            Type[] argTypes = method.getGenericParameterTypes();
            Object[] values = new Object[argTypes.length];
            i = 0;
            while (i < argTypes.length) {
                Type type = argTypes[i];
                values[i] = argsObjs.getObject(i, type);
                ++i;
            }
            return values;
        }
        if (!jsonReader.nextIfMatch('[')) return null;
        if (!jsonReader.nextIfMatch('[')) throw new JSONException("illegal format");
        String name0 = null;
        String name1 = null;
        ArrayList<String> nameList = null;
        int i = 0;
        while (true) {
            if (jsonReader.nextIfMatch(']')) break;
            if (jsonReader.isEnd()) {
                throw new JSONException("illegal format");
            }
            String name = jsonReader.readString();
            if (i == 0) {
                name0 = name;
            } else if (i == 1) {
                name1 = name;
            } else if (i == 2) {
                nameList = new ArrayList<String>();
                nameList.add(name0);
                nameList.add(name1);
                nameList.add(name);
            } else {
                nameList.add(name);
            }
            ++i;
        }
        jsonReader.nextIfMatch(',');
        if (i == 0) {
            typeNames = new String[]{};
        } else if (i == 1) {
            typeNames = new String[]{name0};
        } else if (i == 2) {
            typeNames = new String[]{name0, name1};
        } else {
            typeNames = new String[nameList.size()];
            nameList.toArray(typeNames);
        }
        method = methodLocator.findMethod(typeNames);
        Type[] argTypes = method.getGenericParameterTypes();
        return jsonReader.readArray(argTypes);
    }
}

