/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.support.csv.CSVParserUTF16;
import com.alibaba.fastjson2.support.csv.CSVParserUTF8;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CSVParser
implements Closeable {
    static final int SIZE_256K = 262144;
    ObjectReaderProvider provider;
    long features;
    Type[] types;
    ObjectReader[] typeReaders;
    ObjectReaderAdapter objectReader;
    List<String> columns;
    Map<String, Type> schema;
    boolean quote;
    int lineSize;
    int rowCount;
    int lineStart;
    int lineEnd;
    int lineNextStart;
    int end;
    int off;
    boolean inputEnd;
    boolean lineTerminated;

    CSVParser() {
    }

    CSVParser(Map<String, Type> schema) {
        this.schema = schema;
    }

    CSVParser(ObjectReaderAdapter objectReader) {
        this.objectReader = objectReader;
    }

    public CSVParser(Type[] types) {
        this.types = types;
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader[] readers = new ObjectReader[types.length];
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            readers[i] = type == String.class || type == Object.class ? null : provider.getObjectReader(type);
        }
        this.typeReaders = readers;
    }

    public static CSVParser of(String str, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader((Type)objectClass);
        if (JDKUtils.JVM_VERSION > 8 && JDKUtils.UNSAFE_SUPPORT) {
            try {
                int coder;
                int n = coder = JDKUtils.STRING_CODER != null ? JDKUtils.STRING_CODER.applyAsInt(str) : UnsafeUtils.getStringCoder((String)str);
                if (coder == 0) {
                    byte[] bytes = JDKUtils.STRING_VALUE != null ? (byte[])JDKUtils.STRING_VALUE.apply(str) : UnsafeUtils.getStringValue((String)str);
                    return new CSVParserUTF8(bytes, 0, bytes.length, objectReader);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
        }
        char[] chars = JDKUtils.getCharArray((String)str);
        return new CSVParserUTF16(chars, 0, chars.length, objectReader);
    }

    public static CSVParser of(char[] chars, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader((Type)objectClass);
        return new CSVParserUTF16(chars, 0, chars.length, objectReader);
    }

    public static CSVParser of(byte[] utf8Bytes, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader((Type)objectClass);
        return new CSVParserUTF8(utf8Bytes, 0, utf8Bytes.length, objectReader);
    }

    public static CSVParser of(File file, Type ... types) throws IOException {
        return new CSVParserUTF8(new FileInputStream(file), StandardCharsets.UTF_8, types);
    }

    public static CSVParser of(File file, Charset charset, Type ... types) throws IOException {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVParserUTF16(new InputStreamReader((InputStream)new FileInputStream(file), charset), types);
        }
        return new CSVParserUTF8(new FileInputStream(file), charset, types);
    }

    public static CSVParser of(InputStream in, Type ... types) throws IOException {
        return new CSVParserUTF8(in, StandardCharsets.UTF_8, types);
    }

    public static CSVParser of(InputStream in, Charset charset, Type ... types) throws IOException {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new CSVParserUTF16(new InputStreamReader(in, charset), types);
        }
        return new CSVParserUTF8(in, charset, types);
    }

    public static CSVParser of(Reader in, Type ... types) throws IOException {
        return new CSVParserUTF16(in, types);
    }

    public static CSVParser of(File file, Map<String, Type> types) throws IOException {
        return new CSVParserUTF8(new FileInputStream(file), types);
    }

    public static CSVParser of(String str, Type ... types) {
        if (JDKUtils.JVM_VERSION > 8 && JDKUtils.UNSAFE_SUPPORT) {
            try {
                int coder;
                int n = coder = JDKUtils.STRING_CODER != null ? JDKUtils.STRING_CODER.applyAsInt(str) : UnsafeUtils.getStringCoder((String)str);
                if (coder == 0) {
                    byte[] bytes = JDKUtils.STRING_VALUE != null ? (byte[])JDKUtils.STRING_VALUE.apply(str) : UnsafeUtils.getStringValue((String)str);
                    return new CSVParserUTF8(bytes, 0, bytes.length, types);
                }
            }
            catch (Exception e) {
                throw new JSONException("unsafe get String.coder error");
            }
        }
        char[] chars = JDKUtils.getCharArray((String)str);
        return new CSVParserUTF16(chars, 0, chars.length, types);
    }

    public static CSVParser of(char[] chars, Type ... types) {
        return new CSVParserUTF16(chars, 0, chars.length, types);
    }

    public static CSVParser of(byte[] utf8Bytes, Type ... types) {
        return new CSVParserUTF8(utf8Bytes, 0, utf8Bytes.length, types);
    }

    abstract boolean seekLine() throws IOException;

    public List<String> readHeader() {
        String[] columns = (String[])this.readLineValues(true);
        if (this.objectReader != null) {
            JSONReader.Context context = JSONFactory.createReadContext((ObjectReaderProvider)this.provider, (JSONReader.Feature[])new JSONReader.Feature[0]);
            Type[] types = new Type[columns.length];
            ObjectReader[] typeReaders = new ObjectReader[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                FieldReader fieldReader = this.objectReader.getFieldReader(column);
                types[i] = fieldReader.fieldType;
                typeReaders[i] = fieldReader.getObjectReader(context);
            }
            this.types = types;
            this.typeReaders = typeReaders;
        }
        this.columns = Arrays.asList(columns);
        return this.columns;
    }

    public <T> T readLoneObject() {
        int i;
        if (this.objectReader == null) {
            throw new JSONException("unsupported operation");
        }
        if (this.types == null) {
            FieldReader[] fieldReaders = this.objectReader.getFieldReaders();
            Type[] types = new Type[fieldReaders.length];
            for (i = 0; i < fieldReaders.length; ++i) {
                types[i] = fieldReaders[i].fieldType;
            }
            this.types = types;
        }
        Object[] values = this.readLineValues(false);
        if (this.columns != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (i = 0; i < values.length; ++i) {
                if (i >= this.columns.size()) continue;
                String column = this.columns.get(i);
                map.put(column, values[i]);
            }
            return (T)this.objectReader.createInstance(map, new JSONReader.Feature[0]);
        }
        return (T)this.objectReader.createInstance(values == null ? Collections.emptyList() : Arrays.asList(values));
    }

    public final Object[] readLineValues() {
        return this.readLineValues(false);
    }

    protected abstract Object[] readLineValues(boolean var1);

    public final String[] readLine() {
        return (String[])this.readLineValues(true);
    }

    public static int rowCount(String str, Feature ... features) {
        CSVParserUTF8 state = new CSVParserUTF8(features);
        state.rowCount(str, str.length());
        return state.rowCount();
    }

    public static int rowCount(byte[] bytes, Feature ... features) {
        CSVParserUTF8 state = new CSVParserUTF8(features);
        state.rowCount(bytes, bytes.length);
        return state.rowCount();
    }

    public static int rowCount(char[] chars, Feature ... features) {
        CSVParserUTF16 state = new CSVParserUTF16(features);
        state.rowCount(chars, chars.length);
        return state.rowCount();
    }

    public static int rowCount(File file) throws IOException {
        if (!file.exists()) {
            return -1;
        }
        try (FileInputStream in = new FileInputStream(file);){
            int n = CSVParser.rowCount(in);
            return n;
        }
    }

    public static int rowCount(InputStream in) throws IOException {
        int cnt;
        byte[] bytes = new byte[262144];
        CSVParserUTF8 state = new CSVParserUTF8(new Feature[0]);
        while ((cnt = in.read(bytes)) != -1) {
            state.rowCount(bytes, cnt);
        }
        return state.rowCount();
    }

    public int rowCount() {
        return this.lineTerminated ? this.rowCount : this.rowCount + 1;
    }

    void rowCount(String bytes, int length) {
        for (int i = 0; i < length; ++i) {
            char next;
            int n;
            char ch = bytes.charAt(i);
            if (ch == '\"') {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i + 1;
                if (n >= length) break;
                next = bytes.charAt(n);
                if (next == '\"') {
                    ++i;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == '\n') {
                if (this.lineSize > 0 || (this.features & Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                    this.lineSize = 0;
                }
                this.lineTerminated = i + 1 == length;
                continue;
            }
            if (ch == '\r') {
                this.lineTerminated = true;
                if (this.lineSize > 0 || (this.features & Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                n = i + 1;
                if (n >= length) break;
                next = bytes.charAt(n);
                if (next == '\n') {
                    ++i;
                }
                this.lineTerminated = i + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    void rowCount(byte[] bytes, int length) {
        for (int i = 0; i < length; ++i) {
            byte next;
            int n;
            byte ch;
            if (i + 4 < length) {
                byte b0 = bytes[i];
                byte b1 = bytes[i + 1];
                byte b2 = bytes[i + 2];
                byte b3 = bytes[i + 3];
                if (b0 > 34 && b1 > 34 && b2 > 34 && b3 > 34) {
                    this.lineSize += 4;
                    i += 3;
                    continue;
                }
            }
            if ((ch = bytes[i]) == 34) {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == 34) {
                    ++i;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == 10) {
                if (this.lineSize > 0 || (this.features & Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                this.lineTerminated = i + 1 == length;
                continue;
            }
            if (ch == 13) {
                if (this.lineSize > 0 || (this.features & Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineTerminated = true;
                this.lineSize = 0;
                n = i + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == 10) {
                    ++i;
                }
                this.lineTerminated = i + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    void rowCount(char[] bytes, int length) {
        for (int i = 0; i < length; ++i) {
            char next;
            int n;
            char ch;
            if (i + 4 < length) {
                char b0 = bytes[i];
                char b1 = bytes[i + 1];
                char b2 = bytes[i + 2];
                char b3 = bytes[i + 3];
                if (b0 > '\"' && b1 > '\"' && b2 > '\"' && b3 > '\"') {
                    i += 3;
                    this.lineSize += 4;
                    continue;
                }
            }
            if ((ch = bytes[i]) == '\"') {
                ++this.lineSize;
                if (!this.quote) {
                    this.quote = true;
                    continue;
                }
                n = i + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == '\"') {
                    ++i;
                    continue;
                }
                this.quote = false;
                continue;
            }
            if (this.quote) {
                ++this.lineSize;
                continue;
            }
            if (ch == '\n') {
                if (this.lineSize > 0 || (this.features & Feature.IgnoreEmptyLine.mask) == 0L) {
                    ++this.rowCount;
                }
                this.lineSize = 0;
                this.lineTerminated = i + 1 == length;
                continue;
            }
            if (ch == '\r' || (this.features & Feature.IgnoreEmptyLine.mask) == 0L) {
                if (this.lineSize > 0) {
                    ++this.rowCount;
                }
                this.lineTerminated = true;
                this.lineSize = 0;
                n = i + 1;
                if (n >= length) break;
                next = bytes[n];
                if (next == '\n') {
                    ++i;
                }
                this.lineTerminated = i + 1 == length;
                continue;
            }
            ++this.lineSize;
        }
    }

    public static enum Feature {
        IgnoreEmptyLine(1L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }
}

