/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.classloading;

import com.alibaba.fluss.classloading.ComponentClassLoader;
import com.alibaba.fluss.utils.Preconditions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ComponentClassLoaderTest {
    private static final String NON_EXISTENT_CLASS_NAME = "foo.Bar";
    private static final Class<?> CLASS_TO_LOAD = Class.class;
    private static final Class<?> CLASS_RETURNED_BY_OWNER = ComponentClassLoaderTest.class;
    private static final String NON_EXISTENT_RESOURCE_NAME = "foo/Bar";
    private static String resourceToLoad;
    private static final URL RESOURCE_RETURNED_BY_OWNER;
    @TempDir
    private static Path tmp;

    ComponentClassLoaderTest() {
    }

    @BeforeAll
    public static void setup() {
        resourceToLoad = tmp.toString();
    }

    @Test
    void testComponentOnlyIsDefaultForClasses() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            TestUrlClassLoader owner = new TestUrlClassLoader(NON_EXISTENT_CLASS_NAME, CLASS_RETURNED_BY_OWNER);
            ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[0], (ClassLoader)owner, new String[0], new String[0], Collections.emptyMap());
            componentClassLoader.loadClass(NON_EXISTENT_CLASS_NAME);
        }).isInstanceOf(ClassNotFoundException.class);
    }

    @Test
    void testOwnerFirstClassFoundIgnoresComponent() throws Exception {
        TestUrlClassLoader owner = new TestUrlClassLoader(CLASS_TO_LOAD.getName(), CLASS_RETURNED_BY_OWNER);
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[0], (ClassLoader)owner, new String[]{CLASS_TO_LOAD.getName()}, new String[0], Collections.emptyMap());
        Class loadedClass = componentClassLoader.loadClass(CLASS_TO_LOAD.getName());
        Assertions.assertThat((Class)loadedClass).isSameAs(CLASS_RETURNED_BY_OWNER);
    }

    @Test
    void testOwnerFirstClassNotFoundFallsBackToComponent() throws Exception {
        TestUrlClassLoader owner = new TestUrlClassLoader();
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[0], (ClassLoader)owner, new String[]{CLASS_TO_LOAD.getName()}, new String[0], Collections.emptyMap());
        Class loadedClass = componentClassLoader.loadClass(CLASS_TO_LOAD.getName());
        Assertions.assertThat((Class)loadedClass).isSameAs(CLASS_TO_LOAD);
    }

    @Test
    void testComponentFirstClassFoundIgnoresOwner() throws Exception {
        TestUrlClassLoader owner = new TestUrlClassLoader(CLASS_TO_LOAD.getName(), CLASS_RETURNED_BY_OWNER);
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[0], (ClassLoader)owner, new String[0], new String[]{CLASS_TO_LOAD.getName()}, Collections.emptyMap());
        Class loadedClass = componentClassLoader.loadClass(CLASS_TO_LOAD.getName());
        Assertions.assertThat((Class)loadedClass).isSameAs(CLASS_TO_LOAD);
    }

    @Test
    void testComponentFirstClassNotFoundFallsBackToOwner() throws Exception {
        TestUrlClassLoader owner = new TestUrlClassLoader(NON_EXISTENT_CLASS_NAME, CLASS_RETURNED_BY_OWNER);
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[0], (ClassLoader)owner, new String[0], new String[]{NON_EXISTENT_CLASS_NAME}, Collections.emptyMap());
        Class loadedClass = componentClassLoader.loadClass(NON_EXISTENT_CLASS_NAME);
        Assertions.assertThat((Class)loadedClass).isSameAs(CLASS_RETURNED_BY_OWNER);
    }

    @Test
    void testComponentOnlyIsDefaultForResources() throws IOException {
        TestUrlClassLoader owner = new TestUrlClassLoader();
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[0], (ClassLoader)owner, new String[0], new String[0], Collections.emptyMap());
        Assertions.assertThat((URL)componentClassLoader.getResource(NON_EXISTENT_RESOURCE_NAME)).isNull();
        Assertions.assertThat((boolean)componentClassLoader.getResources(NON_EXISTENT_RESOURCE_NAME).hasMoreElements()).isFalse();
    }

    @Test
    void testOwnerFirstResourceFoundIgnoresComponent() {
        TestUrlClassLoader owner = new TestUrlClassLoader(resourceToLoad, RESOURCE_RETURNED_BY_OWNER);
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[0], (ClassLoader)owner, new String[]{resourceToLoad}, new String[0], Collections.emptyMap());
        URL loadedResource = componentClassLoader.getResource(resourceToLoad);
        Assertions.assertThat((URL)loadedResource).isSameAs((Object)RESOURCE_RETURNED_BY_OWNER);
    }

    @Test
    void testOwnerFirstResourceNotFoundFallsBackToComponent() throws Exception {
        TestUrlClassLoader owner = new TestUrlClassLoader();
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[]{tmp.getRoot().toUri().toURL()}, (ClassLoader)owner, new String[]{resourceToLoad}, new String[0], Collections.emptyMap());
        URL loadedResource = componentClassLoader.getResource(resourceToLoad);
        Assertions.assertThat((String)loadedResource.toString()).contains(new CharSequence[]{resourceToLoad});
    }

    @Test
    void testComponentFirstResourceFoundIgnoresOwner() throws Exception {
        TestUrlClassLoader owner = new TestUrlClassLoader(resourceToLoad, RESOURCE_RETURNED_BY_OWNER);
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[]{tmp.getRoot().toUri().toURL()}, (ClassLoader)owner, new String[0], new String[]{resourceToLoad}, Collections.emptyMap());
        URL loadedResource = componentClassLoader.getResource(resourceToLoad);
        Assertions.assertThat((String)loadedResource.toString()).contains(new CharSequence[]{resourceToLoad});
    }

    @Test
    void testComponentFirstResourceNotFoundFallsBackToOwner() {
        TestUrlClassLoader owner = new TestUrlClassLoader(NON_EXISTENT_RESOURCE_NAME, RESOURCE_RETURNED_BY_OWNER);
        ComponentClassLoader componentClassLoader = new ComponentClassLoader(new URL[0], (ClassLoader)owner, new String[0], new String[]{NON_EXISTENT_RESOURCE_NAME}, Collections.emptyMap());
        URL loadedResource = componentClassLoader.getResource(NON_EXISTENT_RESOURCE_NAME);
        Assertions.assertThat((URL)loadedResource).isSameAs((Object)RESOURCE_RETURNED_BY_OWNER);
    }

    private static URL createURL() {
        try {
            return Paths.get("", new String[0]).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        RESOURCE_RETURNED_BY_OWNER = ComponentClassLoaderTest.createURL();
    }

    private static class TestUrlClassLoader
    extends URLClassLoader {
        private final String nameToCheck;
        private final Class<?> classToReturn;
        private final URL resourceToReturn;

        public TestUrlClassLoader() {
            this((String)null, (Class<?>)null, (URL)null);
        }

        public TestUrlClassLoader(String resourceNameToCheck, URL resourceToReturn) {
            this((String)Preconditions.checkNotNull((Object)resourceNameToCheck), null, (URL)Preconditions.checkNotNull((Object)resourceToReturn));
        }

        public TestUrlClassLoader(String classNameToCheck, Class<?> classToReturn) {
            this((String)Preconditions.checkNotNull((Object)classNameToCheck), (Class)Preconditions.checkNotNull(classToReturn), null);
        }

        public TestUrlClassLoader(String classNameToCheck, Class<?> classToReturn, URL resourceToReturn) {
            super(new URL[0], (ClassLoader)null);
            this.nameToCheck = classNameToCheck;
            this.classToReturn = classToReturn;
            this.resourceToReturn = resourceToReturn;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.nameToCheck == null) {
                throw new ClassNotFoundException();
            }
            if (this.nameToCheck.equals(name)) {
                return this.classToReturn;
            }
            return super.loadClass(name);
        }

        @Override
        public URL getResource(String name) {
            if (this.nameToCheck == null) {
                return null;
            }
            if (this.nameToCheck.equals(name)) {
                return this.resourceToReturn;
            }
            return super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (this.nameToCheck != null && this.nameToCheck.equals(name)) {
                return new ComponentClassLoader.IteratorBackedEnumeration(Collections.singleton(this.resourceToReturn).iterator());
            }
            return super.getResources(name);
        }
    }
}

