/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.cluster;

import com.alibaba.fluss.cluster.BucketLocation;
import com.alibaba.fluss.cluster.ServerNode;
import com.alibaba.fluss.cluster.ServerType;
import com.alibaba.fluss.metadata.PhysicalTablePath;
import com.alibaba.fluss.metadata.TablePath;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BucketLocationTest {
    @Test
    void testToString() {
        TablePath tablePath = new TablePath("test_db", "test_table");
        int bucketId = 0;
        long tableId = 150001L;
        ServerNode leader = new ServerNode(0, "localhost", 9092, ServerType.TABLET_SERVER);
        ServerNode replica1 = new ServerNode(1, "localhost", 9093, ServerType.TABLET_SERVER);
        ServerNode replica2 = new ServerNode(2, "localhost", 9094, ServerType.TABLET_SERVER);
        ServerNode[] replicas = new ServerNode[]{leader, replica1, replica2};
        BucketLocation bucketLocation = new BucketLocation(PhysicalTablePath.of((TablePath)tablePath), tableId, bucketId, leader, replicas);
        Assertions.assertThat((Object[])bucketLocation.getReplicas()).isEqualTo((Object)replicas);
        Assertions.assertThat((String)bucketLocation.toString()).isEqualTo("Bucket(physicalTablePath = test_db.test_table, TableBucket{tableId=150001, bucket=0}, leader = 0, replicas = [0,1,2])");
        bucketLocation = new BucketLocation(PhysicalTablePath.of((TablePath)tablePath), tableId, bucketId, null, replicas);
        Assertions.assertThat((String)bucketLocation.toString()).isEqualTo("Bucket(physicalTablePath = test_db.test_table, TableBucket{tableId=150001, bucket=0}, leader = none, replicas = [0,1,2])");
    }
}

