/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.cluster;

import com.alibaba.fluss.cluster.BucketLocation;
import com.alibaba.fluss.cluster.Cluster;
import com.alibaba.fluss.cluster.ServerNode;
import com.alibaba.fluss.cluster.ServerType;
import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.metadata.PhysicalTablePath;
import com.alibaba.fluss.metadata.SchemaInfo;
import com.alibaba.fluss.metadata.TableInfo;
import com.alibaba.fluss.metadata.TablePath;
import com.alibaba.fluss.record.TestData;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ClusterTest {
    private static final ServerNode COORDINATOR_SERVER = new ServerNode(-1, "localhost", 98, ServerType.COORDINATOR);
    private static final ServerNode[] NODES = new ServerNode[]{new ServerNode(0, "localhost", 99, ServerType.TABLET_SERVER), new ServerNode(1, "localhost", 100, ServerType.TABLET_SERVER), new ServerNode(2, "localhost", 101, ServerType.TABLET_SERVER), new ServerNode(11, "localhost", 102, ServerType.TABLET_SERVER)};
    private Configuration conf;
    private Map<Integer, ServerNode> aliveTabletServersById;

    ClusterTest() {
    }

    @BeforeEach
    void setup() {
        this.aliveTabletServersById = new HashMap<Integer, ServerNode>();
        for (ServerNode node : NODES) {
            this.aliveTabletServersById.put(node.id(), node);
        }
    }

    @Test
    void testReturnModifiableCollections() {
        HashMap<PhysicalTablePath, List<BucketLocation>> tablePathToBucketLocations = new HashMap<PhysicalTablePath, List<BucketLocation>>();
        tablePathToBucketLocations.put(TestData.DATA1_PHYSICAL_TABLE_PATH, Arrays.asList(new BucketLocation(TestData.DATA1_PHYSICAL_TABLE_PATH, 150001L, 0, NODES[0], NODES), new BucketLocation(TestData.DATA1_PHYSICAL_TABLE_PATH, 150001L, 1, null, NODES), new BucketLocation(TestData.DATA1_PHYSICAL_TABLE_PATH, 150001L, 2, NODES[2], NODES)));
        tablePathToBucketLocations.put(PhysicalTablePath.of((TablePath)TestData.DATA2_TABLE_PATH), Arrays.asList(new BucketLocation(PhysicalTablePath.of((TablePath)TestData.DATA2_TABLE_PATH), 150002L, 0, null, NODES), new BucketLocation(PhysicalTablePath.of((TablePath)TestData.DATA2_TABLE_PATH), 150002L, 1, NODES[0], NODES)));
        HashMap<TablePath, Long> tablePathToTableId = new HashMap<TablePath, Long>();
        tablePathToTableId.put(TestData.DATA1_TABLE_PATH, 150001L);
        tablePathToTableId.put(TestData.DATA2_TABLE_PATH, 150002L);
        HashMap<TablePath, TableInfo> tablePathToTableInfo = new HashMap<TablePath, TableInfo>();
        tablePathToTableInfo.put(TestData.DATA1_TABLE_PATH, TestData.DATA1_TABLE_INFO);
        tablePathToTableInfo.put(TestData.DATA2_TABLE_PATH, TestData.DATA2_TABLE_INFO);
        Cluster cluster = new Cluster(this.aliveTabletServersById, COORDINATOR_SERVER, tablePathToBucketLocations, tablePathToTableId, Collections.emptyMap(), tablePathToTableInfo);
        Assertions.assertThatThrownBy(() -> cluster.getAliveTabletServers().put(1, NODES[3])).isInstanceOf(UnsupportedOperationException.class);
        Assertions.assertThatThrownBy(() -> cluster.getAvailableBucketsForPhysicalTablePath(TestData.DATA1_PHYSICAL_TABLE_PATH).add(new BucketLocation(TestData.DATA1_PHYSICAL_TABLE_PATH, 150001L, 3, NODES[3], NODES))).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testGetTable() {
        HashMap<PhysicalTablePath, List<BucketLocation>> tablePathToBucketLocations = new HashMap<PhysicalTablePath, List<BucketLocation>>();
        tablePathToBucketLocations.put(TestData.DATA1_PHYSICAL_TABLE_PATH, Arrays.asList(new BucketLocation(TestData.DATA1_PHYSICAL_TABLE_PATH, 150001L, 0, NODES[0], NODES), new BucketLocation(TestData.DATA1_PHYSICAL_TABLE_PATH, 150001L, 1, null, NODES), new BucketLocation(TestData.DATA1_PHYSICAL_TABLE_PATH, 150001L, 2, NODES[2], NODES)));
        tablePathToBucketLocations.put(PhysicalTablePath.of((TablePath)TestData.DATA2_TABLE_PATH), Arrays.asList(new BucketLocation(PhysicalTablePath.of((TablePath)TestData.DATA2_TABLE_PATH), 150002L, 0, null, NODES), new BucketLocation(PhysicalTablePath.of((TablePath)TestData.DATA2_TABLE_PATH), 150002L, 1, NODES[0], NODES)));
        HashMap<TablePath, Long> tablePathToTableId = new HashMap<TablePath, Long>();
        tablePathToTableId.put(TestData.DATA1_TABLE_PATH, 150001L);
        tablePathToTableId.put(TestData.DATA2_TABLE_PATH, 150002L);
        HashMap<TablePath, TableInfo> tablePathToTableInfo = new HashMap<TablePath, TableInfo>();
        tablePathToTableInfo.put(TestData.DATA1_TABLE_PATH, TestData.DATA1_TABLE_INFO);
        tablePathToTableInfo.put(TestData.DATA2_TABLE_PATH, TestData.DATA2_TABLE_INFO);
        Cluster cluster = new Cluster(this.aliveTabletServersById, COORDINATOR_SERVER, tablePathToBucketLocations, tablePathToTableId, Collections.emptyMap(), tablePathToTableInfo);
        Assertions.assertThat(cluster.getTable(TestData.DATA1_TABLE_PATH).get()).isEqualTo((Object)TestData.DATA1_TABLE_INFO);
        Assertions.assertThat(cluster.getTable(TestData.DATA2_TABLE_PATH).get()).isEqualTo((Object)TestData.DATA2_TABLE_INFO);
        Assertions.assertThat(cluster.getSchema(TestData.DATA1_TABLE_PATH).get()).isEqualTo((Object)new SchemaInfo(TestData.DATA1_SCHEMA, 1));
        Assertions.assertThat(cluster.getSchema(TestData.DATA2_TABLE_PATH).get()).isEqualTo((Object)new SchemaInfo(TestData.DATA2_SCHEMA, 1));
    }
}

