/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.config;

import com.alibaba.fluss.config.ConfigBuilder;
import com.alibaba.fluss.config.ConfigOption;
import com.alibaba.fluss.config.FallbackKey;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigOptionTest {
    @Test
    void testDescription() {
        ConfigOption option = ConfigBuilder.key((String)"key").intType().defaultValue((Object)0).withDescription("hello key");
        Assertions.assertThat((String)option.description()).isEqualTo("hello key");
        ConfigOption option2 = ConfigBuilder.key((String)"key2").intType().defaultValue((Object)0);
        Assertions.assertThat((String)option2.description()).isEqualTo("");
    }

    @Test
    void testDefaultValue() {
        ConfigOption option = ConfigBuilder.key((String)"key").intType().noDefaultValue();
        Assertions.assertThat((boolean)option.hasDefaultValue()).isFalse();
        ConfigOption option2 = ConfigBuilder.key((String)"key2").intType().defaultValue((Object)1);
        Assertions.assertThat((boolean)option2.hasDefaultValue()).isTrue();
        Assertions.assertThat((Integer)((Integer)option2.defaultValue())).isEqualTo(1);
    }

    @Test
    void testDeprecationFlagForDeprecatedKeys() {
        ConfigOption optionWithDeprecatedKeys = ConfigBuilder.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(new String[]{"deprecated1", "deprecated2"});
        Assertions.assertThat((boolean)optionWithDeprecatedKeys.hasFallbackKeys()).isTrue();
        for (FallbackKey fallbackKey : optionWithDeprecatedKeys.fallbackKeys()) {
            Assertions.assertThat((boolean)fallbackKey.isDeprecated()).isTrue();
        }
    }

    @Test
    void testDeprecationFlagForFallbackKeys() {
        ConfigOption optionWithFallbackKeys = ConfigBuilder.key((String)"key").intType().defaultValue((Object)0).withFallbackKeys(new String[]{"fallback1", "fallback2"});
        Assertions.assertThat((boolean)optionWithFallbackKeys.hasFallbackKeys()).isTrue();
        Assertions.assertThat((Iterable)optionWithFallbackKeys.fallbackKeys()).allMatch(f -> !f.isDeprecated());
    }

    @Test
    void testDeprecationFlagForMixedAlternativeKeys() {
        ConfigOption optionWithMixedKeys = ConfigBuilder.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(new String[]{"deprecated1", "deprecated2"}).withFallbackKeys(new String[]{"fallback1", "fallback2"});
        ArrayList<String> fallbackKeys = new ArrayList<String>(2);
        ArrayList<String> deprecatedKeys = new ArrayList<String>(2);
        for (FallbackKey alternativeKey : optionWithMixedKeys.fallbackKeys()) {
            if (alternativeKey.isDeprecated()) {
                deprecatedKeys.add(alternativeKey.getKey());
                continue;
            }
            fallbackKeys.add(alternativeKey.getKey());
        }
        Assertions.assertThat((int)fallbackKeys.size()).isEqualTo(2);
        Assertions.assertThat((int)deprecatedKeys.size()).isEqualTo(2);
        Assertions.assertThat(Stream.of("fallback1", "fallback2").sorted().collect(Collectors.toList())).isEqualTo(fallbackKeys.stream().sorted().collect(Collectors.toList()));
        Assertions.assertThat(Stream.of("deprecated1", "deprecated2").sorted().collect(Collectors.toList())).isEqualTo(deprecatedKeys.stream().sorted().collect(Collectors.toList()));
    }

    @Test
    void testOptionComparison() {
        ConfigOption opt1 = ConfigBuilder.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(new String[]{"deprecated1", "deprecated2"}).withFallbackKeys(new String[]{"fallback1", "fallback2"});
        ConfigOption opt2 = ConfigBuilder.key((String)"key").intType().defaultValue((Object)0).withDeprecatedKeys(new String[]{"deprecated1", "deprecated2"}).withFallbackKeys(new String[]{"fallback1", "fallback2"});
        Assertions.assertThat((Object)opt1).isEqualTo((Object)opt2);
        Assertions.assertThat((int)opt1.hashCode()).isEqualTo(opt2.hashCode());
        Assertions.assertThat((String)opt1.toString()).isEqualTo(opt2.toString());
    }
}

