/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.config;

import com.alibaba.fluss.config.ConfigBuilder;
import com.alibaba.fluss.config.ConfigOption;
import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.config.MemorySize;
import com.alibaba.fluss.config.Password;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigurationTest {
    private static final ConfigOption<String> STRING_OPTION = ConfigBuilder.key((String)"test-string-key").stringType().noDefaultValue();
    private static final ConfigOption<Integer> INTEGER_OPTION = ConfigBuilder.key((String)"test-integer-key").intType().noDefaultValue();
    private static final ConfigOption<Long> LONG_OPTION = ConfigBuilder.key((String)"test-long-key").longType().defaultValue((Object)4716238L);
    private static final ConfigOption<Float> FLOAT_OPTION = ConfigBuilder.key((String)"test-float-key").floatType().noDefaultValue();
    private static final ConfigOption<Double> DOUBLE_OPTION = ConfigBuilder.key((String)"test-double-key").doubleType().noDefaultValue();
    private static final ConfigOption<Boolean> BOOLEAN_OPTION = ConfigBuilder.key((String)"test-boolean-key").booleanType().defaultValue((Object)true);
    private static final ConfigOption<MemorySize> MEMORY_OPTION = ConfigBuilder.key((String)"test-memory-key").memoryType().defaultValue((Object)MemorySize.parse((String)"64 kb"));
    private static final ConfigOption<List<String>> LIST_STRING_OPTION = ConfigBuilder.key((String)"test-list-key").stringType().asList().noDefaultValue();
    private static final ConfigOption<Map<String, String>> MAP_OPTION = ConfigBuilder.key((String)"test-map-key").mapType().noDefaultValue();
    private static final ConfigOption<Duration> DURATION_OPTION = ConfigBuilder.key((String)"test-duration-key").durationType().noDefaultValue();
    private static final ConfigOption<Password> SECRET_OPTION = ConfigBuilder.key((String)"secret").passwordType().noDefaultValue();
    private static final Map<String, String> PROPERTIES_MAP = new HashMap<String, String>();

    @Test
    void testGetterAndSetter() throws Exception {
        Configuration conf = new Configuration();
        conf.setString(STRING_OPTION.key(), "value1");
        Assertions.assertThat((String)conf.getString(STRING_OPTION)).isEqualTo("value1");
        conf.setString(STRING_OPTION, "value2");
        Assertions.assertThat((String)conf.getString(STRING_OPTION)).isEqualTo("value2");
        conf.setInt(INTEGER_OPTION.key(), 100);
        Assertions.assertThat((int)conf.getInt(INTEGER_OPTION)).isEqualTo(100);
        conf.setString(INTEGER_OPTION.key(), "1000");
        Assertions.assertThat((int)conf.getInt(INTEGER_OPTION)).isEqualTo(1000);
        conf.setLong(LONG_OPTION.key(), 478236947162389746L);
        Assertions.assertThat((long)conf.getLong(LONG_OPTION)).isEqualTo(478236947162389746L);
        conf.setString(LONG_OPTION.key(), "-47823692389746");
        Assertions.assertThat((long)conf.getLong(LONG_OPTION)).isEqualTo(-47823692389746L);
        conf.setFloat(FLOAT_OPTION.key(), 3.1415925f);
        Assertions.assertThat((float)conf.getFloat(FLOAT_OPTION)).isEqualTo(3.1415925f);
        conf.setString(FLOAT_OPTION.key(), "-3.1415926");
        Assertions.assertThat((float)conf.getFloat(FLOAT_OPTION)).isEqualTo(-3.1415925f);
        conf.setDouble(DOUBLE_OPTION.key(), Math.E);
        Assertions.assertThat((double)conf.getDouble(DOUBLE_OPTION)).isEqualTo(Math.E);
        conf.setString(DOUBLE_OPTION.key(), "123123.2312");
        Assertions.assertThat((double)conf.getDouble(DOUBLE_OPTION)).isEqualTo(123123.2312);
        conf.setBoolean(BOOLEAN_OPTION.key(), false);
        Assertions.assertThat((boolean)conf.getBoolean(BOOLEAN_OPTION)).isEqualTo(false);
        conf.setString(BOOLEAN_OPTION.key(), "true");
        Assertions.assertThat((boolean)conf.getBoolean(BOOLEAN_OPTION)).isEqualTo(true);
        conf.set(MEMORY_OPTION, (Object)MemorySize.parse((String)"128 kb"));
        Assertions.assertThat((long)((MemorySize)conf.get(MEMORY_OPTION)).getBytes()).isEqualTo(131072L);
        conf.setString(MEMORY_OPTION.key(), "12mb");
        Assertions.assertThat((long)((MemorySize)conf.get(MEMORY_OPTION)).getBytes()).isEqualTo(0xC00000L);
        conf.set(DURATION_OPTION, (Object)Duration.ofMillis(3L));
        Assertions.assertThat((long)((Duration)conf.get(DURATION_OPTION)).toMillis()).isEqualTo(3L);
        conf.setString(DURATION_OPTION.key(), "3 s");
        Assertions.assertThat((long)((Duration)conf.get(DURATION_OPTION)).toMillis()).isEqualTo(3000L);
        conf.setBytes("test-bytes-key", new byte[]{1, 2, 3, 4, 5});
        Assertions.assertThat((int)conf.getBytes("test-bytes-key", new byte[0]).length).isEqualTo(5);
        conf.setClass("test-class-key", this.getClass());
        Assertions.assertThat((Class)conf.getClass("test-class-key", this.getClass(), this.getClass().getClassLoader())).isEqualTo(this.getClass());
        conf = new Configuration();
        Assertions.assertThat((String)conf.getString(STRING_OPTION, "value3")).isEqualTo("value3");
        Assertions.assertThat((int)conf.getInt(INTEGER_OPTION, 1)).isEqualTo(1);
        Assertions.assertThat((long)conf.getLong(LONG_OPTION, 200L)).isEqualTo(200L);
        Assertions.assertThat((float)conf.getFloat(FLOAT_OPTION, 3.15f)).isEqualTo(3.15f);
        Assertions.assertThat((double)conf.getDouble(DOUBLE_OPTION, 1.1)).isEqualTo(1.1);
        Assertions.assertThat((boolean)conf.getBoolean(BOOLEAN_OPTION, false)).isEqualTo(false);
        Assertions.assertThat((long)((MemorySize)conf.get(MEMORY_OPTION)).getBytes()).isEqualTo(65536L);
    }

    @Test
    void testCopyConstructor() {
        Configuration conf1 = new Configuration();
        conf1.setString(STRING_OPTION, "value");
        Configuration conf2 = new Configuration(conf1);
        conf2.setString(STRING_OPTION, "another value");
        Assertions.assertThat((String)conf1.getString(STRING_OPTION)).isEqualTo("value");
        Assertions.assertThat((String)conf2.getString(STRING_OPTION)).isEqualTo("another value");
    }

    @Test
    void testAddAll() {
        Configuration conf1 = new Configuration();
        conf1.setString(STRING_OPTION, "value");
        conf1.setInt(INTEGER_OPTION, 1);
        Configuration conf2 = new Configuration();
        conf2.addAll(conf1);
        Assertions.assertThat((int)conf2.keySet().size()).isEqualTo(2);
        Assertions.assertThat((String)conf2.getString(STRING_OPTION)).isEqualTo("value");
        Assertions.assertThat((int)conf2.getInt(INTEGER_OPTION)).isEqualTo(1);
    }

    @Test
    void testAddAllToProperties() {
        Configuration conf1 = new Configuration();
        conf1.setString(STRING_OPTION, "value");
        conf1.setInt(INTEGER_OPTION, 1);
        Properties props = new Properties();
        conf1.addAllToProperties(props);
        Assertions.assertThat((int)props.size()).isEqualTo(2);
        Assertions.assertThat((String)props.getProperty(STRING_OPTION.key())).isEqualTo("value");
        Assertions.assertThat((Object)props.get(INTEGER_OPTION.key())).isEqualTo((Object)1);
    }

    @Test
    void testOptionWithDefault() {
        Configuration conf = new Configuration();
        conf.setInt("int-key", 11);
        conf.setString("string-key", "abc");
        ConfigOption presentStringOption = ConfigBuilder.key((String)"string-key").stringType().defaultValue((Object)"my-beautiful-default");
        ConfigOption presentIntOption = ConfigBuilder.key((String)"int-key").intType().defaultValue((Object)87);
        Assertions.assertThat((String)conf.getString(presentStringOption)).isEqualTo("abc");
        Assertions.assertThat((String)conf.getValue(presentStringOption)).isEqualTo("abc");
        Assertions.assertThat((int)conf.getInt(presentIntOption)).isEqualTo(11);
        Assertions.assertThat((String)conf.getValue(presentIntOption)).isEqualTo("11");
        ConfigOption stringOption = ConfigBuilder.key((String)"test").stringType().defaultValue((Object)"my-beautiful-default");
        ConfigOption intOption = ConfigBuilder.key((String)"test2").intType().defaultValue((Object)87);
        Assertions.assertThat((String)conf.getString(stringOption)).isEqualTo("my-beautiful-default");
        Assertions.assertThat((String)conf.getValue(stringOption)).isEqualTo("my-beautiful-default");
        Assertions.assertThat((String)conf.getString(stringOption, "override")).isEqualTo("override");
        Assertions.assertThat((int)conf.getInt(intOption)).isEqualTo(87);
        Assertions.assertThat((String)conf.getValue(intOption)).isEqualTo("87");
    }

    @Test
    void testOptionWithNoDefault() {
        Configuration conf = new Configuration();
        conf.setInt("int-key", 11);
        conf.setString("string-key", "abc");
        ConfigOption presentStringOption = ConfigBuilder.key((String)"string-key").stringType().noDefaultValue();
        Assertions.assertThat((String)conf.getString(presentStringOption)).isEqualTo("abc");
        Assertions.assertThat((String)conf.getValue(presentStringOption)).isEqualTo("abc");
        ConfigOption stringOption = ConfigBuilder.key((String)"test").stringType().noDefaultValue();
        Assertions.assertThat((String)conf.getString(stringOption)).isNull();
        Assertions.assertThat((String)conf.getValue(stringOption)).isNull();
        Assertions.assertThat((String)conf.getString(stringOption, "override")).isEqualTo("override");
    }

    @Test
    void testFromMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(STRING_OPTION.key(), "value");
        map.put(INTEGER_OPTION.key(), "1");
        Configuration configuration = Configuration.fromMap(map);
        Assertions.assertThat((String)((String)configuration.get(STRING_OPTION))).isEqualTo("value");
        Assertions.assertThat((String)configuration.getString(STRING_OPTION)).isEqualTo("value");
        Assertions.assertThat((Integer)((Integer)configuration.get(INTEGER_OPTION))).isEqualTo(1);
        Assertions.assertThat((int)configuration.getInt(INTEGER_OPTION)).isEqualTo(1);
    }

    @Test
    void testDeprecatedKeys() {
        Configuration conf = new Configuration();
        conf.setInt("the-key", 11);
        conf.setInt("old-key", 12);
        conf.setInt("older-key", 13);
        ConfigOption matchesFirst = ConfigBuilder.key((String)"the-key").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"old-key", "older-key"});
        ConfigOption matchesSecond = ConfigBuilder.key((String)"does-not-exist").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"old-key", "older-key"});
        ConfigOption matchesThird = ConfigBuilder.key((String)"does-not-exist").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"foo", "older-key"});
        ConfigOption notContained = ConfigBuilder.key((String)"does-not-exist").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"not-there", "also-not-there"});
        Assertions.assertThat((int)conf.getInt(matchesFirst)).isEqualTo(11);
        Assertions.assertThat((int)conf.getInt(matchesSecond)).isEqualTo(12);
        Assertions.assertThat((int)conf.getInt(matchesThird)).isEqualTo(13);
        Assertions.assertThat((int)conf.getInt(notContained)).isEqualTo(-1);
    }

    @Test
    void testFallbackKeys() {
        Configuration conf = new Configuration();
        conf.setInt("the-key", 11);
        conf.setInt("old-key", 12);
        conf.setInt("older-key", 13);
        ConfigOption matchesFirst = ConfigBuilder.key((String)"the-key").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"old-key", "older-key"});
        ConfigOption matchesSecond = ConfigBuilder.key((String)"does-not-exist").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"old-key", "older-key"});
        ConfigOption matchesThird = ConfigBuilder.key((String)"does-not-exist").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"foo", "older-key"});
        ConfigOption notContained = ConfigBuilder.key((String)"does-not-exist").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{"not-there", "also-not-there"});
        Assertions.assertThat((int)conf.getInt(matchesFirst)).isEqualTo(11);
        Assertions.assertThat((int)conf.getInt(matchesSecond)).isEqualTo(12);
        Assertions.assertThat((int)conf.getInt(matchesThird)).isEqualTo(13);
        Assertions.assertThat((int)conf.getInt(notContained)).isEqualTo(-1);
    }

    @Test
    void testFallbackAndDeprecatedKeys() {
        ConfigOption fallback = ConfigBuilder.key((String)"fallback").intType().defaultValue((Object)-1);
        ConfigOption deprecated = ConfigBuilder.key((String)"deprecated").intType().defaultValue((Object)-1);
        ConfigOption mainOption = ConfigBuilder.key((String)"main").intType().defaultValue((Object)-1).withFallbackKeys(new String[]{fallback.key()}).withDeprecatedKeys(new String[]{deprecated.key()});
        Configuration fallbackConf = new Configuration();
        fallbackConf.setInt(fallback, 1);
        Assertions.assertThat((Integer)((Integer)fallbackConf.get(mainOption))).isEqualTo(1);
        Configuration deprecatedConf = new Configuration();
        deprecatedConf.setInt(deprecated, 2);
        Assertions.assertThat((int)deprecatedConf.getInt(mainOption)).isEqualTo(2);
        Configuration deprecatedAndFallBackConfig = new Configuration();
        deprecatedAndFallBackConfig.setInt(deprecated, 1);
        deprecatedAndFallBackConfig.setInt(fallback, 2);
        Assertions.assertThat((int)deprecatedAndFallBackConfig.getInt(mainOption)).isEqualTo(2);
    }

    @Test
    void testRemoveConf() {
        Configuration conf = new Configuration();
        conf.setInt("a", 1);
        conf.setInt("b", 2);
        ConfigOption validOption = ConfigBuilder.key((String)"a").intType().defaultValue((Object)-1);
        ConfigOption deprecatedOption = ConfigBuilder.key((String)"c").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"d", "b"});
        ConfigOption unExistedOption = ConfigBuilder.key((String)"e").intType().defaultValue((Object)-1).withDeprecatedKeys(new String[]{"f", "g", "j"});
        Assertions.assertThat((int)conf.keySet().size()).isEqualTo(2);
        Assertions.assertThat((boolean)conf.removeConfig(validOption)).isTrue();
        Assertions.assertThat((boolean)conf.contains(validOption)).isFalse();
        Assertions.assertThat((int)conf.keySet().size()).isEqualTo(1);
        Assertions.assertThat((boolean)conf.contains(deprecatedOption)).isTrue();
        Assertions.assertThat((boolean)conf.removeConfig(deprecatedOption)).isTrue();
        Assertions.assertThat((boolean)conf.contains(deprecatedOption)).isFalse();
        Assertions.assertThat((int)conf.keySet().size()).isEqualTo(0);
        Assertions.assertThat((boolean)conf.removeConfig(unExistedOption)).isFalse();
    }

    @Test
    void testRemoveKey() {
        Configuration conf = new Configuration();
        String key1 = "a";
        conf.setInt(key1, 42);
        conf.setInt("e.f", 1337);
        Assertions.assertThat((boolean)conf.removeKey("not-existing-key")).isFalse();
        Assertions.assertThat((boolean)conf.removeKey(key1)).isTrue();
        Assertions.assertThat((boolean)conf.containsKey(key1)).isFalse();
    }

    @Test
    void testShouldParseValidStringToEnum() {
        Configuration conf = new Configuration();
        conf.setString(STRING_OPTION.key(), TestEnum.VALUE1.toString());
        TestEnum parsedEnumValue = (TestEnum)conf.getEnum(TestEnum.class, STRING_OPTION);
        Assertions.assertThat((Comparable)((Object)parsedEnumValue)).isEqualTo((Object)TestEnum.VALUE1);
    }

    @Test
    void testShouldParseValidStringToEnumIgnoringCase() {
        Configuration conf = new Configuration();
        conf.setString(STRING_OPTION.key(), TestEnum.VALUE1.toString().toLowerCase());
        TestEnum parsedEnumValue = (TestEnum)conf.getEnum(TestEnum.class, STRING_OPTION);
        Assertions.assertThat((Comparable)((Object)parsedEnumValue)).isEqualTo((Object)TestEnum.VALUE1);
    }

    @Test
    void testThrowsExceptionIfTryingToParseInvalidStringForEnum() {
        Configuration conf = new Configuration();
        String invalidValueForTestEnum = "InvalidValueForTestEnum";
        conf.setString(STRING_OPTION.key(), "InvalidValueForTestEnum");
        Assertions.assertThatThrownBy(() -> {
            TestEnum cfr_ignored_0 = (TestEnum)conf.getEnum(TestEnum.class, STRING_OPTION);
        }).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testToMap() {
        Configuration conf = new Configuration();
        String listValues = "value1,value2,value3";
        conf.set(LIST_STRING_OPTION, Arrays.asList("value1,value2,value3".split(",")));
        String mapValues = "key1:value1,key2:value2";
        conf.set(MAP_OPTION, Arrays.stream("key1:value1,key2:value2".split(",")).collect(Collectors.toMap(e -> e.split(":")[0], e -> e.split(":")[1])));
        Duration duration = Duration.ofMillis(3000L);
        conf.set(DURATION_OPTION, (Object)duration);
        Assertions.assertThat((String)((String)conf.toMap().get(LIST_STRING_OPTION.key()))).isEqualTo("value1,value2,value3");
        Assertions.assertThat((String)((String)conf.toMap().get(MAP_OPTION.key()))).isEqualTo("key1:value1,key2:value2");
        Assertions.assertThat((String)((String)conf.toMap().get(DURATION_OPTION.key()))).isEqualTo("3 s");
    }

    @Test
    void testMapNotContained() {
        Configuration conf = new Configuration();
        Assertions.assertThat((boolean)conf.getOptional(MAP_OPTION).isPresent()).isFalse();
        Assertions.assertThat((boolean)conf.contains(MAP_OPTION)).isFalse();
    }

    @Test
    void testMap() {
        Configuration cfg = new Configuration();
        cfg.set(MAP_OPTION, PROPERTIES_MAP);
        Assertions.assertThat((Map)((Map)cfg.get(MAP_OPTION))).isEqualTo(PROPERTIES_MAP);
        Assertions.assertThat((boolean)cfg.contains(MAP_OPTION)).isTrue();
    }

    @Test
    void testPasswordType() {
        Configuration cfg = new Configuration();
        String secretValue = "secret_value";
        cfg.setString(SECRET_OPTION.key(), "secret_value");
        Assertions.assertThat((Object)cfg.get(SECRET_OPTION)).isEqualTo((Object)new Password("secret_value"));
        Assertions.assertThat((String)((Password)cfg.get(SECRET_OPTION)).toString()).isEqualTo("******");
        Assertions.assertThat((String)((Password)cfg.get(SECRET_OPTION)).value()).isEqualTo("secret_value");
    }

    @Test
    void testPasswordParserErrorDoesNotLeakSensitiveData() {
        Assertions.assertThat((boolean)SECRET_OPTION.isSensitive()).isTrue();
        Configuration cfg = new Configuration();
        cfg.setValueInternal(SECRET_OPTION.key(), (Object)new ToStringError());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            Password cfr_ignored_0 = (Password)cfg.get(SECRET_OPTION);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Could not parse value for key 'secret'.");
    }

    @Test
    void testPasswordListParserErrorDoesNotLeakSensitiveData() {
        ConfigOption secret = ConfigBuilder.key((String)"secret").passwordType().asList().noDefaultValue();
        Assertions.assertThat((boolean)secret.isSensitive()).isTrue();
        Configuration cfg = new Configuration();
        cfg.setString(secret.key(), "'secret_value");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            List cfr_ignored_0 = (List)cfg.get(secret);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageNotContaining("secret_value");
    }

    static {
        PROPERTIES_MAP.put("prop1", "value1");
        PROPERTIES_MAP.put("prop2", "12");
    }

    static class ToStringError {
        ToStringError() {
        }

        public String toString() {
            throw new RuntimeException("Test exception");
        }
    }

    static enum TestEnum {
        VALUE1,
        VALUE2;

    }
}

