/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.config;

import com.alibaba.fluss.config.MemorySize;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MemorySizeTest {
    static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{new MemorySize(MemorySize.MemoryUnit.KILO_BYTES.getMultiplier() + 1L), "1025 bytes"}), Arguments.of((Object[])new Object[]{new MemorySize(100L), "100 bytes"}), Arguments.of((Object[])new Object[]{new MemorySize(1024L), "1 kb"}), Arguments.of((Object[])new Object[]{new MemorySize(MemorySize.MemoryUnit.GIGA_BYTES.getMultiplier() + 1L), String.format("%d %s", MemorySize.MemoryUnit.GIGA_BYTES.getMultiplier() + 1L, "bytes")}), Arguments.of((Object[])new Object[]{new MemorySize(0L), "0 bytes"}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void testFormatting(MemorySize size, String expectedString) {
        Assertions.assertThat((String)size.toString()).isEqualTo(expectedString);
    }

    @Test
    void testUnitConversion() {
        MemorySize zero = MemorySize.ZERO;
        Assertions.assertThat((long)zero.getBytes()).isEqualTo(0L);
        Assertions.assertThat((long)zero.getKibiBytes()).isEqualTo(0L);
        Assertions.assertThat((int)zero.getMebiBytes()).isEqualTo(0);
        Assertions.assertThat((long)zero.getGibiBytes()).isEqualTo(0L);
        Assertions.assertThat((long)zero.getTebiBytes()).isEqualTo(0L);
        MemorySize bytes = new MemorySize(955L);
        Assertions.assertThat((long)bytes.getBytes()).isEqualTo(955L);
        Assertions.assertThat((long)bytes.getKibiBytes()).isEqualTo(0L);
        Assertions.assertThat((int)bytes.getMebiBytes()).isEqualTo(0);
        Assertions.assertThat((long)bytes.getGibiBytes()).isEqualTo(0L);
        Assertions.assertThat((long)bytes.getTebiBytes()).isEqualTo(0L);
        MemorySize kilos = new MemorySize(18500L);
        Assertions.assertThat((long)kilos.getBytes()).isEqualTo(18500L);
        Assertions.assertThat((long)kilos.getKibiBytes()).isEqualTo(18L);
        Assertions.assertThat((int)kilos.getMebiBytes()).isEqualTo(0);
        Assertions.assertThat((long)kilos.getGibiBytes()).isEqualTo(0L);
        Assertions.assertThat((long)kilos.getTebiBytes()).isEqualTo(0L);
        MemorySize megas = new MemorySize(0xF00000L);
        Assertions.assertThat((long)megas.getBytes()).isEqualTo(0xF00000L);
        Assertions.assertThat((long)megas.getKibiBytes()).isEqualTo(15360L);
        Assertions.assertThat((int)megas.getMebiBytes()).isEqualTo(15);
        Assertions.assertThat((long)megas.getGibiBytes()).isEqualTo(0L);
        Assertions.assertThat((long)megas.getTebiBytes()).isEqualTo(0L);
        MemorySize teras = new MemorySize(0x2000000000AL);
        Assertions.assertThat((long)teras.getBytes()).isEqualTo(0x2000000000AL);
        Assertions.assertThat((long)teras.getKibiBytes()).isEqualTo(0x80000000L);
        Assertions.assertThat((int)teras.getMebiBytes()).isEqualTo(0x200000);
        Assertions.assertThat((long)teras.getGibiBytes()).isEqualTo(2048L);
        Assertions.assertThat((long)teras.getTebiBytes()).isEqualTo(2L);
    }

    @Test
    void testInvalid() {
        Assertions.assertThatThrownBy(() -> new MemorySize(-1L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testParseBytes() {
        Assertions.assertThat((long)MemorySize.parseBytes((String)"1234b")).isEqualTo(1234L);
        Assertions.assertThat((long)MemorySize.parseBytes((String)"1234 b")).isEqualTo(1234L);
        Assertions.assertThat((long)MemorySize.parseBytes((String)"1234bytes")).isEqualTo(1234L);
        Assertions.assertThat((long)MemorySize.parseBytes((String)"1234 bytes")).isEqualTo(1234L);
    }

    @Test
    void testParseKibiBytes() {
        Assertions.assertThat((long)MemorySize.parse((String)"667766k").getKibiBytes()).isEqualTo(667766L);
        Assertions.assertThat((long)MemorySize.parse((String)"667766 k").getKibiBytes()).isEqualTo(667766L);
        Assertions.assertThat((long)MemorySize.parse((String)"667766kb").getKibiBytes()).isEqualTo(667766L);
        Assertions.assertThat((long)MemorySize.parse((String)"667766 kb").getKibiBytes()).isEqualTo(667766L);
        Assertions.assertThat((long)MemorySize.parse((String)"667766kibibytes").getKibiBytes()).isEqualTo(667766L);
        Assertions.assertThat((long)MemorySize.parse((String)"667766 kibibytes").getKibiBytes()).isEqualTo(667766L);
    }

    @Test
    void testParseMebiBytes() {
        Assertions.assertThat((int)MemorySize.parse((String)"7657623m").getMebiBytes()).isEqualTo(7657623);
        Assertions.assertThat((int)MemorySize.parse((String)"7657623 m").getMebiBytes()).isEqualTo(7657623);
        Assertions.assertThat((int)MemorySize.parse((String)"7657623mb").getMebiBytes()).isEqualTo(7657623);
        Assertions.assertThat((int)MemorySize.parse((String)"7657623 mb").getMebiBytes()).isEqualTo(7657623);
        Assertions.assertThat((int)MemorySize.parse((String)"7657623mebibytes").getMebiBytes()).isEqualTo(7657623);
        Assertions.assertThat((int)MemorySize.parse((String)"7657623 mebibytes").getMebiBytes()).isEqualTo(7657623);
    }

    @Test
    void testParseGibiBytes() {
        Assertions.assertThat((long)MemorySize.parse((String)"987654g").getGibiBytes()).isEqualTo(987654L);
        Assertions.assertThat((long)MemorySize.parse((String)"987654 g").getGibiBytes()).isEqualTo(987654L);
        Assertions.assertThat((long)MemorySize.parse((String)"987654g").getGibiBytes()).isEqualTo(987654L);
        Assertions.assertThat((long)MemorySize.parse((String)"987654 gb").getGibiBytes()).isEqualTo(987654L);
        Assertions.assertThat((long)MemorySize.parse((String)"987654gibibytes").getGibiBytes()).isEqualTo(987654L);
        Assertions.assertThat((long)MemorySize.parse((String)"987654 gibibytes").getGibiBytes()).isEqualTo(987654L);
    }

    @Test
    void testParseTebiBytes() {
        Assertions.assertThat((long)MemorySize.parse((String)"1234567t").getTebiBytes()).isEqualTo(1234567L);
        Assertions.assertThat((long)MemorySize.parse((String)"1234567 t").getTebiBytes()).isEqualTo(1234567L);
        Assertions.assertThat((long)MemorySize.parse((String)"1234567tb").getTebiBytes()).isEqualTo(1234567L);
        Assertions.assertThat((long)MemorySize.parse((String)"1234567 tb").getTebiBytes()).isEqualTo(1234567L);
        Assertions.assertThat((long)MemorySize.parse((String)"1234567tebibytes").getTebiBytes()).isEqualTo(1234567L);
        Assertions.assertThat((long)MemorySize.parse((String)"1234567 tebibytes").getTebiBytes()).isEqualTo(1234567L);
    }

    @Test
    void testUpperCase() {
        Assertions.assertThat((long)MemorySize.parse((String)"1 B").getBytes()).isEqualTo(1L);
        Assertions.assertThat((long)MemorySize.parse((String)"1 K").getKibiBytes()).isEqualTo(1L);
        Assertions.assertThat((int)MemorySize.parse((String)"1 M").getMebiBytes()).isEqualTo(1L);
        Assertions.assertThat((long)MemorySize.parse((String)"1 G").getGibiBytes()).isEqualTo(1L);
        Assertions.assertThat((long)MemorySize.parse((String)"1 T").getTebiBytes()).isEqualTo(1L);
    }

    @Test
    void testTrimBeforeParse() {
        Assertions.assertThat((long)MemorySize.parseBytes((String)"      155      bytes   ")).isEqualTo(155L);
    }

    @Test
    void testParseInvalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"1234")).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("The memory value '1234' does not specify a memory unit.");
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"      155      ")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes(null)).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"     ")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"foobar or fubar or foo bazz")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"16 gjah")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"16 16 17 18 bytes")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"-100 bytes")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testParseNumberOverflow() {
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"100000000000000000000000000000000 bytes")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testParseNumberTimeUnitOverflow() {
        Assertions.assertThatThrownBy(() -> MemorySize.parseBytes((String)"100000000000000 tb")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testDivideByLong() {
        MemorySize memory = new MemorySize(100L);
        Assertions.assertThat((Comparable)memory.divide(23L)).isEqualTo((Object)new MemorySize(4L));
    }

    @Test
    void testDivideByNegativeLong() {
        MemorySize memory = new MemorySize(100L);
        Assertions.assertThatThrownBy(() -> memory.divide(-23L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testToHumanReadableString() {
        Assertions.assertThat((String)new MemorySize(0L).toHumanReadableString()).isEqualTo("0 bytes");
        Assertions.assertThat((String)new MemorySize(1L).toHumanReadableString()).isEqualTo("1 bytes");
        Assertions.assertThat((String)new MemorySize(1024L).toHumanReadableString()).isEqualTo("1024 bytes");
        Assertions.assertThat((String)new MemorySize(1025L).toHumanReadableString()).isEqualTo("1.001kb (1025 bytes)");
        Assertions.assertThat((String)new MemorySize(1536L).toHumanReadableString()).isEqualTo("1.500kb (1536 bytes)");
        Assertions.assertThat((String)new MemorySize(1000000L).toHumanReadableString()).isEqualTo("976.563kb (1000000 bytes)");
        Assertions.assertThat((String)new MemorySize(1000000000L).toHumanReadableString()).isEqualTo("953.674mb (1000000000 bytes)");
        Assertions.assertThat((String)new MemorySize(1000000000000L).toHumanReadableString()).isEqualTo("931.323gb (1000000000000 bytes)");
        Assertions.assertThat((String)new MemorySize(1000000000000000L).toHumanReadableString()).isEqualTo("909.495tb (1000000000000000 bytes)");
    }
}

