/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.config;

import com.alibaba.fluss.config.StructuredOptionsSplitter;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class StructuredOptionsSplitterEscapeTest {
    static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSpec.encode("A,B,C,D", ";").expect("A,B,C,D")}), Arguments.of((Object[])new Object[]{TestSpec.encode("A;BCD", ";").expect("'A;BCD'")}), Arguments.of((Object[])new Object[]{TestSpec.encode("A'B'C'D", ";").expect("'A''B''C''D'")}), Arguments.of((Object[])new Object[]{TestSpec.encode("AB\"C\"D", ";").expect("'AB\"C\"D'")}), Arguments.of((Object[])new Object[]{TestSpec.encode("AB'\"D:B", ";").expect("'AB''\"D:B'")}), Arguments.of((Object[])new Object[]{TestSpec.encode("A,B,C,D", ",").expect("'A,B,C,D'")}), Arguments.of((Object[])new Object[]{TestSpec.encode("A;BCD", ",").expect("A;BCD")}), Arguments.of((Object[])new Object[]{TestSpec.encode("AB\"C\"D", ",").expect("'AB\"C\"D'")}), Arguments.of((Object[])new Object[]{TestSpec.encode("AB'\"D:B", ",").expect("'AB''\"D:B'")}), Arguments.of((Object[])new Object[]{TestSpec.encode("A;B;C;D", ",", ":").expect("A;B;C;D")}), Arguments.of((Object[])new Object[]{TestSpec.encode("A;B;C:D", ",", ":").expect("'A;B;C:D'")}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void testEscapeWithSingleQuote(TestSpec testSpec) {
        String encoded = StructuredOptionsSplitter.escapeWithSingleQuote((String)testSpec.getString(), (String[])testSpec.getEscapeChars());
        Assertions.assertThat((String)encoded).isEqualTo(testSpec.getEncodedString());
    }

    private static class TestSpec {
        private final String string;
        private final String[] escapeChars;
        private String encodedString;

        private TestSpec(String string, String ... escapeChars) {
            this.string = string;
            this.escapeChars = escapeChars;
        }

        public static TestSpec encode(String string, String ... escapeChars) {
            return new TestSpec(string, escapeChars);
        }

        public TestSpec expect(String string) {
            this.encodedString = string;
            return this;
        }

        public String getString() {
            return this.string;
        }

        public String getEncodedString() {
            return this.encodedString;
        }

        public String[] getEscapeChars() {
            return this.escapeChars;
        }
    }
}

