/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.config;

import com.alibaba.fluss.config.StructuredOptionsSplitter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class StructuredOptionsSplitterTest {
    static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestSpec.split("'A;B';C", ';').expect("A;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("'A;B';'C'", ';').expect("A;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("A;B;C", ';').expect("A", "B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("'AB''D;B';C", ';').expect("AB'D;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("A'BD;B';C", ';').expect("A'BD", "B'", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("'AB'D;B;C", ';').expectException("Could not split string. Illegal quoting at position: 3")}), Arguments.of((Object[])new Object[]{TestSpec.split("'A", ';').expectException("Could not split string. Quoting was not closed properly.")}), Arguments.of((Object[])new Object[]{TestSpec.split("C;'", ';').expectException("Could not split string. Quoting was not closed properly.")}), Arguments.of((Object[])new Object[]{TestSpec.split("\"A;B\";C", ';').expect("A;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("\"A;B\";\"C\"", ';').expect("A;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("A;B;C", ';').expect("A", "B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("\"AB\"\"D;B\";C", ';').expect("AB\"D;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("A\"BD;B\";C", ';').expect("A\"BD", "B\"", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("\"AB\"D;B;C", ';').expectException("Could not split string. Illegal quoting at position: 3")}), Arguments.of((Object[])new Object[]{TestSpec.split("\"A", ';').expectException("Could not split string. Quoting was not closed properly.")}), Arguments.of((Object[])new Object[]{TestSpec.split("C;\"", ';').expectException("Could not split string. Quoting was not closed properly.")}), Arguments.of((Object[])new Object[]{TestSpec.split("'AB\"D';B;C", ';').expect("AB\"D", "B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("'AB\"D;B';C", ';').expect("AB\"D;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("'AB\"''D;B';C", ';').expect("AB\"'D;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("\"AB'D\";B;C", ';').expect("AB'D", "B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("\"AB'D;B\";C", ';').expect("AB'D;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("\"AB'\"\"D;B\";C", ';').expect("AB'\"D;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("'A,B',C", ',').expect("A,B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("A,B,C", ',').expect("A", "B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("   'A;B'    ;   C   ", ';').expect("A;B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("   A;B    ;   C   ", ';').expect("A", "B", "C")}), Arguments.of((Object[])new Object[]{TestSpec.split("'A;B'    ;C A", ';').expect("A;B", "C A")}), Arguments.of((Object[])new Object[]{TestSpec.split("' A    ;B'    ;'   C'", ';').expect(" A    ;B", "   C")}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"parameters"})
    void testParse(TestSpec testSpec) {
        if (testSpec.getExpectedException().isPresent()) {
            Assertions.assertThat((String)testSpec.getExpectedException().get()).isNotEmpty();
            return;
        }
        List splits = StructuredOptionsSplitter.splitEscaped((String)testSpec.getString(), (char)testSpec.getDelimiter());
        Assertions.assertThat((List)splits).isEqualTo(testSpec.getExpectedSplits());
    }

    private static class TestSpec {
        private final String string;
        private final char delimiter;
        @Nullable
        private String expectedException = null;
        private List<String> expectedSplits = null;

        private TestSpec(String string, char delimiter) {
            this.string = string;
            this.delimiter = delimiter;
        }

        public static TestSpec split(String string, char delimiter) {
            return new TestSpec(string, delimiter);
        }

        public TestSpec expect(String ... splits) {
            this.expectedSplits = Arrays.asList(splits);
            return this;
        }

        public TestSpec expectException(String message) {
            this.expectedException = message;
            return this;
        }

        public String getString() {
            return this.string;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public Optional<String> getExpectedException() {
            return Optional.ofNullable(this.expectedException);
        }

        public List<String> getExpectedSplits() {
            return this.expectedSplits;
        }

        public String toString() {
            return String.format("str = [ %s ], del = '%s', expected = %s", this.string, Character.valueOf(this.delimiter), this.getExpectedException().map(e -> String.format("Exception(%s)", e)).orElseGet(() -> this.expectedSplits.stream().collect(Collectors.joining("], [", "[", "]"))));
        }
    }
}

