/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.fs;

import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.fs.FSDataInputStream;
import com.alibaba.fluss.fs.FSDataOutputStream;
import com.alibaba.fluss.fs.FileSystem;
import com.alibaba.fluss.fs.FileSystemPlugin;
import com.alibaba.fluss.fs.FsPath;
import com.alibaba.fluss.fs.PluginFileSystemWrapper;
import com.alibaba.fluss.fs.UnsupportedFileSystemSchemeException;
import com.alibaba.fluss.fs.local.LocalFileSystem;
import com.alibaba.fluss.plugin.PluginManager;
import com.alibaba.fluss.utils.WrappingProxy;
import com.alibaba.fluss.utils.WrappingProxyUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileSystemTest {
    FileSystemTest() {
    }

    @Test
    void testGet() throws URISyntaxException, IOException {
        String scheme = "file";
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet(scheme + ":///test/test")).isInstanceOf(LocalFileSystem.class);
        try {
            FileSystemTest.getFileSystemWithoutSafetyNet(scheme + "://test/test");
        }
        catch (IOException ioe) {
            Assertions.assertThat((String)ioe.getMessage()).startsWith((CharSequence)"Found local file path with authority '");
        }
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet(scheme + ":/test/test")).isInstanceOf(LocalFileSystem.class);
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet(scheme + ":test/test")).isInstanceOf(LocalFileSystem.class);
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet("/test/test")).isInstanceOf(LocalFileSystem.class);
        Assertions.assertThat((Object)FileSystemTest.getFileSystemWithoutSafetyNet("test/test")).isInstanceOf(LocalFileSystem.class);
    }

    @Test
    void testWithPluginManager(@TempDir Path tempDir) throws Exception {
        String testPluginSchema = "test-plugin";
        HashMap<Class<FileSystemPlugin>, Iterator<TestPluginFileSystemPlugin>> fileSystemPlugins = new HashMap<Class<FileSystemPlugin>, Iterator<TestPluginFileSystemPlugin>>();
        fileSystemPlugins.put(FileSystemPlugin.class, Collections.singletonList(new TestPluginFileSystemPlugin(testPluginSchema, (FileSystem)LocalFileSystem.getSharedInstance())).iterator());
        FileSystem.initialize((Configuration)new Configuration(), (PluginManager)new TestingPluginManager(fileSystemPlugins));
        FileSystem fileSystem = FileSystem.get((URI)URI.create(testPluginSchema + ":///a/b/c"));
        Assertions.assertThat((Object)fileSystem).isInstanceOf(PluginFileSystemWrapper.ClassLoaderFixingFileSystem.class);
        PluginFileSystemWrapper.ClassLoaderFixingFileSystem classLoaderFixingFileSystem = (PluginFileSystemWrapper.ClassLoaderFixingFileSystem)fileSystem;
        Assertions.assertThat((Object)classLoaderFixingFileSystem.getWrappedDelegate()).isInstanceOf(LocalFileSystem.class);
        FsPath path = new FsPath(tempDir.toString(), "test");
        FSDataOutputStream outputStream = fileSystem.create(path, FileSystem.WriteMode.OVERWRITE);
        byte[] testbytes = new byte[]{1, 2, 3, 4, 5};
        outputStream.write(testbytes);
        outputStream.close();
        Assertions.assertThat((boolean)fileSystem.exists(path)).isTrue();
        byte[] testbytesRead = new byte[5];
        FSDataInputStream inputStream = fileSystem.open(path);
        Assertions.assertThat((int)5).isEqualTo(inputStream.read(testbytesRead));
        inputStream.close();
        Assertions.assertThat((byte[])testbytesRead).isEqualTo((Object)testbytes);
        inputStream = fileSystem.open(path);
        inputStream.seek(4L);
        testbytesRead = new byte[1];
        Assertions.assertThat((int)1).isEqualTo(inputStream.read(testbytesRead));
        Assertions.assertThat((byte[])testbytesRead).isEqualTo((Object)new byte[]{testbytes[4]});
        Assertions.assertThat((boolean)fileSystem.delete(path, true)).isTrue();
        Assertions.assertThat((Object[])fileSystem.listStatus(new FsPath(tempDir.toString()))).isEmpty();
        Assertions.assertThatThrownBy(() -> fileSystem.getFileStatus(path)).isInstanceOf(FileNotFoundException.class);
        Assertions.assertThat((boolean)fileSystem.rename(path, new FsPath(tempDir.toString(), "test1"))).isFalse();
    }

    @Test
    void testUnsupportedFS() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystemTest.getFileSystemWithoutSafetyNet("unknownfs://authority/")).isInstanceOf(UnsupportedFileSystemSchemeException.class)).hasMessageContaining("not directly supported");
    }

    @Test
    void testKnownFSWithoutPluginsAndException() {
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> FileSystemTest.getFileSystemWithoutSafetyNet("oss://authority/")).isInstanceOf(UnsupportedFileSystemSchemeException.class)).hasMessageContaining("File system schemes are supported").hasMessageContaining("fluss-fs-oss").hasMessageContaining("Please ensure that each plugin is configured properly");
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration(), null);
        }
    }

    private static FileSystem getFileSystemWithoutSafetyNet(String uri) throws URISyntaxException, IOException {
        FileSystem fileSystem = FileSystem.get((URI)new URI(uri));
        if (fileSystem instanceof WrappingProxy) {
            return (FileSystem)WrappingProxyUtil.stripProxy((WrappingProxy)((WrappingProxy)fileSystem));
        }
        return fileSystem;
    }

    private static class TestPluginFileSystemPlugin
    implements FileSystemPlugin {
        private final String scheme;
        private final FileSystem fileSystem;

        public TestPluginFileSystemPlugin(String scheme, FileSystem fileSystem) {
            this.scheme = scheme;
            this.fileSystem = fileSystem;
        }

        public String getScheme() {
            return this.scheme;
        }

        public FileSystem create(URI fsUri, Configuration configuration) throws IOException {
            return this.fileSystem;
        }
    }

    private static class TestingPluginManager
    implements PluginManager {
        private final Map<Class<?>, Iterator<?>> plugins;

        private TestingPluginManager(Map<Class<?>, Iterator<?>> plugins) {
            this.plugins = plugins;
        }

        public <P> Iterator<P> load(Class<P> service) {
            return this.plugins.get(service);
        }
    }
}

