/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.fs;

import com.alibaba.fluss.fs.FileSystem;
import com.alibaba.fluss.fs.FileSystemBehaviorTestSuite;
import com.alibaba.fluss.fs.FileSystemSafetyNet;
import com.alibaba.fluss.fs.FsPath;
import com.alibaba.fluss.fs.SafetyNetWrapperFileSystem;
import com.alibaba.fluss.fs.local.LocalFileSystem;
import java.net.URI;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class SafetyNetWrapperFileSystemTest
extends FileSystemBehaviorTestSuite {
    @TempDir
    private Path tmp;

    @Override
    @BeforeEach
    void prepare() throws Exception {
        FileSystemSafetyNet.initializeSafetyNetForThread();
        super.prepare();
    }

    @Override
    @AfterEach
    void cleanup() throws Exception {
        FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
        super.cleanup();
    }

    @Override
    protected FileSystem getFileSystem() throws Exception {
        return FileSystem.get((URI)LocalFileSystem.getLocalFsURI());
    }

    @Test
    void testWrappedDelegate() {
        Assertions.assertThat((Object)this.fs).isInstanceOf(SafetyNetWrapperFileSystem.class);
        Assertions.assertThat((Object)((SafetyNetWrapperFileSystem)this.fs).getWrappedDelegate()).isInstanceOf(LocalFileSystem.class);
    }

    @Override
    protected FsPath getBasePath() throws Exception {
        return new FsPath(this.tmp.toUri());
    }
}

