/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.fs;

import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.fs.FSDataInputStream;
import com.alibaba.fluss.fs.FSDataOutputStream;
import com.alibaba.fluss.fs.FileStatus;
import com.alibaba.fluss.fs.FileSystem;
import com.alibaba.fluss.fs.FileSystemPlugin;
import com.alibaba.fluss.fs.FsPath;
import com.alibaba.fluss.fs.local.LocalDataOutputStream;
import com.alibaba.fluss.fs.local.LocalFileStatus;
import com.alibaba.fluss.fs.local.LocalFileSystem;
import com.alibaba.fluss.utils.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TestFileSystem
extends LocalFileSystem {
    public static final String SCHEME = "test";
    private static final AtomicInteger streamOpenCounter = new AtomicInteger(0);
    private static final Map<FsPath, Integer> currentUnclosedOutputStream = new ConcurrentHashMap<FsPath, Integer>();

    public static int getNumtimeStreamOpened() {
        return streamOpenCounter.get();
    }

    public static void resetStreamOpenCounter() {
        streamOpenCounter.set(0);
    }

    public static int getNumberOfUnclosedOutputStream(FsPath path) {
        return currentUnclosedOutputStream.getOrDefault(path, 0);
    }

    public FSDataInputStream open(FsPath f) throws IOException {
        streamOpenCounter.incrementAndGet();
        return super.open(f);
    }

    public FSDataOutputStream create(FsPath filePath, FileSystem.WriteMode overwrite) throws IOException {
        currentUnclosedOutputStream.compute(filePath, (k, v) -> v == null ? 1 : v + 1);
        LocalDataOutputStream stream = (LocalDataOutputStream)super.create(filePath, overwrite);
        return new TestOutputStream(stream, filePath);
    }

    public FileStatus getFileStatus(FsPath f) throws IOException {
        LocalFileStatus status = (LocalFileStatus)super.getFileStatus(f);
        return new LocalFileStatus(status.getFile(), (FileSystem)this);
    }

    public FileStatus[] listStatus(FsPath f) throws IOException {
        FileStatus[] stati = super.listStatus(f);
        LocalFileStatus[] newStati = new LocalFileStatus[stati.length];
        for (int i = 0; i < stati.length; ++i) {
            newStati[i] = new LocalFileStatus(((LocalFileStatus)stati[i]).getFile(), (FileSystem)this);
        }
        return newStati;
    }

    public URI getUri() {
        return URI.create("test:///");
    }

    public static final class TestFileSystemPlugin
    implements FileSystemPlugin {
        public String getScheme() {
            return TestFileSystem.SCHEME;
        }

        public FileSystem create(URI fsUri, Configuration configuration) throws IOException {
            return new TestFileSystem();
        }
    }

    private static final class TestOutputStream
    extends FSDataOutputStream {
        private final LocalDataOutputStream stream;
        private final FsPath path;

        private TestOutputStream(LocalDataOutputStream stream, FsPath path) {
            this.stream = stream;
            this.path = path;
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void close() throws IOException {
            currentUnclosedOutputStream.compute(this.path, (k, v) -> (Integer)Preconditions.checkNotNull((Object)v) == 1 ? null : Integer.valueOf(v - 1));
            this.stream.close();
        }
    }
}

