/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.fs.local;

import com.alibaba.fluss.fs.FSDataInputStream;
import com.alibaba.fluss.fs.FSDataOutputStream;
import com.alibaba.fluss.fs.FileStatus;
import com.alibaba.fluss.fs.FileSystem;
import com.alibaba.fluss.fs.FsPath;
import com.alibaba.fluss.fs.local.LocalFileStatus;
import com.alibaba.fluss.fs.local.LocalFileSystem;
import com.alibaba.fluss.utils.ExecutorUtils;
import com.alibaba.fluss.utils.function.ThrowingConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class LocalFileSystemTest {
    @TempDir
    private Path temporaryFolder;

    LocalFileSystemTest() {
    }

    @Test
    void testLocalFilesystem() throws Exception {
        File tempdir = new File(this.temporaryFolder.toString(), UUID.randomUUID().toString());
        File testfile1 = new File(tempdir, UUID.randomUUID().toString());
        File testfile2 = new File(tempdir, UUID.randomUUID().toString());
        FsPath pathtotestfile1 = new FsPath(testfile1.toURI().getPath());
        FsPath pathtotestfile2 = new FsPath(testfile2.toURI().getPath());
        LocalFileSystem lfs = new LocalFileSystem();
        FsPath pathtotmpdir = new FsPath(tempdir.toURI().getPath());
        Assertions.assertThat((boolean)lfs.exists(pathtotmpdir)).isFalse();
        Assertions.assertThat((boolean)tempdir.mkdirs()).isTrue();
        Assertions.assertThat((boolean)lfs.exists(pathtotmpdir)).isTrue();
        FileStatus localstatus1 = lfs.getFileStatus(pathtotmpdir);
        Assertions.assertThat((boolean)localstatus1.isDir()).isTrue();
        FsPath expectedPath = new LocalFileStatus(new File(pathtotmpdir.getPath()), (FileSystem)lfs).getPath();
        Assertions.assertThat((Object)localstatus1.getPath()).isEqualTo((Object)expectedPath);
        FileStatus[] statusforfiles = lfs.listStatus(pathtotmpdir);
        Assertions.assertThat((int)statusforfiles.length).isEqualTo(0);
        lfs.delete(pathtotmpdir, true);
        Assertions.assertThat((boolean)lfs.exists(pathtotmpdir)).isFalse();
        Assertions.assertThat((boolean)tempdir.exists()).isFalse();
        lfs.mkdirs(pathtotmpdir);
        Assertions.assertThat((boolean)tempdir.exists()).isTrue();
        FSDataOutputStream lfsoutput1 = lfs.create(pathtotestfile1, FileSystem.WriteMode.NO_OVERWRITE);
        Assertions.assertThat((boolean)testfile2.createNewFile()).isTrue();
        Assertions.assertThat((boolean)testfile1.exists()).isTrue();
        Assertions.assertThat((boolean)lfs.exists(pathtotestfile2)).isTrue();
        byte[] testbytes = new byte[]{1, 2, 3, 4, 5};
        lfsoutput1.write(testbytes);
        lfsoutput1.close();
        Assertions.assertThat((long)5L).isEqualTo(testfile1.length());
        byte[] testbytestest = new byte[5];
        try (FileInputStream fisfile1 = new FileInputStream(testfile1);){
            Assertions.assertThat((int)fisfile1.read(testbytestest)).isEqualTo(testbytestest.length);
        }
        Assertions.assertThat((byte[])testbytestest).isEqualTo((Object)testbytes);
        Assertions.assertThat((long)testfile1.length()).isEqualTo(lfs.getFileStatus(pathtotestfile1).getLen());
        Assertions.assertThat((long)testfile1.length()).isEqualTo(lfs.listStatus(pathtotestfile1)[0].getLen());
        FileOutputStream fosfile2 = new FileOutputStream(testfile2);
        fosfile2.write(testbytes);
        fosfile2.close();
        testbytestest = new byte[5];
        FSDataInputStream lfsinput2 = lfs.open(pathtotestfile2);
        Assertions.assertThat((int)5).isEqualTo(lfsinput2.read(testbytestest));
        lfsinput2.close();
        Assertions.assertThat((byte[])testbytestest).isEqualTo((Object)testbytes);
        Assertions.assertThat((int)2).isEqualTo(lfs.listStatus(pathtotmpdir).length);
        Assertions.assertThat((boolean)lfs.delete(pathtotestfile1, false)).isTrue();
        Assertions.assertThat((boolean)lfs.delete(pathtotmpdir, true)).isTrue();
        Assertions.assertThat((boolean)tempdir.exists()).isFalse();
    }

    @Test
    void testRenamePath() throws IOException {
        File rootDirectory = this.temporaryFolder.toFile();
        File srcDirectory = new File(new File(rootDirectory, "src"), "B");
        Assertions.assertThat((boolean)srcDirectory.mkdirs()).isTrue();
        File srcFile = new File(srcDirectory, "test.csv");
        Assertions.assertThat((boolean)srcFile.createNewFile()).isTrue();
        File destDirectory = new File(new File(rootDirectory, "dst"), "B");
        File destFile = new File(destDirectory, "test.csv");
        FsPath srcDirPath = new FsPath(srcDirectory.toURI());
        FsPath srcFilePath = new FsPath(srcFile.toURI());
        FsPath destDirPath = new FsPath(destDirectory.toURI());
        FsPath destFilePath = new FsPath(destFile.toURI());
        FileSystem fs = FileSystem.get((URI)LocalFileSystem.getLocalFsURI());
        Assertions.assertThat((boolean)fs.exists(srcDirPath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(destDirPath)).isFalse();
        Assertions.assertThat((boolean)fs.rename(srcDirPath, destDirPath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(destFilePath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(srcDirPath)).isFalse();
        Assertions.assertThat((boolean)srcDirectory.mkdirs()).isTrue();
        Assertions.assertThat((boolean)srcFile.createNewFile()).isTrue();
        Assertions.assertThat((boolean)fs.rename(srcFilePath, destFilePath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(srcFilePath)).isFalse();
        Assertions.assertThat((boolean)fs.exists(srcDirPath)).isTrue();
        Assertions.assertThat((boolean)fs.exists(destFilePath)).isTrue();
    }

    @Test
    void testRenameNonExistingFile() throws IOException {
        FileSystem fs = FileSystem.get((URI)LocalFileSystem.getLocalFsURI());
        File srcFile = new File(this.temporaryFolder.toString(), "someFile.txt");
        File destFile = new File(this.temporaryFolder.toString(), "target");
        FsPath srcFilePath = new FsPath(srcFile.toURI());
        FsPath destFilePath = new FsPath(destFile.toURI());
        Assertions.assertThat((boolean)fs.rename(srcFilePath, destFilePath)).isFalse();
    }

    @Test
    void testRenameToNonEmptyTargetDir() throws IOException {
        FileSystem fs = FileSystem.get((URI)LocalFileSystem.getLocalFsURI());
        File srcFolder = Files.createTempDirectory(this.temporaryFolder, UUID.randomUUID().toString(), new FileAttribute[0]).toFile();
        File srcFile = new File(srcFolder, "someFile.txt");
        Assertions.assertThat((boolean)srcFile.createNewFile()).isTrue();
        File dstFolder = Files.createTempDirectory(this.temporaryFolder, UUID.randomUUID().toString(), new FileAttribute[0]).toFile();
        File dstFile = new File(dstFolder, "target");
        Assertions.assertThat((boolean)dstFile.createNewFile()).isTrue();
        Assertions.assertThat((boolean)fs.rename(new FsPath(srcFolder.toURI()), new FsPath(dstFolder.toURI()))).isFalse();
        Assertions.assertThat((boolean)dstFile.delete()).isTrue();
        Assertions.assertThat((boolean)fs.rename(new FsPath(srcFolder.toURI()), new FsPath(dstFolder.toURI()))).isTrue();
        Assertions.assertThat((boolean)new File(dstFolder, srcFile.getName()).exists()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConcurrentMkdirs() throws Exception {
        FileSystem fs = FileSystem.get((URI)LocalFileSystem.getLocalFsURI());
        File root = this.temporaryFolder.toFile();
        int directoryDepth = 10;
        int concurrentOperations = 10;
        Collection<File> targetDirectories = this.createTargetDirectories(root, 10, 10);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        CyclicBarrier cyclicBarrier = new CyclicBarrier(10);
        try {
            ArrayList<CompletableFuture<Void>> mkdirsFutures = new ArrayList<CompletableFuture<Void>>(10);
            for (File targetDirectory : targetDirectories) {
                CompletableFuture<Void> mkdirsFuture = CompletableFuture.runAsync(() -> {
                    try {
                        cyclicBarrier.await();
                        Assertions.assertThat((boolean)fs.mkdirs(FsPath.fromLocalFile((File)targetDirectory))).isTrue();
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }, executor);
                mkdirsFutures.add(mkdirsFuture);
            }
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(mkdirsFutures.toArray(new CompletableFuture[10]));
            allFutures.get();
            long timeout = 10000L;
        }
        catch (Throwable throwable) {
            long timeout = 10000L;
            ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCreatingFileInCurrentDirectoryWithRelativePath() throws IOException {
        FileSystem fs = FileSystem.get((URI)LocalFileSystem.getLocalFsURI());
        FsPath filePath = new FsPath("local_fs_test_" + UUID.randomUUID());
        try {
            FSDataOutputStream outputStream = fs.create(filePath, FileSystem.WriteMode.OVERWRITE);
            Throwable throwable = null;
            if (outputStream != null) {
                if (throwable != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    outputStream.close();
                }
            }
        }
        finally {
            for (int i = 0; i < 10 && fs.exists(filePath); ++i) {
                fs.delete(filePath, true);
            }
        }
    }

    @Test
    void testFlushMethodFailsOnClosedOutputStream() throws IOException {
        Assertions.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)FSDataOutputStream::flush)));
    }

    @Test
    void testWriteIntegerMethodFailsOnClosedOutputStream() throws IOException {
        Assertions.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(0))));
    }

    @Test
    void testWriteBytesMethodFailsOnClosedOutputStream() throws IOException {
        Assertions.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(new byte[0]))));
    }

    @Test
    void testWriteBytesSubArrayMethodFailsOnClosedOutputStream() throws IOException {
        Assertions.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(new byte[0], 0, 0))));
    }

    @Test
    void testGetPosMethodFailsOnClosedOutputStream() throws IOException {
        Assertions.assertThatExceptionOfType(ClosedChannelException.class).isThrownBy(() -> this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)FSDataOutputStream::getPos)));
    }

    private void testMethodCallFailureOnClosedStream(ThrowingConsumer<FSDataOutputStream, IOException> callback) throws IOException {
        FileSystem fs = FileSystem.get((URI)LocalFileSystem.getLocalFsURI());
        FSDataOutputStream outputStream = fs.create(new FsPath(this.temporaryFolder.toString(), "close_fs_test_" + UUID.randomUUID()), FileSystem.WriteMode.OVERWRITE);
        outputStream.close();
        callback.accept((Object)outputStream);
    }

    private Collection<File> createTargetDirectories(File root, int directoryDepth, int numberDirectories) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < directoryDepth; ++i) {
            stringBuilder.append('/').append(i);
        }
        ArrayList<File> targetDirectories = new ArrayList<File>(numberDirectories);
        for (int i = 0; i < numberDirectories; ++i) {
            targetDirectories.add(new File(root, stringBuilder.toString() + '/' + i));
        }
        return targetDirectories;
    }
}

