/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.fs.token;

import com.alibaba.fluss.fs.token.Credentials;
import com.alibaba.fluss.fs.token.CredentialsJsonSerde;
import com.alibaba.fluss.utils.json.JsonSerdeTestBase;
import org.assertj.core.api.Assertions;

class CredentialsJsonSerdeTest
extends JsonSerdeTestBase<Credentials> {
    CredentialsJsonSerdeTest() {
        super(CredentialsJsonSerde.INSTANCE);
    }

    protected Credentials[] createObjects() {
        Credentials credentials1 = new Credentials("myrandomaccessid111", "myrandomaccesssecret111", "myrandomsecuritytoken");
        Credentials credentials2 = new Credentials("myrandomaccessid222", "myrandomaccesssecret222", "myrandomsecuritytoken222");
        return new Credentials[]{credentials1, credentials2};
    }

    @Override
    protected String[] expectedJsons() {
        return new String[]{"{\"version\":1,\"access_key_id\":\"myrandomaccessid111\",\"access_key_secret\":\"myrandomaccesssecret111\",\"security_token\":\"myrandomsecuritytoken\"}", "{\"version\":1,\"access_key_id\":\"myrandomaccessid222\",\"access_key_secret\":\"myrandomaccesssecret222\",\"security_token\":\"myrandomsecuritytoken222\"}"};
    }

    @Override
    protected void assertEquals(Credentials actual, Credentials expected) {
        Assertions.assertThat((String)actual.getAccessKeyId()).isEqualTo(expected.getAccessKeyId());
        Assertions.assertThat((String)actual.getSecretAccessKey()).isEqualTo(expected.getSecretAccessKey());
        Assertions.assertThat((String)actual.getSecurityToken()).isEqualTo(expected.getSecurityToken());
    }
}

