/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.memory;

import com.alibaba.fluss.memory.MemorySegment;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

public class EndiannessAccessChecksTest {
    @Test
    public void testOnHeapSegment() {
        this.testBigAndLittleEndianAccessUnaligned(MemorySegment.allocateHeapMemory((int)11111));
    }

    @Test
    public void testOffHeapSegment() {
        this.testBigAndLittleEndianAccessUnaligned(MemorySegment.allocateOffHeapMemory((int)11111));
    }

    private void testBigAndLittleEndianAccessUnaligned(MemorySegment segment) {
        int pos;
        int i;
        Random rnd = new Random();
        long seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            long val = rnd.nextLong();
            int n = rnd.nextInt(segment.size() - 7);
            segment.putLong(n, val);
            long r2 = segment.getLongBigEndian(n);
            Assertions.assertThat((long)Long.reverseBytes(r2)).isEqualTo(val);
            segment.putLongBigEndian(n, val);
            r2 = segment.getLong(n);
            Assertions.assertThat((long)Long.reverseBytes(r2)).isEqualTo(val);
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            int val = rnd.nextInt();
            pos = rnd.nextInt(segment.size() - 3);
            segment.putInt(pos, val);
            int n = segment.getIntBigEndian(pos);
            Assertions.assertThat((int)Integer.reverseBytes(n)).isEqualTo(val);
            segment.putIntBigEndian(pos, val);
            n = segment.getInt(pos);
            Assertions.assertThat((int)Integer.reverseBytes(n)).isEqualTo(val);
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            short val = (short)rnd.nextInt();
            pos = rnd.nextInt(segment.size() - 1);
            segment.putShort(pos, val);
            short s = segment.getShortBigEndian(pos);
            Assertions.assertThat((short)Short.reverseBytes(s)).isEqualTo(val);
            segment.putShortBigEndian(pos, val);
            s = segment.getShort(pos);
            Assertions.assertThat((short)Short.reverseBytes(s)).isEqualTo(val);
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            char val = (char)rnd.nextInt();
            pos = rnd.nextInt(segment.size() - 1);
            segment.putChar(pos, val);
            char c = segment.getCharBigEndian(pos);
            Assertions.assertThat((char)Character.reverseBytes(c)).isEqualTo(val);
            segment.putCharBigEndian(pos, val);
            c = segment.getChar(pos);
            Assertions.assertThat((char)Character.reverseBytes(c)).isEqualTo(val);
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            float val = rnd.nextFloat();
            pos = rnd.nextInt(segment.size() - 3);
            segment.putFloat(pos, val);
            float f = segment.getFloatBigEndian(pos);
            float reversed = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(f)));
            Assertions.assertThat((float)reversed).isCloseTo(val, Offset.offset((Number)Float.valueOf(0.0f)));
            segment.putFloatBigEndian(pos, val);
            f = segment.getFloat(pos);
            reversed = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(f)));
            Assertions.assertThat((float)reversed).isCloseTo(val, Offset.offset((Number)Float.valueOf(0.0f)));
        }
        seed = rnd.nextLong();
        rnd.setSeed(seed);
        for (i = 0; i < 10000; ++i) {
            double val = rnd.nextDouble();
            int n = rnd.nextInt(segment.size() - 7);
            segment.putDouble(n, val);
            double r4 = segment.getDoubleBigEndian(n);
            double reversed = Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(r4)));
            Assertions.assertThat((double)reversed).isCloseTo(val, Offset.offset((Number)0.0));
            segment.putDoubleBigEndian(n, val);
            r4 = segment.getDouble(n);
            reversed = Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(r4)));
            Assertions.assertThat((double)reversed).isCloseTo(val, Offset.offset((Number)0.0));
        }
    }
}

