/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.memory;

import com.alibaba.fluss.memory.LazyMemorySegmentPool;
import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.utils.function.ThrowingRunnable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class LazyMemorySegmentPoolTest {
    @Test
    void testNextSegmentWaiter() throws InterruptedException {
        LazyMemorySegmentPool source = this.buildLazyMemorySegmentSource(10, 10);
        Assertions.assertThat((int)source.pageSize()).isEqualTo(10);
        Assertions.assertThat((int)source.freePages()).isEqualTo(10);
        MemorySegment ms1 = source.nextSegment(true);
        Assertions.assertThat((int)source.freePages()).isEqualTo(9);
        MemorySegment ms2 = source.nextSegment(true);
        Assertions.assertThat((int)source.freePages()).isEqualTo(8);
        for (int i = 0; i < 8; ++i) {
            source.nextSegment(true);
        }
        Assertions.assertThat((int)source.freePages()).isEqualTo(0);
        Assertions.assertThat((Object)source.nextSegment(false)).isNull();
        CountDownLatch returnAllLatch = this.asyncReturnAll(source, Arrays.asList(ms1, ms2));
        CountDownLatch getNextSegmentLatch = this.asyncGetNextSegment(source);
        Assertions.assertThat((long)getNextSegmentLatch.getCount()).isEqualTo(1L);
        returnAllLatch.countDown();
        Assertions.assertThat((boolean)getNextSegmentLatch.await(Long.MAX_VALUE, TimeUnit.SECONDS)).isTrue();
    }

    @Test
    void testIllegalArgument() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildLazyMemorySegmentSource(0, 10)).isInstanceOf(IllegalArgumentException.class)).hasMessage("MaxPages for LazyMemorySegmentPool should be greater than 0.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildLazyMemorySegmentSource(10, 0x2000000)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Page size should be less than PER_REQUEST_MEMORY_SIZE. Page size is: 32768 KB, PER_REQUEST_MEMORY_SIZE is 16384 KB.");
        LazyMemorySegmentPool lazyMemorySegmentPool = this.buildLazyMemorySegmentSource(10, 10);
        Assertions.assertThatThrownBy(() -> lazyMemorySegmentPool.returnAll(Arrays.asList(MemorySegment.allocateHeapMemory((int)10), MemorySegment.allocateHeapMemory((int)10)))).hasMessage("Return too more memories.");
    }

    private LazyMemorySegmentPool buildLazyMemorySegmentSource(int maxPages, int pageSize) {
        return new LazyMemorySegmentPool(maxPages, pageSize, Long.MAX_VALUE);
    }

    private CountDownLatch asyncReturnAll(LazyMemorySegmentPool source, List<MemorySegment> segments) {
        CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(ThrowingRunnable.unchecked(() -> {
            latch.await();
            source.returnAll(segments);
        }));
        thread.start();
        return latch;
    }

    private CountDownLatch asyncGetNextSegment(LazyMemorySegmentPool source) {
        CountDownLatch completed = new CountDownLatch(1);
        Thread thread = new Thread(() -> {
            try {
                source.nextSegment(true);
            }
            finally {
                completed.countDown();
            }
        });
        thread.start();
        return completed;
    }
}

