/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.memory;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.testutils.junit.parameterized.Parameters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public abstract class MemorySegmentTestBase {
    private final Random random = new Random();
    private final int pageSize;
    protected MemorySegment segment = null;

    MemorySegmentTestBase(int pageSize) {
        this.pageSize = pageSize;
    }

    abstract MemorySegment createSegment(int var1);

    @BeforeEach
    public void before() {
        this.segment = this.createSegment(this.pageSize);
    }

    @TestTemplate
    public void testByteAccess() {
        int pos;
        int i;
        int i2;
        Assertions.assertThatThrownBy(() -> this.segment.put(-1, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(this.pageSize, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(Integer.MAX_VALUE, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(Integer.MIN_VALUE, (byte)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 < this.pageSize; ++i2) {
            this.segment.put(i2, (byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 < this.pageSize; ++i2) {
            Assertions.assertThat((byte)((byte)this.random.nextInt())).isEqualTo(this.segment.get(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            this.segment.put(pos, (byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            Assertions.assertThat((byte)((byte)this.random.nextInt())).isEqualTo(this.segment.get(pos));
        }
    }

    @TestTemplate
    public void testBooleanAccess() {
        int pos;
        int i;
        int i2;
        Assertions.assertThatThrownBy(() -> this.segment.putBoolean(-1, false)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putBoolean(this.pageSize, false)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putBoolean(Integer.MAX_VALUE, false)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putBoolean(Integer.MIN_VALUE, false)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getBoolean(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getBoolean(this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getBoolean(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getBoolean(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 < this.pageSize; ++i2) {
            this.segment.putBoolean(i2, this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 < this.pageSize; ++i2) {
            Assertions.assertThat((boolean)this.random.nextBoolean()).isEqualTo(this.segment.getBoolean(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            this.segment.putBoolean(pos, this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            Assertions.assertThat((boolean)this.random.nextBoolean()).isEqualTo(this.segment.getBoolean(pos));
        }
    }

    @TestTemplate
    public void testCharAccess() {
        int pos;
        int i;
        int i2;
        Assertions.assertThatThrownBy(() -> this.segment.putShortNativeEndian(-1, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putShortNativeEndian(this.pageSize, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putShortNativeEndian(Integer.MAX_VALUE, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putShortNativeEndian(Integer.MIN_VALUE, (short)0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getShortNativeEndian(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getShortNativeEndian(this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getShortNativeEndian(Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getShortNativeEndian(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 2; i2 += 2) {
            this.segment.putShortNativeEndian(i2, (short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 2; i2 += 2) {
            Assertions.assertThat((short)((short)this.random.nextInt())).isEqualTo(this.segment.getShortNativeEndian(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            this.segment.putShortNativeEndian(pos, (short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            Assertions.assertThat((short)((short)this.random.nextInt())).isEqualTo(this.segment.getShortNativeEndian(pos));
        }
    }

    @TestTemplate
    public void testIntAccess() {
        int pos;
        int i;
        int i2;
        Assertions.assertThatThrownBy(() -> this.segment.putIntNativeEndian(-1, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putIntNativeEndian(this.pageSize, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putIntNativeEndian(0x7FFFFFFC, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putIntNativeEndian(Integer.MIN_VALUE, 0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getIntNativeEndian(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getIntNativeEndian(this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getIntNativeEndian(0x7FFFFFFC)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getIntNativeEndian(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 4; i2 += 4) {
            this.segment.putIntNativeEndian(i2, this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 4; i2 += 4) {
            Assertions.assertThat((int)this.random.nextInt()).isEqualTo(this.segment.getIntNativeEndian(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            this.segment.putIntNativeEndian(pos, this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            Assertions.assertThat((int)this.random.nextInt()).isEqualTo(this.segment.getIntNativeEndian(pos));
        }
    }

    @TestTemplate
    public void testLongAccess() {
        int pos;
        int i;
        int i2;
        Assertions.assertThatThrownBy(() -> this.segment.putLongNativeEndian(-1, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putLongNativeEndian(this.pageSize, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putLongNativeEndian(0x7FFFFFF8, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putLongNativeEndian(Integer.MIN_VALUE, 0L)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getLongNativeEndian(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getLongNativeEndian(this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getLongNativeEndian(0x7FFFFFF8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getLongNativeEndian(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 8; i2 += 8) {
            this.segment.putLongNativeEndian(i2, this.random.nextLong());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 8; i2 += 8) {
            Assertions.assertThat((long)this.random.nextLong()).isEqualTo(this.segment.getLongNativeEndian(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            this.segment.putLongNativeEndian(pos, this.random.nextLong());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            Assertions.assertThat((long)this.random.nextLong()).isEqualTo(this.segment.getLongNativeEndian(pos));
        }
    }

    @TestTemplate
    public void testFloatAccess() {
        int pos;
        int i;
        int i2;
        Assertions.assertThatThrownBy(() -> this.segment.putFloatNativeEndian(-1, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putFloatNativeEndian(this.pageSize, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putFloatNativeEndian(0x7FFFFFFC, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putFloatNativeEndian(Integer.MIN_VALUE, 0.0f)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getFloatNativeEndian(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getFloatNativeEndian(this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getFloatNativeEndian(0x7FFFFFFC)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getFloatNativeEndian(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 4; i2 += 4) {
            this.segment.putFloatNativeEndian(i2, this.random.nextFloat());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 4; i2 += 4) {
            Assertions.assertThat((float)this.random.nextFloat()).isCloseTo(this.segment.getFloatNativeEndian(i2), Offset.offset((Number)Float.valueOf(Float.parseFloat("0.0"))));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            this.segment.putFloatNativeEndian(pos, this.random.nextFloat());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            Assertions.assertThat((float)this.random.nextFloat()).isCloseTo(this.segment.getFloatNativeEndian(pos), Offset.offset((Number)Float.valueOf(Float.parseFloat("0.0"))));
        }
    }

    @TestTemplate
    public void testDoubleAccess() {
        int pos;
        int i;
        int i2;
        Assertions.assertThatThrownBy(() -> this.segment.putDoubleNativeEndian(-1, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putDoubleNativeEndian(this.pageSize, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putDoubleNativeEndian(0x7FFFFFF8, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.putDoubleNativeEndian(Integer.MIN_VALUE, 0.0)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getDoubleNativeEndian(-1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getDoubleNativeEndian(this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getDoubleNativeEndian(0x7FFFFFF8)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.getDoubleNativeEndian(Integer.MIN_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 8; i2 += 8) {
            this.segment.putDoubleNativeEndian(i2, this.random.nextDouble());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 8; i2 += 8) {
            Assertions.assertThat((double)this.random.nextDouble()).isCloseTo(this.segment.getDoubleNativeEndian(i2), Offset.offset((Number)0.0));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            this.segment.putDoubleNativeEndian(pos, this.random.nextDouble());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            Assertions.assertThat((double)this.random.nextDouble()).isCloseTo(this.segment.getDoubleNativeEndian(pos), Offset.offset((Number)0.0));
        }
    }

    @TestTemplate
    public void testEqualTo() {
        MemorySegment seg1 = this.createSegment(this.pageSize);
        MemorySegment seg2 = this.createSegment(this.pageSize);
        byte[] referenceArray = new byte[this.pageSize];
        seg1.put(0, referenceArray);
        seg2.put(0, referenceArray);
        int i = new Random().nextInt(this.pageSize - 8);
        seg1.put(i, (byte)10);
        Assertions.assertThat((boolean)seg1.equalTo(seg2, i, i, 9)).isFalse();
        seg1.put(i, (byte)0);
        Assertions.assertThat((boolean)seg1.equalTo(seg2, i, i, 9)).isTrue();
        seg1.put(i + 8, (byte)10);
        Assertions.assertThat((boolean)seg1.equalTo(seg2, i, i, 9)).isFalse();
    }

    @TestTemplate
    public void testCopyUnsafeIndexOutOfBounds() {
        byte[] bytes = new byte[this.pageSize];
        Assertions.assertThatThrownBy(() -> this.segment.copyToUnsafe(1, (Object)bytes, 0, this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.copyFromUnsafe(1, (Object)bytes, 0, this.pageSize)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @TestTemplate
    public void testBulkBytePutExceptions() {
        byte[] bytes = new byte[this.pageSize / 4 + this.pageSize % 4];
        this.random.nextBytes(bytes);
        Assertions.assertThatThrownBy(() -> this.segment.put(-1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(-1, bytes, 4, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(Integer.MIN_VALUE, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(this.pageSize, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(this.pageSize, bytes, 6, 44)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(this.pageSize, bytes, 6, 44)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(this.pageSize - bytes.length + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(this.pageSize - 5, bytes, 3, 6)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(Integer.MAX_VALUE, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(Integer.MAX_VALUE, bytes, 10, 20)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(Integer.MAX_VALUE - bytes.length + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(0x7FFFFFF4, bytes, 11, 11)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(3 * (this.pageSize / 4) + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(3 * (this.pageSize / 4) + 2, bytes, 0, bytes.length - 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(7 * (this.pageSize / 8) + 1, bytes, 0, bytes.length / 2)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(0, bytes, -1, 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(0, bytes, -1, bytes.length + 1)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(0, bytes, Integer.MIN_VALUE, bytes.length)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.put(-2, bytes, -1, bytes.length / 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @TestTemplate
    public void testBulkByteGetExceptions() {
        byte[] bytes = new byte[this.pageSize / 4];
        Assertions.assertThatThrownBy(() -> this.segment.get(-1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(-1, bytes, 4, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(Integer.MIN_VALUE, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(Integer.MIN_VALUE, bytes, 4, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(this.pageSize, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(this.pageSize, bytes, 6, 44)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(this.pageSize - bytes.length + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(this.pageSize - 5, bytes, 3, 6)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(Integer.MAX_VALUE, bytes, 10, 20)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(Integer.MAX_VALUE - bytes.length + 1, bytes)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(0x7FFFFFF4, bytes, 11, 11)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> this.segment.get(-2, bytes, -1, bytes.length / 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @TestTemplate
    public void testBulkByteAccess() {
        int i;
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        byte[] src = new byte[this.pageSize / 8];
        for (int i2 = 0; i2 < 8; ++i2) {
            this.random.nextBytes(src);
            this.segment.put(i2 * (this.pageSize / 8), src);
        }
        this.random.setSeed(seed);
        byte[] expected = new byte[this.pageSize / 8];
        byte[] actual = new byte[this.pageSize / 8];
        for (i = 0; i < 8; ++i) {
            this.random.nextBytes(expected);
            this.segment.get(i * (this.pageSize / 8), actual);
            Assertions.assertThat((byte[])actual).isEqualTo((Object)expected);
        }
        expected = new byte[this.pageSize];
        this.random.nextBytes(expected);
        for (i = 0; i < 16; ++i) {
            this.segment.put(i * (this.pageSize / 16), expected, i * (this.pageSize / 16), this.pageSize / 16);
        }
        actual = new byte[this.pageSize];
        for (i = 0; i < 16; ++i) {
            this.segment.get(i * (this.pageSize / 16), actual, i * (this.pageSize / 16), this.pageSize / 16);
        }
        Assertions.assertThat((byte[])actual).isEqualTo((Object)expected);
        expected = new byte[this.pageSize];
        this.segment.put(0, expected, 0, this.pageSize);
        for (i = 0; i < 200; ++i) {
            int numBytes = this.random.nextInt(this.pageSize - 10) + 1;
            int pos = this.random.nextInt(this.pageSize - numBytes + 1);
            byte[] data = new byte[(this.random.nextInt(3) + 1) * numBytes];
            int dataStartPos = this.random.nextInt(data.length - numBytes + 1);
            this.random.nextBytes(data);
            System.arraycopy(data, dataStartPos, expected, pos, numBytes);
            this.segment.put(pos, data, dataStartPos, numBytes);
        }
        byte[] validation = new byte[this.pageSize];
        this.segment.get(0, validation);
        Assertions.assertThat((byte[])validation).isEqualTo((Object)expected);
        byte[] contents = new byte[this.pageSize];
        this.random.nextBytes(contents);
        this.segment.put(0, contents);
        for (int i3 = 0; i3 < 200; ++i3) {
            int numBytes = this.random.nextInt(this.pageSize / 8) + 1;
            int pos = this.random.nextInt(this.pageSize - numBytes + 1);
            byte[] data = new byte[(this.random.nextInt(3) + 1) * numBytes];
            int dataStartPos = this.random.nextInt(data.length - numBytes + 1);
            this.segment.get(pos, data, dataStartPos, numBytes);
            expected = Arrays.copyOfRange(contents, pos, pos + numBytes);
            validation = Arrays.copyOfRange(data, dataStartPos, dataStartPos + numBytes);
            Assertions.assertThat((byte[])validation).isEqualTo((Object)expected);
        }
    }

    @TestTemplate
    public void testDataInputOutput() throws IOException {
        int len;
        int pos;
        int len2;
        byte[] contents = new byte[this.pageSize];
        this.random.nextBytes(contents);
        this.segment.put(0, contents);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.pageSize);
        DataOutputStream out = new DataOutputStream(buffer);
        for (pos = 0; pos < this.pageSize; pos += len2) {
            len2 = this.random.nextInt(200);
            len2 = Math.min(len2, this.pageSize - pos);
            this.segment.get((DataOutput)out, pos, len2);
        }
        byte[] result = buffer.toByteArray();
        Assertions.assertThat((byte[])result).isEqualTo((Object)contents);
        MemorySegment reader = this.createSegment(this.pageSize);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(result));
        for (pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(200);
            len = Math.min(len, this.pageSize - pos);
            reader.put((DataInput)in, pos, len);
        }
        byte[] targetBuffer = new byte[this.pageSize];
        reader.get(0, targetBuffer);
        Assertions.assertThat((byte[])targetBuffer).isEqualTo((Object)contents);
    }

    @TestTemplate
    public void testDataInputOutputOutOfBounds() {
        int segmentSize = 52;
        MemorySegment seg = this.createSegment(52);
        byte[] bytes = new byte[52];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        DataOutputStream out = new DataOutputStream(new ByteArrayOutputStream());
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, -1, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, 52, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, -52, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, Integer.MIN_VALUE, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.get((DataOutput)out, Integer.MAX_VALUE, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(new byte[52]));
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, -1, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, 52, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, -52, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, Integer.MIN_VALUE, 26)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> seg.put((DataInput)in, Integer.MAX_VALUE, 26)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @TestTemplate
    public void testDataInputOutputStreamUnderflowOverflow() {
        int segmentSize = 1337;
        MemorySegment seg = this.createSegment(1337);
        byte[] bytes = new byte[1337];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        DataOutputStream out = new DataOutputStream(new OutputStream(){
            int bytesSoFar = 0;

            @Override
            public void write(int b) throws IOException {
                ++this.bytesSoFar;
                if (this.bytesSoFar > 668) {
                    throw new IOException("overflow");
                }
            }
        });
        Assertions.assertThatThrownBy(() -> {
            int len;
            for (int pos = 0; pos < this.pageSize; pos += len) {
                len = this.random.nextInt(133);
                len = Math.min(len, this.pageSize - pos);
                seg.get((DataOutput)out, pos, len);
            }
        }).isInstanceOf(IOException.class);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(new byte[668]));
        Assertions.assertThatThrownBy(() -> {
            int len;
            for (int pos = 0; pos < this.pageSize; pos += len) {
                len = this.random.nextInt(133);
                len = Math.min(len, this.pageSize - pos);
                seg.put((DataInput)in, pos, len);
            }
        }).isInstanceOf(IOException.class);
    }

    @TestTemplate
    public void testGetByteBuffer() {
        this.testByteBufferGet(false);
        this.testByteBufferGet(true);
    }

    @TestTemplate
    public void testByteBufferGetReadOnly() {
        Assertions.assertThatThrownBy(() -> this.testByteBufferGetReadOnly(false)).isInstanceOf(ReadOnlyBufferException.class);
        Assertions.assertThatThrownBy(() -> this.testByteBufferGetReadOnly(true)).isInstanceOf(ReadOnlyBufferException.class);
    }

    @TestTemplate
    public void testByteBufferPut() {
        this.testByteBufferPut(false);
        this.testByteBufferPut(true);
    }

    @TestTemplate
    public void testSlicedByteBufferGet() {
        this.testSlicedByteBufferGet(false);
        this.testSlicedByteBufferGet(true);
    }

    @TestTemplate
    public void testSlicedByteBufferPut() {
        this.testSlicedByteBufferPut(false);
        this.testSlicedByteBufferPut(true);
    }

    @TestTemplate
    public void testByteBufferOutOfBounds() {
        int bbCapacity = this.pageSize / 10;
        int[] validOffsets = new int[]{0, 1, this.pageSize / 10 * 9};
        int[] invalidOffsets = new int[]{-1, this.pageSize + 1, -this.pageSize, Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] validLengths = new int[]{0, 1, bbCapacity, this.pageSize};
        int[] invalidLengths = new int[]{-1, -this.pageSize, Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (ByteBuffer bb : new ByteBuffer[]{ByteBuffer.allocate(bbCapacity), ByteBuffer.allocateDirect(bbCapacity)}) {
            for (int off : validOffsets) {
                for (int len : invalidLengths) {
                    Assertions.assertThatThrownBy(() -> this.segment.put(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferUnderflowException.class});
                    Assertions.assertThatThrownBy(() -> this.segment.get(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferOverflowException.class});
                    Assertions.assertThat((int)bb.position()).isEqualTo(0);
                    Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
                }
            }
            for (int off : invalidOffsets) {
                for (int len : validLengths) {
                    Assertions.assertThatThrownBy(() -> this.segment.put(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferUnderflowException.class});
                    Assertions.assertThatThrownBy(() -> this.segment.get(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferOverflowException.class});
                    Assertions.assertThat((int)bb.position()).isEqualTo(0);
                    Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
                }
            }
            for (int off : validOffsets) {
                for (int len : validLengths) {
                    if (off + len <= this.pageSize) continue;
                    Assertions.assertThatThrownBy(() -> this.segment.put(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferUnderflowException.class});
                    Assertions.assertThatThrownBy(() -> this.segment.get(off, bb, len)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, BufferOverflowException.class});
                    Assertions.assertThat((int)bb.position()).isEqualTo(0);
                    Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
                }
            }
        }
    }

    @TestTemplate
    public void testByteBufferOverflowUnderflow() {
        int bbCapacity = this.pageSize / 10;
        ByteBuffer bb = ByteBuffer.allocate(bbCapacity);
        Assertions.assertThatThrownBy(() -> this.segment.get(this.pageSize / 5, bb, this.pageSize / 10 + 2)).isInstanceOf(BufferOverflowException.class);
        Assertions.assertThat((int)bb.position()).isEqualTo(0);
        Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
        Assertions.assertThatThrownBy(() -> this.segment.put(this.pageSize / 5, bb, this.pageSize / 10 + 2)).isInstanceOf(BufferUnderflowException.class);
        Assertions.assertThat((int)bb.position()).isEqualTo(0);
        Assertions.assertThat((int)bb.limit()).isEqualTo(bb.capacity());
        int pos = bb.capacity() / 3;
        int limit = 2 * bb.capacity() / 3;
        bb.limit(limit);
        bb.position(pos);
        Assertions.assertThatThrownBy(() -> this.segment.get(20, bb, bb.capacity() / 3 + 3)).isInstanceOf(BufferOverflowException.class);
        Assertions.assertThat((int)bb.position()).isEqualTo(pos);
        Assertions.assertThat((int)bb.limit()).isEqualTo(limit);
        Assertions.assertThatThrownBy(() -> this.segment.put(20, bb, bb.capacity() / 3 + 3)).isInstanceOf(BufferUnderflowException.class);
        Assertions.assertThat((int)bb.position()).isEqualTo(pos);
        Assertions.assertThat((int)bb.limit()).isEqualTo(limit);
    }

    @TestTemplate
    public void testCompareBytes() {
        byte[] bytes1 = new byte[this.pageSize];
        byte[] bytes2 = new byte[this.pageSize];
        int stride = this.pageSize / 255;
        int shift = 16666;
        for (int i = 0; i < this.pageSize; ++i) {
            byte val;
            bytes1[i] = val = (byte)(i / stride & 0xFF);
            if (i + 16666 >= bytes2.length) continue;
            bytes2[i + 16666] = val;
        }
        MemorySegment seg1 = this.createSegment(this.pageSize);
        MemorySegment seg2 = this.createSegment(this.pageSize);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        for (int i = 0; i < 1000; ++i) {
            int pos1 = this.random.nextInt(bytes1.length);
            int pos2 = this.random.nextInt(bytes2.length);
            int len = Math.min(Math.min(bytes1.length - pos1, bytes2.length - pos2), this.random.nextInt(this.pageSize / 50));
            int cmp = seg1.compare(seg2, pos1, pos2, len);
            if (pos1 < pos2 - 16666) {
                Assertions.assertThat((cmp <= 0 ? 1 : 0) != 0).isTrue();
                continue;
            }
            Assertions.assertThat((cmp >= 0 ? 1 : 0) != 0).isTrue();
        }
    }

    @TestTemplate
    public void testCompareBytesWithDifferentLength() {
        byte[] bytes1 = new byte[]{97, 98, 99};
        byte[] bytes2 = new byte[]{97, 98, 99, 100};
        MemorySegment seg1 = this.createSegment(4);
        MemorySegment seg2 = this.createSegment(4);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        Assertions.assertThat((int)seg1.compare(seg2, 0, 0, 3, 4)).isLessThan(0);
        Assertions.assertThat((int)seg1.compare(seg2, 0, 0, 3, 3)).isEqualTo(0);
        Assertions.assertThat((int)seg1.compare(seg2, 0, 0, 3, 2)).isGreaterThan(0);
        Assertions.assertThat((int)seg1.compare(seg2, 1, 1, 2, 3)).isLessThan(0);
        Assertions.assertThat((int)seg1.compare(seg2, 1, 1, 2, 2)).isEqualTo(0);
        Assertions.assertThat((int)seg1.compare(seg2, 1, 1, 2, 1)).isGreaterThan(0);
    }

    @TestTemplate
    public void testSwapBytes() {
        int len;
        int halfPageSize = this.pageSize / 2;
        byte[] bytes1 = new byte[this.pageSize];
        byte[] bytes2 = new byte[halfPageSize];
        Arrays.fill(bytes2, (byte)1);
        MemorySegment seg1 = this.createSegment(this.pageSize);
        MemorySegment seg2 = this.createSegment(halfPageSize);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        for (int pos = 0; pos < halfPageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 40);
            len = Math.min(len, halfPageSize - pos);
            seg1.swapBytes(new byte[len], seg2, pos + halfPageSize, pos, len);
        }
        for (int i = 0; i < halfPageSize; ++i) {
            Assertions.assertThat((byte)seg1.get(i)).isEqualTo((byte)0);
            Assertions.assertThat((byte)seg2.get(i)).isEqualTo((byte)0);
            Assertions.assertThat((byte)seg1.get(i + halfPageSize)).isEqualTo((byte)1);
        }
    }

    @TestTemplate
    public void testByteBufferWrapping() {
        ByteBuffer buf1 = this.segment.wrap(13, 47);
        Assertions.assertThat((int)buf1.position()).isEqualTo(13);
        Assertions.assertThat((int)buf1.limit()).isEqualTo(60);
        Assertions.assertThat((int)buf1.remaining()).isEqualTo(47);
        ByteBuffer buf2 = this.segment.wrap(500, 267);
        Assertions.assertThat((int)buf2.position()).isEqualTo(500);
        Assertions.assertThat((int)buf2.limit()).isEqualTo(767);
        Assertions.assertThat((int)buf2.remaining()).isEqualTo(267);
        ByteBuffer buf3 = this.segment.wrap(0, 1024);
        Assertions.assertThat((int)buf3.position()).isEqualTo(0);
        Assertions.assertThat((int)buf3.limit()).isEqualTo(1024);
        Assertions.assertThat((int)buf3.remaining()).isEqualTo(1024);
        buf3.order(ByteOrder.LITTLE_ENDIAN);
        buf3.putInt(112, 651797651);
        Assertions.assertThat((int)this.segment.getInt(112)).isEqualTo(651797651);
        buf3.order(ByteOrder.BIG_ENDIAN);
        buf3.putInt(187, 992288337);
        Assertions.assertThat((int)this.segment.getIntBigEndian(187)).isEqualTo(992288337);
        Assertions.assertThatThrownBy(() -> this.segment.wrap(-1, 20)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, IllegalArgumentException.class});
        Assertions.assertThatThrownBy(() -> this.segment.wrap(10, -20)).isInstanceOfAny(new Class[]{IndexOutOfBoundsException.class, IllegalArgumentException.class});
        this.segment.free();
        Assertions.assertThatThrownBy(() -> this.segment.wrap(13, 47)).isInstanceOf(IllegalStateException.class);
        buf3.order(ByteOrder.LITTLE_ENDIAN);
        buf3.putInt(112, 651797651);
        Assertions.assertThat((int)buf3.getInt(112)).isEqualTo(651797651);
        buf3.order(ByteOrder.BIG_ENDIAN);
        buf3.putInt(187, 992288337);
        Assertions.assertThat((int)buf3.getInt(187)).isEqualTo(992288337);
    }

    @TestTemplate
    public void testSizeAndFreeing() {
        int segmentSize = 651;
        MemorySegment seg = this.createSegment(651);
        Assertions.assertThat((int)seg.size()).isEqualTo(651);
        Assertions.assertThat((boolean)seg.isFreed()).isFalse();
        seg.free();
        Assertions.assertThat((boolean)seg.isFreed()).isTrue();
        Assertions.assertThat((int)seg.size()).isEqualTo(651);
    }

    @AfterEach
    public void after() {
        if (!this.segment.isFreed()) {
            this.segment.free();
        }
    }

    private void testByteBufferGet(boolean directBuffer) {
        int len;
        MemorySegment seg = this.createSegment(this.pageSize);
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        ByteBuffer target = directBuffer ? ByteBuffer.allocateDirect(3 * this.pageSize) : ByteBuffer.allocate(3 * this.pageSize);
        target.position(2 * this.pageSize);
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.get(pos, target, len);
        }
        byte[] result = new byte[this.pageSize];
        target.position(2 * this.pageSize);
        target.get(result);
        Assertions.assertThat((byte[])result).isEqualTo((Object)bytes);
    }

    private void testByteBufferGetReadOnly(boolean directBuffer) throws ReadOnlyBufferException {
        MemorySegment seg = this.createSegment(this.pageSize);
        ByteBuffer target = (directBuffer ? ByteBuffer.allocateDirect(this.pageSize) : ByteBuffer.allocate(this.pageSize)).asReadOnlyBuffer();
        seg.get(0, target, this.pageSize);
    }

    private void testByteBufferPut(boolean directBuffer) {
        int len;
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        ByteBuffer source = directBuffer ? ByteBuffer.allocateDirect(this.pageSize) : ByteBuffer.allocate(this.pageSize);
        source.put(bytes);
        source.clear();
        MemorySegment seg = this.createSegment(3 * this.pageSize);
        int offset = 2 * this.pageSize;
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.put(offset + pos, source, len);
        }
        byte[] result = new byte[this.pageSize];
        seg.get(offset, result);
        Assertions.assertThat((byte[])result).isEqualTo((Object)bytes);
    }

    private void testSlicedByteBufferGet(boolean directBuffer) {
        int len;
        MemorySegment seg = this.createSegment(this.pageSize);
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        ByteBuffer target = directBuffer ? ByteBuffer.allocateDirect(this.pageSize + 49) : ByteBuffer.allocate(this.pageSize + 49);
        target.position(19).limit(19 + this.pageSize);
        ByteBuffer slicedTarget = target.slice();
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.get(pos, slicedTarget, len);
        }
        byte[] result = new byte[this.pageSize];
        target.position(19);
        target.get(result);
        Assertions.assertThat((byte[])result).isEqualTo((Object)bytes);
    }

    private void testSlicedByteBufferPut(boolean directBuffer) {
        int len;
        byte[] bytes = new byte[this.pageSize + 49];
        this.random.nextBytes(bytes);
        ByteBuffer source = directBuffer ? ByteBuffer.allocateDirect(this.pageSize + 49) : ByteBuffer.allocate(this.pageSize + 49);
        source.put(bytes);
        source.position(19).limit(19 + this.pageSize);
        ByteBuffer slicedSource = source.slice();
        MemorySegment seg = this.createSegment(3 * this.pageSize);
        int offset = 2 * this.pageSize;
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.put(offset + pos, slicedSource, len);
        }
        byte[] result = new byte[this.pageSize];
        seg.get(offset, result);
        byte[] expected = Arrays.copyOfRange(bytes, 19, 19 + this.pageSize);
        Assertions.assertThat((byte[])result).isEqualTo((Object)expected);
    }

    @Parameters(name="segment-size = {0}")
    public static Collection<Object[]> executionModes() {
        return Arrays.asList({32768}, {4096}, {524288});
    }
}

