/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.memory;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.memory.MemorySegmentTestBase;
import com.alibaba.fluss.memory.MemoryUtils;
import com.alibaba.fluss.testutils.junit.parameterized.ParameterizedTestExtension;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class OffHeapDirectMemorySegmentTest
extends MemorySegmentTestBase {
    public OffHeapDirectMemorySegmentTest(int pageSize) {
        super(pageSize);
    }

    @Override
    MemorySegment createSegment(int size) {
        return MemorySegment.allocateOffHeapMemory((int)size);
    }

    @TestTemplate
    public void testHeapSegmentSpecifics() {
        int bufSize = 411;
        MemorySegment seg = this.createSegment(411);
        Assertions.assertThat((boolean)seg.isOffHeap()).isTrue();
        Assertions.assertThat((int)seg.size()).isEqualTo(411);
        Assertions.assertThatThrownBy(() -> ((MemorySegment)seg).getArray()).isInstanceOf(IllegalStateException.class);
        ByteBuffer buf1 = seg.wrap(1, 2);
        ByteBuffer buf2 = seg.wrap(3, 4);
        Assertions.assertThat((Comparable)buf2).isNotSameAs((Object)buf1);
        Assertions.assertThat((int)buf1.position()).isEqualTo(1);
        Assertions.assertThat((int)buf1.limit()).isEqualTo(3);
        Assertions.assertThat((int)buf2.position()).isEqualTo(3);
        Assertions.assertThat((int)buf2.limit()).isEqualTo(7);
    }

    @TestTemplate
    public void testGetAddress() {
        Assertions.assertThat((long)this.segment.getAddress()).isEqualTo(MemoryUtils.getByteBufferAddress((ByteBuffer)this.segment.getOffHeapBuffer()));
    }
}

