/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.memory;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.memory.MemorySegmentTestBase;
import com.alibaba.fluss.testutils.junit.parameterized.ParameterizedTestExtension;
import java.nio.ByteBuffer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class OnHeapMemorySegmentTest
extends MemorySegmentTestBase {
    public OnHeapMemorySegmentTest(int pageSize) {
        super(pageSize);
    }

    @Override
    MemorySegment createSegment(int size) {
        return MemorySegment.allocateHeapMemory((int)size);
    }

    @TestTemplate
    public void testHeapSegmentSpecifics() {
        byte[] buffer = new byte[411];
        MemorySegment seg = MemorySegment.wrap((byte[])buffer);
        Assertions.assertThat((boolean)seg.isOffHeap()).isFalse();
        Assertions.assertThat((int)seg.size()).isEqualTo(buffer.length);
        Assertions.assertThat((byte[])seg.getArray()).isSameAs((Object)buffer);
        ByteBuffer buf1 = seg.wrap(1, 2);
        ByteBuffer buf2 = seg.wrap(3, 4);
        Assertions.assertThat((Comparable)buf2).isNotSameAs((Object)buf1);
        Assertions.assertThat((int)buf1.position()).isEqualTo(1);
        Assertions.assertThat((int)buf1.limit()).isEqualTo(3);
        Assertions.assertThat((int)buf2.position()).isEqualTo(3);
        Assertions.assertThat((int)buf2.limit()).isEqualTo(7);
    }

    @TestTemplate
    public void testReadOnlyByteBufferPut() {
        int i;
        byte[] buffer = new byte[100];
        MemorySegment seg = MemorySegment.wrap((byte[])buffer);
        String content = "hello world";
        ByteBuffer bb = ByteBuffer.allocate(20);
        bb.put(content.getBytes());
        bb.rewind();
        int offset = 10;
        int numBytes = 5;
        ByteBuffer readOnlyBuf = bb.asReadOnlyBuffer();
        Assertions.assertThat((boolean)readOnlyBuf.isDirect()).isFalse();
        Assertions.assertThat((boolean)readOnlyBuf.hasArray()).isFalse();
        seg.put(offset, readOnlyBuf, numBytes);
        for (i = 0; i < offset; ++i) {
            Assertions.assertThat((byte)buffer[i]).isEqualTo((byte)0);
        }
        Assertions.assertThat((String)new String(buffer, offset, numBytes)).isEqualTo("hello");
        for (i = offset + numBytes; i < buffer.length; ++i) {
            Assertions.assertThat((byte)buffer[i]).isEqualTo((byte)0);
        }
    }

    @TestTemplate
    public void testGetOnHeapMemory() {
        MemorySegment seg = MemorySegment.allocateHeapMemory((int)10);
        Assertions.assertThat((int)seg.getHeapMemory().length).isEqualTo(10);
    }

    @TestTemplate
    public void testGetAddress() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.segment.getAddress()).isInstanceOf(IllegalStateException.class)).hasMessage("Memory segment does not represent off heap memory");
    }
}

