/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metadata;

import com.alibaba.fluss.config.ConfigBuilder;
import com.alibaba.fluss.config.ConfigOption;
import com.alibaba.fluss.metadata.KvFormat;
import com.alibaba.fluss.metadata.LogFormat;
import com.alibaba.fluss.metadata.Schema;
import com.alibaba.fluss.metadata.TableDescriptor;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.DataTypes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TableDescriptorTest {
    private static final Schema SCHEMA_1 = Schema.newBuilder().column("f0", (DataType)DataTypes.STRING()).column("f1", (DataType)DataTypes.BIGINT()).column("f3", (DataType)DataTypes.STRING()).primaryKey(new String[]{"f0", "f3"}).build();
    private static final ConfigOption<Boolean> OPTION_A = ConfigBuilder.key((String)"a").booleanType().noDefaultValue();
    private static final ConfigOption<Integer> OPTION_B = ConfigBuilder.key((String)"b").intType().noDefaultValue();

    TableDescriptorTest() {
    }

    @Test
    void testBasic() {
        TableDescriptor descriptor = TableDescriptor.builder().schema(SCHEMA_1).partitionedBy(new String[]{"f0"}).comment("Test Comment").build();
        Assertions.assertThat((Object)descriptor.getSchema()).isEqualTo((Object)SCHEMA_1);
        Assertions.assertThat((boolean)descriptor.isPartitioned()).isTrue();
        Assertions.assertThat((List)descriptor.getPartitionKeys()).hasSize(1);
        Assertions.assertThat((String)((String)descriptor.getPartitionKeys().get(0))).isEqualTo("f0");
        Assertions.assertThat((Map)descriptor.getProperties()).hasSize(0);
        Assertions.assertThat((String)descriptor.getComment().orElse(null)).isEqualTo("Test Comment");
        Optional distribution = descriptor.getTableDistribution();
        Assertions.assertThat((Optional)distribution).isPresent();
        Assertions.assertThat((Optional)((TableDescriptor.TableDistribution)distribution.get()).getBucketCount()).isEmpty();
        Assertions.assertThat((List)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys()).hasSize(1);
        Assertions.assertThat((String)((String)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys().get(0))).isEqualTo("f3");
    }

    @Test
    void testProperties() {
        TableDescriptor descriptor = TableDescriptor.builder().schema(Schema.newBuilder().build()).property(OPTION_A, (Object)false).property(OPTION_B, (Object)42).property("c", "C").customProperty("d", "D").build();
        Assertions.assertThat((Map)descriptor.getProperties()).hasSize(3);
        Assertions.assertThat((String)((String)descriptor.getProperties().get("a"))).isEqualTo("false");
        Assertions.assertThat((String)((String)descriptor.getProperties().get("b"))).isEqualTo("42");
        Assertions.assertThat((String)((String)descriptor.getProperties().get("c"))).isEqualTo("C");
        Assertions.assertThat((String)((String)descriptor.getProperties().get("d"))).isNull();
        Assertions.assertThat((String)((String)descriptor.getCustomProperties().get("d"))).isEqualTo("D");
    }

    @Test
    void testDistribution() {
        TableDescriptor descriptor = TableDescriptor.builder().schema(SCHEMA_1).distributedBy(10, new String[]{"f0", "f3"}).build();
        Optional distribution = descriptor.getTableDistribution();
        Assertions.assertThat((Optional)distribution).isPresent();
        Assertions.assertThat((Optional)((TableDescriptor.TableDistribution)distribution.get()).getBucketCount()).hasValue((Object)10);
        Assertions.assertThat((List)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys()).hasSize(2);
        Assertions.assertThat((String)((String)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys().get(0))).isEqualTo("f0", new Object[]{"f3"});
    }

    @Test
    void testSchemaWithoutPrimaryKeyAndDistributionWithEmptyBucketKeys() {
        Schema schema = Schema.newBuilder().column("f0", (DataType)DataTypes.STRING()).column("f1", (DataType)DataTypes.BIGINT()).build();
        TableDescriptor descriptor = TableDescriptor.builder().schema(schema).distributedBy(12, new String[0]).build();
        Optional distribution = descriptor.getTableDistribution();
        Assertions.assertThat((Optional)distribution).isPresent();
        Assertions.assertThat((Optional)((TableDescriptor.TableDistribution)distribution.get()).getBucketCount()).hasValue((Object)12);
        Assertions.assertThat((List)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys()).hasSize(0);
    }

    @Test
    void testPrimaryKeyDifferentWithBucketKeys() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(SCHEMA_1).distributedBy(12, new String[]{"f1"}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Currently, bucket keys must be equal to primary keys excluding partition keys for primary-key tables. The primary keys are [f0, f3], the partition keys are [], the expected bucket keys are [f0, f3], but the user-defined bucket keys are [f1].");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(SCHEMA_1).distributedBy(12, new String[]{"f0", "f1"}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Currently, bucket keys must be equal to primary keys excluding partition keys for primary-key tables. The primary keys are [f0, f3], the partition keys are [], the expected bucket keys are [f0, f3], but the user-defined bucket keys are [f0, f1].");
        Schema schema0 = Schema.newBuilder().column("f0", (DataType)DataTypes.STRING()).column("f1", (DataType)DataTypes.BIGINT()).primaryKey(new String[]{"f0", "f1"}).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(schema0).distributedBy(12, new String[]{"f0"}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Currently, bucket keys must be equal to primary keys excluding partition keys for primary-key tables. The primary keys are [f0, f1], the partition keys are [], the expected bucket keys are [f0, f1], but the user-defined bucket keys are [f0].");
    }

    @Test
    void testSchemaWithPrimaryKeysButDistributionIsNull() {
        TableDescriptor descriptor = TableDescriptor.builder().schema(SCHEMA_1).partitionedBy(new String[]{"f0"}).comment("Test Comment").build();
        Optional distribution = descriptor.getTableDistribution();
        Assertions.assertThat((Optional)distribution).isPresent();
        Assertions.assertThat((Optional)((TableDescriptor.TableDistribution)distribution.get()).getBucketCount()).isEmpty();
        Assertions.assertThat((List)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys()).hasSize(1);
        Assertions.assertThat((String)((String)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys().get(0))).isEqualTo("f3");
    }

    @Test
    void testSchemaWithPrimaryKeysButDistributionWithEmptyBucketKey() {
        TableDescriptor descriptor = TableDescriptor.builder().schema(SCHEMA_1).partitionedBy(new String[]{"f0"}).distributedBy(10, new String[0]).comment("Test Comment").build();
        Optional distribution = descriptor.getTableDistribution();
        Assertions.assertThat((Optional)distribution).isPresent();
        Assertions.assertThat((Optional)((TableDescriptor.TableDistribution)distribution.get()).getBucketCount()).hasValue((Object)10);
        Assertions.assertThat((List)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys()).hasSize(1);
        Assertions.assertThat((String)((String)((TableDescriptor.TableDistribution)distribution.get()).getBucketKeys().get(0))).isEqualTo("f3");
    }

    @Test
    void testCopy() {
        TableDescriptor descriptor = TableDescriptor.builder().schema(SCHEMA_1).partitionedBy(new String[]{"f0"}).comment("Test Comment").property(OPTION_A, (Object)true).build();
        TableDescriptor copy = descriptor.copy(new HashMap());
        Assertions.assertThat((boolean)copy.isPartitioned()).isEqualTo(descriptor.isPartitioned());
        Assertions.assertThat((Optional)copy.getTableDistribution()).isEqualTo((Object)descriptor.getTableDistribution());
        Assertions.assertThat((Optional)copy.getComment()).isEqualTo((Object)descriptor.getComment());
        Assertions.assertThat((List)copy.getPartitionKeys()).isEqualTo((Object)descriptor.getPartitionKeys());
        Assertions.assertThat((Object)copy.getSchema()).isEqualTo((Object)descriptor.getSchema());
        Assertions.assertThat((Map)copy.getProperties()).hasSize(0);
    }

    @Test
    void testInvalidTableDescriptor() {
        Schema schema = Schema.newBuilder().column("f0", (DataType)DataTypes.STRING()).column("f1", (DataType)DataTypes.BIGINT()).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(schema).partitionedBy(new String[]{"unknown_p"}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Partition key 'unknown_p' does not exist in the schema.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(schema).distributedBy(12, new String[]{"unknown_f"}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Bucket key 'unknown_f' does not exist in the schema.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(Schema.newBuilder().column("id", (DataType)DataTypes.INT()).column("dt", (DataType)DataTypes.STRING()).column("a", (DataType)DataTypes.BIGINT()).column("ts", (DataType)DataTypes.TIMESTAMP()).primaryKey(new String[]{"id"}).build()).partitionedBy(new String[]{"dt"}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Partitioned Primary Key Table requires partition key [dt] is a subset of the primary key [id].");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(Schema.newBuilder().column("a", (DataType)DataTypes.INT()).column("b", (DataType)DataTypes.STRING()).primaryKey(new String[]{"a"}).build()).kvFormat(KvFormat.COMPACTED).logFormat(LogFormat.INDEXED).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("For Primary Key Table, if kv format is compacted, log format must be arrow.");
    }

    @Test
    void testPartitionedTable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(SCHEMA_1).partitionedBy(new String[]{"f0", "f3"}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Primary Key constraint [f0, f3] should not be same with partition fields [f0, f3].");
        TableDescriptor tableDescriptor = TableDescriptor.builder().schema(SCHEMA_1).partitionedBy(new String[]{"f0"}).build();
        Assertions.assertThat((List)((TableDescriptor.TableDistribution)tableDescriptor.getTableDistribution().get()).getBucketKeys()).isEqualTo(Collections.singletonList("f3"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TableDescriptor.builder().schema(SCHEMA_1).partitionedBy(new String[]{"f0"}).distributedBy(1, new String[]{"f0", "f3"}).build()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Bucket key [f0, f3] shouldn't include any column in partition keys [f0].");
    }
}

