/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metadata;

import com.alibaba.fluss.exception.InvalidDatabaseException;
import com.alibaba.fluss.exception.InvalidTableException;
import com.alibaba.fluss.metadata.TablePath;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TablePathTest {
    TablePathTest() {
    }

    @Test
    void testValidate() {
        TablePath path = TablePath.of((String)"db_2-abc3", (String)"table-1_abc_2");
        path.validate();
        Assertions.assertThat((boolean)path.isValid()).isTrue();
        Assertions.assertThat((String)path.toString()).isEqualTo("db_2-abc3.table-1_abc_2");
        String longName = StringUtils.repeat((String)"a", (int)200);
        Assertions.assertThat((boolean)TablePath.of((String)longName, (String)longName).isValid()).isTrue();
        TablePathTest.assertInvalidName("*abc", "'*abc' contains one or more characters other than");
        TablePathTest.assertInvalidName("table.abc", "'table.abc' contains one or more characters other than");
        TablePathTest.assertInvalidName(null, "null string is not allowed");
        TablePathTest.assertInvalidName("", "the empty string is not allowed");
        TablePathTest.assertInvalidName(" ", "' ' contains one or more characters other than");
        TablePathTest.assertInvalidName(".", "'.' is not allowed");
        TablePathTest.assertInvalidName("..", "'..' is not allowed");
        TablePathTest.assertInvalidName("..", "'..' is not allowed");
        String invalidLongName = StringUtils.repeat((String)"a", (int)201);
        TablePathTest.assertInvalidName(invalidLongName, "the length of '" + invalidLongName + "' is longer than the max allowed length 200");
    }

    private static void assertInvalidName(String name, String expectedMessage) {
        TablePath invalidTable = TablePath.of((String)"db", (String)name);
        Assertions.assertThat((boolean)invalidTable.isValid()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TablePath)invalidTable).validate()).isInstanceOf(InvalidTableException.class)).hasMessageContaining("Table name " + name + " is invalid: " + expectedMessage);
        TablePath invalidDb = TablePath.of((String)name, (String)"table");
        Assertions.assertThat((boolean)invalidDb.isValid()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((TablePath)invalidDb).validate()).isInstanceOf(InvalidDatabaseException.class)).hasMessageContaining("Database name " + name + " is invalid: " + expectedMessage);
    }
}

