/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics;

import com.alibaba.fluss.metrics.DescriptiveStatisticsHistogram;
import com.alibaba.fluss.metrics.DescriptiveStatisticsHistogramStatistics;
import com.alibaba.fluss.metrics.Histogram;
import com.alibaba.fluss.metrics.HistogramStatistics;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class DescriptiveStatisticsHistogramTest {
    private static final double[] DATA = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};

    DescriptiveStatisticsHistogramTest() {
    }

    @Test
    void testDescriptiveHistogram() {
        int size = 10;
        this.testHistogram(size, (Histogram)new DescriptiveStatisticsHistogram(size));
    }

    @Test
    void testCopy() {
        DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot original = new DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot();
        original.evaluate(DATA);
        DescriptiveStatisticsHistogramTest.assertOperations(original);
        DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot copy = original.copy();
        DescriptiveStatisticsHistogramTest.assertOperations(copy);
    }

    private static void assertOperations(DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot statistics) {
        Assertions.assertThat((double)statistics.getPercentile(0.5)).isOne();
        Assertions.assertThat((long)statistics.getCount()).isEqualTo(9L);
        Assertions.assertThat((double)statistics.getMin()).isOne();
        Assertions.assertThat((double)statistics.getMax()).isEqualTo(9.0);
        Assertions.assertThat((double)statistics.getMean()).isEqualTo(5.0);
        Assertions.assertThat((double)statistics.getStandardDeviation()).isCloseTo(2.7, Offset.offset((Number)0.5));
        Assertions.assertThat((double[])statistics.getValues()).containsExactly(DATA);
    }

    protected void testHistogram(int size, Histogram histogram) {
        HistogramStatistics statistics;
        int i;
        for (i = 0; i < size; ++i) {
            histogram.update((long)i);
            statistics = histogram.getStatistics();
            Assertions.assertThat((long)histogram.getCount()).isEqualTo((long)(i + 1));
            Assertions.assertThat((int)statistics.size()).isEqualTo(histogram.getCount());
            Assertions.assertThat((long)statistics.getMax()).isEqualTo((long)i);
            Assertions.assertThat((long)statistics.getMin()).isEqualTo(0L);
        }
        statistics = histogram.getStatistics();
        Assertions.assertThat((int)statistics.size()).isEqualTo(size);
        Assertions.assertThat((double)statistics.getQuantile(0.5)).isCloseTo((double)(size - 1) / 2.0, Assertions.offset((Double)0.001));
        for (i = size; i < 2 * size; ++i) {
            histogram.update((long)i);
            statistics = histogram.getStatistics();
            Assertions.assertThat((long)histogram.getCount()).isEqualTo((long)(i + 1));
            Assertions.assertThat((int)statistics.size()).isEqualTo(size);
            Assertions.assertThat((long)statistics.getMax()).isEqualTo((long)i);
            Assertions.assertThat((long)statistics.getMin()).isEqualTo((long)(i + 1 - size));
        }
        statistics = histogram.getStatistics();
        Assertions.assertThat((int)statistics.size()).isEqualTo(size);
        Assertions.assertThat((double)statistics.getQuantile(0.5)).isCloseTo((double)size + (double)(size - 1) / 2.0, Assertions.offset((Double)0.001));
    }
}

