/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics;

import com.alibaba.fluss.metrics.Counter;
import com.alibaba.fluss.metrics.MeterView;
import com.alibaba.fluss.metrics.SimpleCounter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MeterViewTest {
    MeterViewTest() {
    }

    @Test
    void testGetCount() {
        SimpleCounter c = new SimpleCounter();
        c.inc(5L);
        MeterView m = new MeterView((Counter)c);
        Assertions.assertThat((long)m.getCount()).isEqualTo(5L);
    }

    @Test
    void testMarkEvent() {
        SimpleCounter c = new SimpleCounter();
        MeterView m = new MeterView((Counter)c);
        Assertions.assertThat((long)m.getCount()).isEqualTo(0L);
        m.markEvent();
        Assertions.assertThat((long)m.getCount()).isEqualTo(1L);
        m.markEvent(2L);
        Assertions.assertThat((long)m.getCount()).isEqualTo(3L);
    }

    @Test
    void testGetRate() {
        int x;
        SimpleCounter c = new SimpleCounter();
        MeterView m = new MeterView((Counter)c);
        for (x = 0; x < 12; ++x) {
            m.markEvent(10L);
            m.update();
        }
        Assertions.assertThat((double)m.getRate()).isEqualTo(2.0, Assertions.offset((Double)0.1));
        for (x = 0; x < 12; ++x) {
            m.markEvent(10L);
            m.update();
        }
        Assertions.assertThat((double)m.getRate()).isEqualTo(2.0, Assertions.offset((Double)0.1));
        for (x = 0; x < 6; ++x) {
            m.markEvent(20L);
            m.update();
        }
        Assertions.assertThat((double)m.getRate()).isEqualTo(3.0, Assertions.offset((Double)0.1));
        for (x = 0; x < 6; ++x) {
            m.markEvent(20L);
            m.update();
        }
        Assertions.assertThat((double)m.getRate()).isEqualTo(4.0, Assertions.offset((Double)0.1));
        for (x = 0; x < 6; ++x) {
            m.update();
        }
        Assertions.assertThat((double)m.getRate()).isEqualTo(2.0, Assertions.offset((Double)0.1));
        for (x = 0; x < 6; ++x) {
            m.update();
        }
        Assertions.assertThat((double)m.getRate()).isEqualTo(0.0, Assertions.offset((Double)0.1));
    }

    @Test
    void testTimeSpanBelowUpdateRate() {
        int timeSpanInSeconds = 1;
        Assertions.assertThat((int)timeSpanInSeconds).isLessThan(5);
        MeterView m = new MeterView(timeSpanInSeconds);
        m.markEvent();
        m.update();
        Assertions.assertThat((double)m.getRate()).isEqualTo(0.2);
    }
}

