/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics;

import com.alibaba.fluss.metrics.MeterView;
import com.alibaba.fluss.metrics.MetricView;
import com.alibaba.fluss.metrics.MetricViewUpdater;
import com.alibaba.fluss.testutils.common.ManuallyTriggeredScheduledExecutorService;
import com.alibaba.fluss.testutils.common.ScheduledTask;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricViewUpdaterTest {
    MetricViewUpdaterTest() {
    }

    @Test
    void testViewUpdate() {
        ManuallyTriggeredScheduledExecutorService scheduledExecutorService = new ManuallyTriggeredScheduledExecutorService();
        MetricViewUpdater metricViewUpdater = new MetricViewUpdater((ScheduledExecutorService)scheduledExecutorService);
        MeterView m = new MeterView(1);
        m.markEvent();
        metricViewUpdater.notifyOfAddedView((MetricView)m);
        List scheduledFutures = scheduledExecutorService.getAllScheduledTasks();
        scheduledExecutorService.triggerScheduledTasks();
        this.scheduleTasks((ScheduledExecutorService)scheduledExecutorService, scheduledFutures);
        scheduledExecutorService.triggerScheduledTasks();
        Assertions.assertThat((double)m.getRate()).isEqualTo(0.2);
        metricViewUpdater.notifyOfRemovedView((MetricView)m);
        m.markEvent();
        this.scheduleTasks((ScheduledExecutorService)scheduledExecutorService, scheduledFutures);
        scheduledExecutorService.triggerScheduledTasks();
        Assertions.assertThat((double)m.getRate()).isEqualTo(0.2);
    }

    private void scheduleTasks(ScheduledExecutorService executorService, List<ScheduledFuture<?>> scheduledFutures) {
        for (ScheduledFuture<?> scheduledFuture : scheduledFutures) {
            ScheduledTask scheduledTask = (ScheduledTask)scheduledFuture;
            executorService.scheduleWithFixedDelay(() -> {
                try {
                    scheduledTask.getCallable().call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, 0L, 0L, TimeUnit.MILLISECONDS);
        }
    }
}

