/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics.groups;

import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.metrics.CharacterFilter;
import com.alibaba.fluss.metrics.groups.AbstractMetricGroup;
import com.alibaba.fluss.metrics.groups.GenericMetricGroup;
import com.alibaba.fluss.metrics.groups.MetricGroup;
import com.alibaba.fluss.metrics.registry.MetricRegistry;
import com.alibaba.fluss.metrics.registry.MetricRegistryImpl;
import com.alibaba.fluss.metrics.util.CollectingMetricsReporter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractMetricGroupTest {
    private static final CharacterFilter FILTER_B = input -> input.replace("B", "X");
    private static final CharacterFilter FILTER_C = input -> input.replace("C", "X");

    AbstractMetricGroupTest() {
    }

    @Test
    void testGetAllVariables() throws Exception {
        MetricRegistry registry = MetricRegistry.create((Configuration)new Configuration(), null);
        Object group = new AbstractMetricGroup(registry, new String[0], null){

            protected String getGroupName(CharacterFilter filter) {
                return "test";
            }
        };
        Assertions.assertThat((Map)group.getAllVariables()).isEmpty();
        group = new GenericMetricGroup(registry, null, "test"){

            protected void putVariables(Map<String, String> variables) {
                variables.put("k1", "v1");
                variables.put("k2", "v2");
            }
        };
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("k1", "v1");
        expected.put("k2", "v2");
        Assertions.assertThat((Map)group.getAllVariables()).containsAllEntriesOf(expected);
        group = new GenericMetricGroup(registry, (AbstractMetricGroup)group, "test2"){

            protected void putVariables(Map<String, String> variables) {
                variables.put("k3", "v3");
                variables.put("k4", "v4");
            }
        };
        expected.put("k3", "v3");
        expected.put("k4", "v4");
        Assertions.assertThat((Map)group.getAllVariables()).containsAllEntriesOf(expected);
        registry.closeAsync().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLogicalScopeCachingForMultipleReporters() throws Exception {
        String counterName = "1";
        CollectingMetricsReporter reporter1 = new CollectingMetricsReporter("reporter1", FILTER_B);
        CollectingMetricsReporter reporter2 = new CollectingMetricsReporter("reporter2", FILTER_C);
        MetricRegistryImpl testRegistry = new MetricRegistryImpl(Arrays.asList(reporter1, reporter2));
        try {
            MetricGroup testGroup = new GenericMetricGroup((MetricRegistry)testRegistry, null, "test").addGroup("B").addGroup("C");
            testGroup.counter(counterName);
            ((AbstractIntegerAssert)Assertions.assertThat((int)testRegistry.getNumberReporters()).withFailMessage("Reporters were not properly instantiated", new Object[0])).isEqualTo(2);
            Assertions.assertThat((String)reporter1.findAdded((String)counterName).group.getLogicalScope((CharacterFilter)reporter1, '-')).isEqualTo("test-X-C");
            Assertions.assertThat((String)reporter2.findAdded((String)counterName).group.getLogicalScope((CharacterFilter)reporter2, ',')).isEqualTo("test,B,X");
        }
        finally {
            testRegistry.closeAsync().get();
        }
    }
}

