/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics.groups;

import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.metrics.CharacterFilter;
import com.alibaba.fluss.metrics.Meter;
import com.alibaba.fluss.metrics.MeterView;
import com.alibaba.fluss.metrics.Metric;
import com.alibaba.fluss.metrics.groups.AbstractMetricGroup;
import com.alibaba.fluss.metrics.groups.GenericMetricGroup;
import com.alibaba.fluss.metrics.groups.MetricGroup;
import com.alibaba.fluss.metrics.registry.MetricRegistry;
import com.alibaba.fluss.metrics.registry.MetricRegistryImpl;
import com.alibaba.fluss.metrics.registry.NOPMetricRegistry;
import com.alibaba.fluss.metrics.util.DummyCharacterFilter;
import java.util.Collections;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MetricGroupTest {
    private MetricRegistry registry;
    private final MetricRegistryImpl exceptionOnRegister = new ExceptionOnRegisterRegistry();

    MetricGroupTest() {
    }

    @BeforeEach
    void createRegistry() {
        this.registry = MetricRegistry.create((Configuration)new Configuration(), null);
    }

    @AfterEach
    void shutdownRegistry() throws Exception {
        this.registry.closeAsync().get();
        this.registry = null;
    }

    @Test
    void sameGroupOnNameCollision() {
        GenericMetricGroup group = new GenericMetricGroup(this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.registry), "somegroup");
        String groupName = "sometestname";
        MetricGroup subgroup1 = group.addGroup(groupName);
        MetricGroup subgroup2 = group.addGroup(groupName);
        Assertions.assertThat((Object)subgroup1).isSameAs((Object)subgroup2);
    }

    @Test
    void testAddVariable() {
        MetricRegistry registry = NOPMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key = "key";
        String value = "value";
        MetricGroup group = root.addGroup(key, value);
        String variableValue = (String)group.getAllVariables().get(key);
        Assertions.assertThat((String)variableValue).isEqualTo(value);
        Object[] scopes = group.getScopeComponents();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Key is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"key"});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Value is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"value"});
        String logicalScope = group.getLogicalScope((CharacterFilter)new DummyCharacterFilter(), '-');
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is present in logical scope.", new Object[0])).doesNotContain(new CharSequence[]{value});
    }

    @Test
    void testDefinedVariableOnKeyGroup() {
        MetricRegistry registry = NOPMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key1 = "key1";
        String value1 = "value1";
        root.addGroup(key1, value1);
        String key2 = "key2";
        String value2 = "value2";
        MetricGroup group = root.addGroup(key1).addGroup(key2, value2);
        String variableValue = (String)group.getAllVariables().get("value2");
        Assertions.assertThat((String)variableValue).isNull();
        Object[] scopes = group.getScopeComponents();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Key1 is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"key1"});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Key2 is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"key2"});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Value2 is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"value2"});
        String logicalScope = group.getLogicalScope((CharacterFilter)new DummyCharacterFilter(), '-');
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key1 is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key1});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key2 is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key2});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value2 is missing from logical scope.", new Object[0])).contains(new CharSequence[]{value2});
    }

    @Test
    void testNameCollisionForKeyAfterGenericGroup() {
        MetricRegistry registry = NOPMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key = "key";
        String value = "value";
        root.addGroup(key);
        MetricGroup group = root.addGroup(key, value);
        String variableValue = (String)group.getAllVariables().get(key);
        Assertions.assertThat((String)variableValue).isNull();
        Object[] scopes = group.getScopeComponents();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Key is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"key"});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Value is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"value"});
        String logicalScope = group.getLogicalScope((CharacterFilter)new DummyCharacterFilter(), '-');
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is missing from logical scope.", new Object[0])).contains(new CharSequence[]{value});
    }

    @Test
    void testNameCollisionForKeyAndValueAfterGenericGroup() {
        MetricRegistry registry = NOPMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key = "key";
        String value = "value";
        root.addGroup(key).addGroup(value);
        MetricGroup group = root.addGroup(key, value);
        String variableValue = (String)group.getAllVariables().get(key);
        Assertions.assertThat((String)variableValue).isNull();
        Object[] scopes = group.getScopeComponents();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Key is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"key"});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Value is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"value"});
        String logicalScope = group.getLogicalScope((CharacterFilter)new DummyCharacterFilter(), '-');
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is missing from logical scope.", new Object[0])).contains(new CharSequence[]{value});
    }

    @Test
    void testNameCollisionAfterKeyValueGroup() {
        MetricRegistry registry = NOPMetricRegistry.INSTANCE;
        GenericMetricGroup root = new GenericMetricGroup(registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(registry), "root");
        String key = "key";
        String value = "value";
        root.addGroup(key, value);
        MetricGroup group = root.addGroup(key).addGroup(value);
        String variableValue = (String)group.getAllVariables().get(key);
        Assertions.assertThat((String)variableValue).isEqualTo(value);
        Object[] scopes = group.getScopeComponents();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Key is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"key"});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])scopes).withFailMessage("Value is missing from metric identifier.", new Object[0])).contains((Object[])new String[]{"value"});
        String logicalScope = group.getLogicalScope((CharacterFilter)new DummyCharacterFilter(), '-');
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Key is missing from logical scope.", new Object[0])).contains(new CharSequence[]{key});
        ((AbstractStringAssert)Assertions.assertThat((String)logicalScope).withFailMessage("Value is present in logical scope.", new Object[0])).doesNotContain(new CharSequence[]{value});
    }

    @Test
    void closedGroupDoesNotRegisterMetrics() {
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.exceptionOnRegister), "testgroup");
        Assertions.assertThat((boolean)group.isClosed()).isFalse();
        group.close();
        Assertions.assertThat((boolean)group.isClosed()).isTrue();
        group.counter("testcounter");
        group.gauge("testgauge", () -> null);
    }

    @Test
    void closedGroupCreatesClosedGroups() {
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.exceptionOnRegister), "testgroup");
        Assertions.assertThat((boolean)group.isClosed()).isFalse();
        group.close();
        Assertions.assertThat((boolean)group.isClosed()).isTrue();
        AbstractMetricGroup subgroup = (AbstractMetricGroup)group.addGroup("test subgroup");
        Assertions.assertThat((boolean)subgroup.isClosed()).isTrue();
    }

    @Test
    void addClosedGroupReturnsNewGroupInstance() {
        GenericMetricGroup mainGroup = new GenericMetricGroup((MetricRegistry)this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.exceptionOnRegister), "mainGroup");
        AbstractMetricGroup subGroup = (AbstractMetricGroup)mainGroup.addGroup("subGroup");
        Assertions.assertThat((boolean)subGroup.isClosed()).isFalse();
        subGroup.close();
        Assertions.assertThat((boolean)subGroup.isClosed()).isTrue();
        AbstractMetricGroup newSubGroupWithSameNameAsClosedGroup = (AbstractMetricGroup)mainGroup.addGroup("subGroup");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)newSubGroupWithSameNameAsClosedGroup.isClosed()).withFailMessage("The new subgroup should not be closed", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)subGroup.isClosed()).withFailMessage("The old sub group is not modified", new Object[0])).isTrue();
    }

    @Test
    void tolerateMetricNameCollisions() {
        String name = "abctestname";
        GenericMetricGroup group = new GenericMetricGroup(this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.registry), "testgroup");
        Assertions.assertThat((Object)group.counter("abctestname")).isNotNull();
        Assertions.assertThat((Object)group.counter("abctestname")).isNotNull();
    }

    @Test
    void tolerateMetricAndGroupNameCollisions() {
        String name = "abctestname";
        GenericMetricGroup group = new GenericMetricGroup(this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.registry), "testgroup");
        Assertions.assertThat((Object)group.addGroup("abctestname")).isNotNull();
        Assertions.assertThat((Object)group.counter("abctestname")).isNotNull();
    }

    @Test
    void testMeter() {
        GenericMetricGroup group = new GenericMetricGroup(this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup(this.registry), "testgroup");
        MeterView meterView = new MeterView(1);
        group.meter("testMeter", (Meter)meterView);
        meterView.markEvent();
        meterView.update();
        Assertions.assertThat((double)meterView.getRate()).isEqualTo(0.2);
    }

    public static class DummyAbstractMetricGroup
    extends AbstractMetricGroup {
        public DummyAbstractMetricGroup(MetricRegistry registry) {
            super(registry, new String[0], null);
        }

        protected void addMetric(String name, Metric metric) {
        }

        protected String getGroupName(CharacterFilter filter) {
            return "foo";
        }

        public MetricGroup addGroup(String name) {
            return new DummyAbstractMetricGroup(this.registry);
        }
    }

    private static class ExceptionOnRegisterRegistry
    extends MetricRegistryImpl {
        public ExceptionOnRegisterRegistry() {
            super(Collections.emptyList());
        }

        public void register(Metric metric, String name, AbstractMetricGroup parent) {
            Assertions.fail((String)"Metric should never be registered");
        }

        public void unregister(Metric metric, String name, AbstractMetricGroup parent) {
            Assertions.fail((String)"Metric should never be un-registered");
        }
    }
}

