/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics.registry;

import com.alibaba.fluss.metrics.Counter;
import com.alibaba.fluss.metrics.Metric;
import com.alibaba.fluss.metrics.SimpleCounter;
import com.alibaba.fluss.metrics.groups.AbstractMetricGroup;
import com.alibaba.fluss.metrics.groups.GenericMetricGroup;
import com.alibaba.fluss.metrics.groups.MetricGroup;
import com.alibaba.fluss.metrics.registry.MetricRegistry;
import com.alibaba.fluss.metrics.registry.MetricRegistryImpl;
import com.alibaba.fluss.metrics.reporter.ScheduledMetricReporter;
import com.alibaba.fluss.metrics.util.TestReporter;
import com.alibaba.fluss.testutils.common.ManuallyTriggeredScheduledExecutorService;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MetricRegistryImplTest {
    MetricRegistryImplTest() {
    }

    @Test
    void testIsShutdown() throws Exception {
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(Collections.singletonList(new TestReporter("test")));
        Assertions.assertThat((boolean)metricRegistry.isShutdown()).isFalse();
        metricRegistry.closeAsync().get();
        Assertions.assertThat((boolean)metricRegistry.isShutdown()).isTrue();
    }

    @Test
    void testReporterNotifications() throws Exception {
        NotificationCapturingReporter reporter1 = new NotificationCapturingReporter();
        NotificationCapturingReporter reporter2 = new NotificationCapturingReporter();
        MetricRegistryImpl registry = new MetricRegistryImpl(Arrays.asList(reporter1, reporter2));
        GenericMetricGroup root = new GenericMetricGroup((MetricRegistry)registry, null, "test");
        root.counter("rootCounter");
        Assertions.assertThat(reporter1.getLastAddedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter1.getLastAddedMetricName()).hasValue((Object)"rootCounter");
        Assertions.assertThat(reporter2.getLastAddedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter2.getLastAddedMetricName()).hasValue((Object)"rootCounter");
        root.close();
        Assertions.assertThat(reporter1.getLastRemovedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter1.getLastRemovedMetricName()).hasValue((Object)"rootCounter");
        Assertions.assertThat(reporter2.getLastRemovedMetric()).containsInstanceOf(Counter.class);
        Assertions.assertThat(reporter2.getLastRemovedMetricName()).hasValue((Object)"rootCounter");
        registry.closeAsync().get();
    }

    @Test
    void testExceptionIsolation() throws Exception {
        NotificationCapturingReporter reporter1 = new NotificationCapturingReporter();
        MetricRegistryImpl registry = new MetricRegistryImpl(Arrays.asList(new FailingReporter(), reporter1));
        SimpleCounter metric = new SimpleCounter();
        GenericMetricGroup dummyGroup = new GenericMetricGroup((MetricRegistry)registry, null, "test");
        registry.register((Metric)metric, "counter", (AbstractMetricGroup)dummyGroup);
        Assertions.assertThat(reporter1.getLastAddedMetric()).hasValue((Object)metric);
        Assertions.assertThat(reporter1.getLastAddedMetricName()).hasValue((Object)"counter");
        registry.unregister((Metric)metric, "counter", (AbstractMetricGroup)dummyGroup);
        Assertions.assertThat(reporter1.getLastRemovedMetric()).hasValue((Object)metric);
        Assertions.assertThat(reporter1.getLastRemovedMetricName()).hasValue((Object)"counter");
        registry.closeAsync().get();
    }

    @Test
    void testReporterScheduling() throws Exception {
        ReportCountingReporter reporter = new ReportCountingReporter();
        ManuallyTriggeredScheduledExecutorService scheduledReportExecutorService = new ManuallyTriggeredScheduledExecutorService();
        try (MetricRegistryImpl registry = new MetricRegistryImpl(Collections.singletonList(reporter), (ScheduledExecutorService)scheduledReportExecutorService);){
            reporter.resetCount();
            for (int x = 0; x < 10; ++x) {
                scheduledReportExecutorService.triggerPeriodicScheduledTasks();
                Assertions.assertThat((int)reporter.getReportCount()).isEqualTo(x + 1);
            }
        }
    }

    private static class ReportCountingReporter
    extends TestReporter
    implements ScheduledMetricReporter {
        private static final String NAME = "reportCountingReporter";
        private int reportCount = 0;

        public ReportCountingReporter() {
            super(NAME);
        }

        public void report() {
            ++this.reportCount;
        }

        public Duration scheduleInterval() {
            return Duration.ofMillis(1L);
        }

        public int getReportCount() {
            return this.reportCount;
        }

        public void resetCount() {
            this.reportCount = 0;
        }
    }

    private static class FailingReporter
    extends TestReporter {
        private static final String NAME = "failingReporter";

        public FailingReporter() {
            super(NAME);
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            throw new RuntimeException();
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            throw new RuntimeException();
        }
    }

    private static class NotificationCapturingReporter
    extends TestReporter {
        private static final String NAME = "notificationReporter";
        @Nullable
        private Metric addedMetric;
        @Nullable
        private String addedMetricName;
        @Nullable
        private Metric removedMetric;
        @Nullable
        private String removedMetricName;

        public NotificationCapturingReporter() {
            super(NAME);
        }

        @Override
        public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
            this.addedMetric = metric;
            this.addedMetricName = metricName;
        }

        @Override
        public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
            this.removedMetric = metric;
            this.removedMetricName = metricName;
        }

        public Optional<Metric> getLastAddedMetric() {
            return Optional.ofNullable(this.addedMetric);
        }

        public Optional<String> getLastAddedMetricName() {
            return Optional.ofNullable(this.addedMetricName);
        }

        public Optional<Metric> getLastRemovedMetric() {
            return Optional.ofNullable(this.removedMetric);
        }

        public Optional<String> getLastRemovedMetricName() {
            return Optional.ofNullable(this.removedMetricName);
        }
    }
}

