/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics.reporter;

import com.alibaba.fluss.config.ConfigBuilder;
import com.alibaba.fluss.config.ConfigOptions;
import com.alibaba.fluss.config.Configuration;
import com.alibaba.fluss.metrics.reporter.MetricReporter;
import com.alibaba.fluss.metrics.reporter.MetricReporterPlugin;
import com.alibaba.fluss.metrics.reporter.ReporterSetup;
import com.alibaba.fluss.metrics.util.TestReporter;
import com.alibaba.fluss.testutils.common.ContextClassLoaderExtension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class ReporterSetupTest {
    @RegisterExtension
    static final ContextClassLoaderExtension CONTEXT_CLASS_LOADER_EXTENSION = ContextClassLoaderExtension.builder().withServiceEntry(MetricReporterPlugin.class, new String[]{TestReporter1.class.getName(), TestReporter2.class.getName(), TestReporter11.class.getName(), TestReporter12.class.getName(), TestReporter13.class.getName(), TestReporterPlugin.class.getName(), FailingPlugin.class.getName(), ConfigExposingReporterPlugin.class.getName()}).build();

    ReporterSetupTest() {
    }

    @Test
    void testReporterArgumentForwarding() {
        Configuration config = new Configuration();
        config.set(ConfigOptions.METRICS_REPORTERS, Collections.singletonList("reporter1"));
        ReporterSetupTest.configureReporter1(config);
        List metricReporters = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assertions.assertThat((List)metricReporters).hasSize(1);
        MetricReporter metricReporter = (MetricReporter)metricReporters.get(0);
        ReporterSetupTest.assertReporter1Configured(metricReporter);
    }

    @Test
    void testActivateOneReporterAmongTwoDeclared() {
        Configuration config = new Configuration();
        ReporterSetupTest.configureReporter1(config);
        ReporterSetupTest.configureReporter2(config);
        config.set(ConfigOptions.METRICS_REPORTERS, Collections.singletonList("reporter2"));
        List metricReporters = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assertions.assertThat((List)metricReporters).hasSize(1);
        MetricReporter reporter = (MetricReporter)metricReporters.get(0);
        ReporterSetupTest.assertReporter2Configured(reporter);
    }

    @Test
    void testReporterSetupSupplier() {
        Configuration config = new Configuration();
        config.set(ConfigOptions.METRICS_REPORTERS, Collections.singletonList("reporter1"));
        List metricReporters = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assertions.assertThat((List)metricReporters).hasSize(1);
        MetricReporter reporter = (MetricReporter)metricReporters.get(0);
        Assertions.assertThat((Object)reporter).isInstanceOf(TestReporter1.class);
    }

    @Test
    void testMultipleReporterInstantiation() {
        Configuration config = new Configuration();
        config.set(ConfigOptions.METRICS_REPORTERS, Arrays.asList("reporter11", "reporter12", "reporter13"));
        List metricReporters = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assertions.assertThat((List)metricReporters).hasSize(3);
        Assertions.assertThat((boolean)TestReporter11.wasOpened).isTrue();
        Assertions.assertThat((boolean)TestReporter12.wasOpened).isTrue();
        Assertions.assertThat((boolean)TestReporter13.wasOpened).isTrue();
    }

    @Test
    void testPluginFailureIsolation() {
        Configuration config = new Configuration();
        config.set(ConfigOptions.METRICS_REPORTERS, Arrays.asList("reporter11", "failingReporter"));
        List metricReporters = ReporterSetup.fromConfiguration((Configuration)config, null);
        Assertions.assertThat((List)metricReporters).hasSize(1);
    }

    private static void configureReporter1(Configuration config) {
        config.setString("arg1", "value1");
        config.setString("arg2", "value2");
    }

    private static void assertReporter1Configured(MetricReporter metricReporter) {
        TestReporter testReporter = (TestReporter)metricReporter;
        Configuration reporterConfig = testReporter.getConfig();
        Assertions.assertThat((String)((String)reporterConfig.get(ConfigBuilder.key((String)"arg1").stringType().noDefaultValue()))).isEqualTo("value1");
        Assertions.assertThat((String)reporterConfig.getString(ConfigBuilder.key((String)"arg2").stringType().noDefaultValue())).isEqualTo("value2");
    }

    private static void configureReporter2(Configuration config) {
        config.setString("arg1", "value1");
        config.setString("arg3", "value3");
    }

    private static void assertReporter2Configured(MetricReporter metricReporter) {
        TestReporter testReporter = (TestReporter)metricReporter;
        Configuration reporterConfig = testReporter.getConfig();
        Assertions.assertThat((String)((String)reporterConfig.get(ConfigBuilder.key((String)"arg1").stringType().noDefaultValue()))).isEqualTo("value1");
        Assertions.assertThat((String)reporterConfig.getString(ConfigBuilder.key((String)"arg3").stringType().noDefaultValue())).isEqualTo("value3");
    }

    public static class FailingPlugin
    implements MetricReporterPlugin {
        private static final String name = "failingReporter";

        public MetricReporter createMetricReporter(Configuration configuration) {
            throw new RuntimeException();
        }

        public String identifier() {
            return name;
        }
    }

    public static class TestReporterPlugin
    implements MetricReporterPlugin {
        private static final String name = "testReporter";

        public MetricReporter createMetricReporter(Configuration configuration) {
            return new TestReporter(name);
        }

        public String identifier() {
            return name;
        }
    }

    public static class ConfigExposingReporterPlugin
    implements MetricReporterPlugin {
        static Configuration lastConfig = null;
        private static final String name = "configExposingReporter";

        public MetricReporter createMetricReporter(Configuration configuration) {
            lastConfig = configuration;
            return new TestReporter(name);
        }

        public String identifier() {
            return name;
        }
    }

    public static class TestReporter13
    extends TestReporter {
        public static boolean wasOpened = false;

        public TestReporter13() {
            super("reporter13");
        }

        @Override
        public void open(Configuration config) {
            wasOpened = true;
        }
    }

    public static class TestReporter12
    extends TestReporter {
        public static boolean wasOpened = false;

        public TestReporter12() {
            super("reporter12");
        }

        @Override
        public void open(Configuration config) {
            wasOpened = true;
        }
    }

    public static class TestReporter11
    extends TestReporter {
        public static boolean wasOpened = false;

        public TestReporter11() {
            super("reporter11");
        }

        @Override
        public void open(Configuration config) {
            wasOpened = true;
        }
    }

    public static class TestReporter2
    extends TestReporter {
        public TestReporter2() {
            super("reporter2");
        }
    }

    public static class TestReporter1
    extends TestReporter {
        public TestReporter1() {
            super("reporter1");
        }
    }
}

