/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics.util;

import com.alibaba.fluss.metrics.CharacterFilter;
import com.alibaba.fluss.metrics.Metric;
import com.alibaba.fluss.metrics.groups.MetricGroup;
import com.alibaba.fluss.metrics.util.TestReporter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CollectingMetricsReporter
extends TestReporter {
    @Nullable
    private final CharacterFilter characterFilter;
    private final List<MetricGroupAndName> addedMetrics = new ArrayList<MetricGroupAndName>();
    private final List<MetricGroupAndName> removedMetrics = new ArrayList<MetricGroupAndName>();

    public CollectingMetricsReporter(String reporterName, @Nullable CharacterFilter characterFilter) {
        super(reporterName);
        this.characterFilter = characterFilter;
    }

    @Override
    public String filterCharacters(String input) {
        return this.characterFilter == null ? input : this.characterFilter.filterCharacters(input);
    }

    @Override
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        this.addedMetrics.add(new MetricGroupAndName(metricName, group));
    }

    @Override
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        this.removedMetrics.add(new MetricGroupAndName(metricName, group));
    }

    public MetricGroupAndName findAdded(String name) {
        return this.getMetricGroupAndName(name, this.addedMetrics);
    }

    private MetricGroupAndName getMetricGroupAndName(String name, List<MetricGroupAndName> removedMetrics) {
        return removedMetrics.stream().filter(groupAndName -> groupAndName.name.equals(name)).findAny().get();
    }

    public static class MetricGroupAndName {
        public final String name;
        public final MetricGroup group;

        MetricGroupAndName(String name, MetricGroup group) {
            this.name = name;
            this.group = group;
        }
    }
}

