/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.metrics.util;

import com.alibaba.fluss.metrics.CharacterFilter;
import com.alibaba.fluss.metrics.Counter;
import com.alibaba.fluss.metrics.Gauge;
import com.alibaba.fluss.metrics.Histogram;
import com.alibaba.fluss.metrics.Meter;
import com.alibaba.fluss.metrics.SimpleCounter;
import com.alibaba.fluss.metrics.groups.MetricGroup;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

public class TestMetricGroup
implements MetricGroup {
    private final String[] scopeComponents;
    private final Map<String, String> variables;
    private final BiFunction<String, Optional<CharacterFilter>, String> metricIdentifierFunction;
    private final BiFunction<CharacterFilter, Optional<Character>, String> logicalScopeFunction;

    public TestMetricGroup(String[] scopeComponents, Map<String, String> variables, BiFunction<String, Optional<CharacterFilter>, String> metricIdentifierFunction, BiFunction<CharacterFilter, Optional<Character>, String> logicalScopeFunction) {
        this.scopeComponents = scopeComponents;
        this.variables = variables;
        this.metricIdentifierFunction = metricIdentifierFunction;
        this.logicalScopeFunction = logicalScopeFunction;
    }

    public static TestMetricGroupBuilder newBuilder() {
        return new TestMetricGroupBuilder();
    }

    public Counter counter(String name) {
        return new SimpleCounter();
    }

    public <C extends Counter> C counter(String name, C counter) {
        return counter;
    }

    public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
        return gauge;
    }

    public <H extends Histogram> H histogram(String name, H histogram) {
        return histogram;
    }

    public <M extends Meter> M meter(String name, M meter) {
        return meter;
    }

    public MetricGroup addGroup(String name) {
        return this;
    }

    public MetricGroup addGroup(String key, String value) {
        return this;
    }

    public String[] getScopeComponents() {
        return this.scopeComponents;
    }

    public Map<String, String> getAllVariables() {
        return this.variables;
    }

    public void close() {
    }

    public String getLogicalScope(CharacterFilter filter, char delimiter) {
        return this.logicalScopeFunction.apply(filter, Optional.of(Character.valueOf(delimiter)));
    }

    public static final class TestMetricGroupBuilder {
        private String[] scopeComponents = new String[0];
        private Map<String, String> variables = Collections.emptyMap();
        private BiFunction<String, Optional<CharacterFilter>, String> metricIdentifierFunction = (name, filter) -> filter.map(f -> f.filterCharacters(name)).orElse((String)name);
        private BiFunction<CharacterFilter, Optional<Character>, String> logicalScopeFunction = (characterFilter, character) -> "logicalScope";

        public TestMetricGroupBuilder setScopeComponents(String[] scopeComponents) {
            this.scopeComponents = scopeComponents;
            return this;
        }

        public TestMetricGroupBuilder setVariables(Map<String, String> variables) {
            this.variables = variables;
            return this;
        }

        public TestMetricGroupBuilder setMetricIdentifierFunction(BiFunction<String, Optional<CharacterFilter>, String> metricIdentifierFunction) {
            this.metricIdentifierFunction = metricIdentifierFunction;
            return this;
        }

        public TestMetricGroupBuilder setLogicalScopeFunction(BiFunction<CharacterFilter, Optional<Character>, String> logicalScopeFunction) {
            this.logicalScopeFunction = logicalScopeFunction;
            return this;
        }

        public TestMetricGroup build() {
            return new TestMetricGroup(this.scopeComponents, this.variables, this.metricIdentifierFunction, this.logicalScopeFunction);
        }
    }
}

