/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.plugin;

import com.alibaba.fluss.plugin.DefaultPluginManager;
import com.alibaba.fluss.plugin.DirectoryBasedPluginFinder;
import com.alibaba.fluss.plugin.OtherTestSpi;
import com.alibaba.fluss.plugin.PluginDescriptor;
import com.alibaba.fluss.plugin.PluginTestBase;
import com.alibaba.fluss.plugin.TestSpi;
import com.alibaba.fluss.plugin.jar.pluginb.TestServiceB;
import com.alibaba.fluss.shaded.guava32.com.google.common.collect.Lists;
import com.alibaba.fluss.utils.Preconditions;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class DefaultPluginManagerTest
extends PluginTestBase {
    @TempDir
    private Path tmp;
    private Collection<PluginDescriptor> descriptors;

    @BeforeEach
    public void setup() throws Exception {
        File pluginRootFolder = this.tmp.toFile();
        Path pluginRootFolderPath = pluginRootFolder.toPath();
        File pluginAFolder = new File(pluginRootFolder, "A");
        File pluginBFolder = new File(pluginRootFolder, "B");
        Preconditions.checkState((boolean)pluginAFolder.mkdirs());
        Preconditions.checkState((boolean)pluginBFolder.mkdirs());
        Files.copy(DefaultPluginManagerTest.locateJarFile("plugin-a-test-jar.jar").toPath(), Paths.get(pluginAFolder.toString(), "plugin-a-test-jar.jar"), new CopyOption[0]);
        Files.copy(DefaultPluginManagerTest.locateJarFile("plugin-b-test-jar.jar").toPath(), Paths.get(pluginBFolder.toString(), "plugin-b-test-jar.jar"), new CopyOption[0]);
        DirectoryBasedPluginFinder descriptorsFactory = new DirectoryBasedPluginFinder(pluginRootFolderPath);
        this.descriptors = descriptorsFactory.findPlugins();
        Preconditions.checkState((this.descriptors.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    void testPluginLoading() {
        String[] parentPatterns = new String[]{TestSpi.class.getName(), OtherTestSpi.class.getName()};
        DefaultPluginManager pluginManager = new DefaultPluginManager(this.descriptors, PARENT_CLASS_LOADER, parentPatterns);
        ArrayList serviceImplList = Lists.newArrayList((Iterator)pluginManager.load(TestSpi.class));
        Assertions.assertThat((int)serviceImplList.size()).isEqualTo(2);
        Set classLoaders = Collections.newSetFromMap(new IdentityHashMap(3));
        classLoaders.add(PARENT_CLASS_LOADER);
        for (TestSpi testSpi : serviceImplList) {
            Assertions.assertThat((String)testSpi.testMethod()).isNotNull();
            Assertions.assertThat((boolean)classLoaders.add(testSpi.getClass().getClassLoader())).isTrue();
        }
        ArrayList otherServiceImplList = Lists.newArrayList((Iterator)pluginManager.load(OtherTestSpi.class));
        Assertions.assertThat((int)otherServiceImplList.size()).isEqualTo(1);
        for (OtherTestSpi otherTestSpi : otherServiceImplList) {
            Assertions.assertThat((String)otherTestSpi.otherTestMethod()).isNotNull();
            Assertions.assertThat((boolean)classLoaders.add(otherTestSpi.getClass().getClassLoader())).isFalse();
        }
    }

    @Test
    void classLoaderMustBeTheSameInsideAPlugin() {
        String[] parentPatterns = new String[]{TestSpi.class.getName(), OtherTestSpi.class.getName()};
        DefaultPluginManager pluginManager = new DefaultPluginManager(this.descriptors, PARENT_CLASS_LOADER, parentPatterns);
        ArrayList serviceImplList = Lists.newArrayList((Iterator)pluginManager.load(TestSpi.class));
        Assertions.assertThat((int)serviceImplList.size()).isEqualTo(2);
        ArrayList otherServiceImplList = Lists.newArrayList((Iterator)pluginManager.load(OtherTestSpi.class));
        Assertions.assertThat((int)otherServiceImplList.size()).isEqualTo(1);
        List serviceBImplList = serviceImplList.stream().filter(s -> s.getClass().getName().equals(TestServiceB.class.getName())).collect(Collectors.toList());
        Assertions.assertThat((int)serviceBImplList.size()).isEqualTo(1);
        Assertions.assertThat((Object)((TestSpi)serviceBImplList.get(0)).getClass().getClassLoader()).isEqualTo((Object)((OtherTestSpi)otherServiceImplList.get(0)).getClass().getClassLoader());
    }
}

