/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.plugin;

import com.alibaba.fluss.plugin.OtherTestSpi;
import com.alibaba.fluss.plugin.PluginDescriptor;
import com.alibaba.fluss.plugin.PluginLoader;
import com.alibaba.fluss.plugin.PluginTestBase;
import com.alibaba.fluss.plugin.TestSpi;
import com.alibaba.fluss.plugin.jar.plugina.TestServiceA;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PluginLoaderTest
extends PluginTestBase {
    PluginLoaderTest() {
    }

    @Test
    void testPluginLoading() throws Exception {
        URL classpathA = this.createPluginJarURLFromString("plugin-a-test-jar.jar");
        String[] parentPatterns = new String[]{TestSpi.class.getName(), OtherTestSpi.class.getName()};
        PluginDescriptor pluginDescriptorA = new PluginDescriptor("A", new URL[]{classpathA}, parentPatterns);
        URLClassLoader pluginClassLoaderA = PluginLoader.createPluginClassLoader((PluginDescriptor)pluginDescriptorA, (ClassLoader)PARENT_CLASS_LOADER, (String[])new String[0]);
        Assertions.assertThat((Object)pluginClassLoaderA).isNotEqualTo((Object)PARENT_CLASS_LOADER);
        PluginLoader pluginLoaderA = new PluginLoader("test-plugin", pluginClassLoaderA);
        Iterator testSpiIteratorA = pluginLoaderA.load(TestSpi.class);
        Assertions.assertThat((boolean)testSpiIteratorA.hasNext()).isTrue();
        TestSpi testSpiA = (TestSpi)testSpiIteratorA.next();
        Assertions.assertThat((boolean)testSpiIteratorA.hasNext()).isFalse();
        Assertions.assertThat((String)testSpiA.testMethod()).isNotNull();
        Assertions.assertThat((String)testSpiA.getClass().getCanonicalName()).isEqualTo(TestServiceA.class.getCanonicalName());
        Assertions.assertThat((Object)testSpiA.getClassLoader()).isEqualTo((Object)pluginClassLoaderA);
        Assertions.assertThat((Object)testSpiA.getClass().getClassLoader()).isEqualTo((Object)pluginClassLoaderA);
        Assertions.assertThat((boolean)(testSpiA instanceof TestServiceA)).isFalse();
        PluginLoader secondPluginLoaderA = PluginLoader.create((PluginDescriptor)pluginDescriptorA, (ClassLoader)PARENT_CLASS_LOADER, (String[])new String[0]);
        TestSpi secondTestSpiA = (TestSpi)secondPluginLoaderA.load(TestSpi.class).next();
        Assertions.assertThat((String)secondTestSpiA.testMethod()).isNotNull();
        Assertions.assertThat((String)secondTestSpiA.getClass().getCanonicalName()).isEqualTo(testSpiA.getClass().getCanonicalName());
        Assertions.assertThat(secondTestSpiA.getClass()).isNotEqualTo(testSpiA.getClass());
    }

    @Test
    void testClose() throws MalformedURLException {
        URL classpathA = this.createPluginJarURLFromString("plugin-a-test-jar.jar");
        String[] parentPatterns = new String[]{TestSpi.class.getName()};
        PluginDescriptor pluginDescriptorA = new PluginDescriptor("A", new URL[]{classpathA}, parentPatterns);
        URLClassLoader pluginClassLoaderA = PluginLoader.createPluginClassLoader((PluginDescriptor)pluginDescriptorA, (ClassLoader)PARENT_CLASS_LOADER, (String[])new String[0]);
        PluginLoader pluginLoaderA = new PluginLoader("test-plugin", pluginClassLoaderA);
        pluginLoaderA.close();
        Assertions.assertThatExceptionOfType(ClassNotFoundException.class).isThrownBy(() -> pluginClassLoaderA.loadClass(Test.class.getName()));
    }
}

