/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.memory.MemorySegmentOutputView;
import com.alibaba.fluss.metadata.KvFormat;
import com.alibaba.fluss.record.DefaultKvRecordBatch;
import com.alibaba.fluss.record.KvRecord;
import com.alibaba.fluss.record.KvRecordBatch;
import com.alibaba.fluss.record.KvRecordReadContext;
import com.alibaba.fluss.record.KvTestBase;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.compacted.CompactedRow;
import com.alibaba.fluss.types.DataType;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultKvRecordBatchTest
extends KvTestBase {
    DefaultKvRecordBatchTest() {
    }

    @Test
    void writeAndReadBatch() throws Exception {
        int recordNumber = 100;
        DefaultKvRecordBatch.Builder builder = DefaultKvRecordBatch.Builder.builder((int)1, (MemorySegmentOutputView)new MemorySegmentOutputView(100), (KvFormat)KvFormat.COMPACTED);
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        ArrayList<CompactedRow> rows = new ArrayList<CompactedRow>();
        for (int i = 0; i < recordNumber; ++i) {
            byte[] key = new byte[]{(byte)i, (byte)i};
            CompactedRow row = i % 2 == 1 ? null : TestInternalRowGenerator.genCompactedRowForAllType();
            builder.append(key, (InternalRow)row);
            keys.add(key);
            rows.add(row);
        }
        DefaultKvRecordBatch kvRecords = builder.build();
        kvRecords.ensureValid();
        Assertions.assertThat((int)kvRecords.getRecordCount()).isEqualTo(recordNumber);
        Assertions.assertThat((byte)kvRecords.magic()).isEqualTo((byte)0);
        Assertions.assertThat((boolean)kvRecords.isValid()).isTrue();
        Assertions.assertThat((short)kvRecords.schemaId()).isEqualTo((short)1);
        int i = 0;
        for (KvRecord record : kvRecords.records((KvRecordBatch.ReadContext)KvRecordReadContext.createReadContext((KvFormat)KvFormat.COMPACTED, (DataType[])this.baseRowFieldTypes))) {
            Assertions.assertThat((byte[])DefaultKvRecordBatchTest.keyToBytes(record)).isEqualTo(keys.get(i));
            Assertions.assertThat((Object)record.getRow()).isEqualTo(rows.get(i));
            ++i;
        }
    }
}

