/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.memory.MemorySegment;
import com.alibaba.fluss.memory.MemorySegmentOutputView;
import com.alibaba.fluss.metadata.KvFormat;
import com.alibaba.fluss.record.DefaultKvRecord;
import com.alibaba.fluss.record.KvRecord;
import com.alibaba.fluss.record.KvRecordBatch;
import com.alibaba.fluss.record.KvRecordReadContext;
import com.alibaba.fluss.record.KvTestBase;
import com.alibaba.fluss.row.BinaryString;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.compacted.CompactedRow;
import com.alibaba.fluss.row.encode.CompactedRowEncoder;
import com.alibaba.fluss.types.DataType;
import com.alibaba.fluss.types.RowType;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultKvRecordTest
extends KvTestBase {
    DefaultKvRecordTest() {
    }

    @Test
    void testBase() throws Exception {
        CompactedRow row;
        KvRecordReadContext kvRecordReadContext = KvRecordReadContext.createReadContext((KvFormat)KvFormat.COMPACTED, (DataType[])this.baseRowFieldTypes);
        try (CompactedRowEncoder writer = new CompactedRowEncoder(this.baseRowFieldTypes);){
            writer.startNewRow();
            writer.encodeField(0, (Object)10);
            writer.encodeField(1, (Object)BinaryString.fromString((String)"abc"));
            row = writer.finishRow();
        }
        byte[] key = new byte[]{1, 2};
        DefaultKvRecord.writeTo((MemorySegmentOutputView)this.outputView, (byte[])key, (InternalRow)row);
        KvRecord kvRecord = DefaultKvRecord.readFrom((MemorySegment)MemorySegment.wrap((byte[])this.outputView.getCopyOfBuffer()), (int)0, (short)1, (KvRecordBatch.ReadContext)kvRecordReadContext);
        Assertions.assertThat((int)kvRecord.getSizeInBytes()).isEqualTo(13);
        Assertions.assertThat((byte[])DefaultKvRecordTest.keyToBytes(kvRecord)).isEqualTo((Object)key);
        Assertions.assertThat((Object)kvRecord.getRow()).isEqualTo((Object)row);
        key = new byte[]{2, 3};
        this.outputView = new MemorySegmentOutputView(100);
        DefaultKvRecord.writeTo((MemorySegmentOutputView)this.outputView, (byte[])key, null);
        kvRecord = DefaultKvRecord.readFrom((MemorySegment)MemorySegment.wrap((byte[])this.outputView.getCopyOfBuffer()), (int)0, (short)1, (KvRecordBatch.ReadContext)kvRecordReadContext);
        Assertions.assertThat((int)kvRecord.getSizeInBytes()).isEqualTo(7);
        Assertions.assertThat((byte[])DefaultKvRecordTest.keyToBytes(kvRecord)).isEqualTo((Object)key);
        Assertions.assertThat((Object)kvRecord.getRow()).isNull();
    }

    @Test
    void testWriteToAndReadFromWithRandomData() throws Exception {
        CompactedRow row = TestInternalRowGenerator.genCompactedRowForAllType();
        Random rnd = new Random();
        byte[] key = TestInternalRowGenerator.generateRandomBytes(rnd);
        DefaultKvRecord.writeTo((MemorySegmentOutputView)this.outputView, (byte[])key, (InternalRow)row);
        RowType rowType = TestInternalRowGenerator.createAllRowType();
        DataType[] colTypes = rowType.getChildren().toArray(new DataType[0]);
        KvRecord kvRecord = DefaultKvRecord.readFrom((MemorySegment)MemorySegment.wrap((byte[])this.outputView.getCopyOfBuffer()), (int)0, (short)1, (KvRecordBatch.ReadContext)KvRecordReadContext.createReadContext((KvFormat)KvFormat.COMPACTED, (DataType[])colTypes));
        Assertions.assertThat((byte[])DefaultKvRecordTest.keyToBytes(kvRecord)).isEqualTo((Object)key);
        Assertions.assertThat((Object)kvRecord.getRow()).isEqualTo((Object)row);
    }
}

