/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fluss.record;

import com.alibaba.fluss.memory.MemorySegmentOutputView;
import com.alibaba.fluss.record.LogRecord;
import com.alibaba.fluss.record.LogRecordBatch;
import com.alibaba.fluss.record.LogRecordReadContext;
import com.alibaba.fluss.record.LogTestBase;
import com.alibaba.fluss.record.MemoryLogRecords;
import com.alibaba.fluss.record.MemoryLogRecordsIndexedBuilder;
import com.alibaba.fluss.record.RowKind;
import com.alibaba.fluss.record.TestData;
import com.alibaba.fluss.row.InternalRow;
import com.alibaba.fluss.row.TestInternalRowGenerator;
import com.alibaba.fluss.row.indexed.IndexedRow;
import com.alibaba.fluss.testutils.DataTestUtils;
import com.alibaba.fluss.types.RowType;
import com.alibaba.fluss.utils.CloseableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultLogRecordBatchTest
extends LogTestBase {
    @Test
    void testRecordBatchSize() throws Exception {
        MemoryLogRecords memoryLogRecords = DataTestUtils.genMemoryLogRecordsByObject(TestData.DATA1);
        int totalSize = 0;
        for (LogRecordBatch logRecordBatch : memoryLogRecords.batches()) {
            totalSize += logRecordBatch.sizeInBytes();
        }
        Assertions.assertThat((int)totalSize).isEqualTo(memoryLogRecords.sizeInBytes());
    }

    @Test
    void testIndexedRowWriteAndReadBatch() throws Exception {
        int recordNumber = 50;
        RowType allRowType = TestInternalRowGenerator.createAllRowType();
        MemoryLogRecordsIndexedBuilder builder = MemoryLogRecordsIndexedBuilder.builder((long)0L, (int)1, (int)Integer.MAX_VALUE, (byte)0, (MemorySegmentOutputView)this.outputView);
        ArrayList<IndexedRow> rows = new ArrayList<IndexedRow>();
        for (int i = 0; i < recordNumber; ++i) {
            IndexedRow row = TestInternalRowGenerator.genIndexedRowForAllType();
            builder.append(RowKind.INSERT, (InternalRow)row);
            rows.add(row);
        }
        MemoryLogRecords memoryLogRecords = builder.build();
        Iterator iterator = memoryLogRecords.batches().iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        LogRecordBatch logRecordBatch = (LogRecordBatch)iterator.next();
        logRecordBatch.ensureValid();
        Assertions.assertThat((int)logRecordBatch.getRecordCount()).isEqualTo(recordNumber);
        Assertions.assertThat((long)logRecordBatch.baseLogOffset()).isEqualTo(0L);
        Assertions.assertThat((long)logRecordBatch.lastLogOffset()).isEqualTo(0L + (long)recordNumber - 1L);
        Assertions.assertThat((long)logRecordBatch.nextLogOffset()).isEqualTo(0L + (long)recordNumber);
        Assertions.assertThat((byte)logRecordBatch.magic()).isEqualTo((byte)0);
        Assertions.assertThat((boolean)logRecordBatch.isValid()).isTrue();
        Assertions.assertThat((short)logRecordBatch.schemaId()).isEqualTo((short)1);
        int i = 0;
        try (LogRecordReadContext readContext = LogRecordReadContext.createIndexedReadContext((RowType)allRowType, (int)1);
             CloseableIterator iter = logRecordBatch.records((LogRecordBatch.ReadContext)readContext);){
            while (iter.hasNext()) {
                LogRecord record = (LogRecord)iter.next();
                Assertions.assertThat((long)record.logOffset()).isEqualTo((long)i);
                Assertions.assertThat((Comparable)record.getRowKind()).isEqualTo((Object)RowKind.INSERT);
                Assertions.assertThat((Object)record.getRow()).isEqualTo(rows.get(i));
                ++i;
            }
        }
    }
}

